/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.external.api.BusiApplyInvoiceService;
import com.tydic.pfscext.external.api.bo.BusiApplyInvoiceReqBO;
import com.tydic.pfscext.external.api.bo.BusiApplyInvoiceRspBO;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.ESBParamUtil;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiApplyInvoiceServiceImpl
implements BusiApplyInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(BusiApplyInvoiceServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private Environment prop;

    @Override
    public BusiApplyInvoiceRspBO applyInvoice(BusiApplyInvoiceReqBO reqBO) {
        if (this.isDebugEnabled) {
            log.debug("\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null == reqBO.getSupplierId()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u4f9b\u5e94\u5546ID[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierOrder()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[supplierOrder]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getMarkId()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[markId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSettlementId()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[settlementId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceType()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[invoiceType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceOrg()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[invoiceOrg]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getBizInvoiceContent()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[bizInvoiceContent]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceDate()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[invoiceDate]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getTitle()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[title]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceNum()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[invoiceNum]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoicePrice()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[invoicePrice]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getCurrentBatch()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[currentBatch]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getTotalBatch()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[totalBatch]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getTotalBatchInvoiceAmount()) {
            throw new PfscExternalBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1 \u6d88\u606f\u7c7b\u578b[totalBatchInvoiceAmount]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            String hsn = this.prop.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
            String reqStr = "jd".equals(hsn) ? this.initJdReqStr(reqBO) : this.initReqStr(reqBO);
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_PAY");
            log.debug("\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b014" + reqEsbStr);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_INVOICE_APPLY_JD_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u5f00\u7968\u901a\u77e5\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_INVOICE_APPLY_JD_URL") + "]");
            }
            log.info("\u8c03\u7528\u5f00\u7968\u901a\u77e5\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u8c03\u7528\u5f00\u7968\u901a\u77e5\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            BusiApplyInvoiceRspBO invoiceRsp = this.resolveRsp(returnString);
            return invoiceRsp;
        }
        catch (Exception e) {
            e.printStackTrace();
            String resultCode = "";
            BusiApplyInvoiceRspBO busiApplyInvoiceRspBO = new BusiApplyInvoiceRspBO();
            busiApplyInvoiceRspBO.setResultCode("18000");
            busiApplyInvoiceRspBO.setSuccess(false);
            busiApplyInvoiceRspBO.setResultCode("\u8c03\u7528\u5f00\u7968\u901a\u77e5\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
            return busiApplyInvoiceRspBO;
        }
    }

    private String initReqStr(BusiApplyInvoiceReqBO reqBO) {
        StringBuffer supOrSB = new StringBuffer();
        supOrSB.append("[");
        for (int i = 0; i < reqBO.getSupplierOrder().size(); ++i) {
            if (i == 0) {
                supOrSB.append("\"" + reqBO.getSupplierOrder().get(i) + "\"");
                continue;
            }
            supOrSB.append(",").append("\"" + reqBO.getSupplierOrder().get(i) + "\"");
        }
        supOrSB.append("]");
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"supplierOrder\":").append(supOrSB + ",").append("\"markId\":").append("\"" + reqBO.getMarkId() + "\",").append("\"settlementId\":").append("\"" + reqBO.getSettlementId() + "\",").append("\"invoiceType\":").append("" + reqBO.getInvoiceType() + ",").append("\"invoiceOrg\":").append("\"" + reqBO.getInvoiceOrg() + "\",").append("\"bizInvoiceContent\":").append("" + reqBO.getBizInvoiceContent() + ",").append("\"invoiceDate\":").append("\"" + reqBO.getInvoiceDate() + "\",").append("\"title\":").append("\"" + reqBO.getTitle() + "\",").append("\"invoiceNum\":").append("" + reqBO.getInvoiceNum() + ",").append("\"invoicePrice\":").append("" + reqBO.getInvoicePrice() + ",").append("\"currentBatch\":").append("\"" + reqBO.getCurrentBatch() + "\",").append("\"totalBatch\":").append("" + reqBO.getTotalBatch() + ",").append("\"totalBatchInvoiceAmount\":").append("" + reqBO.getTotalBatchInvoiceAmount() + ",").append("\"enterpriseTaxpayer\":").append("\"" + reqBO.getEnterpriseTaxpayer() + "\",").append("\"address\":").append("\"" + reqBO.getAddress() + "\",").append("\"tel\":").append("\"" + reqBO.getTel() + "\",").append("\"bank\":").append("\"" + reqBO.getBank() + "\",").append("\"account\":").append("\"" + reqBO.getAccount() + "\",").append("\"billToParty\":").append("\"" + reqBO.getBillToParty() + "\",").append("\"billToer\":").append("\"" + reqBO.getBillToer() + "\",").append("\"billToContact\":").append("\"" + reqBO.getBillToContact() + "\",").append("\"billToProvince\":").append("" + reqBO.getBillToProvince() + ",").append("\"billToCity\":").append("" + reqBO.getBillToCity() + ",").append("\"billToCounty\":").append("" + reqBO.getBillToCounty() + ",").append("\"billToTown\":").append("" + reqBO.getBillToTown() + ",").append("\"billToAddress\":").append("\"" + reqBO.getBillToAddress() + "\"").append("}");
        return sb.toString();
    }

    private String initJdReqStr(BusiApplyInvoiceReqBO reqBO) {
        StringBuffer supOrSB = new StringBuffer();
        supOrSB.append("[");
        for (int i = 0; i < reqBO.getSupplierOrder().size(); ++i) {
            if (i == 0) {
                supOrSB.append("\"" + reqBO.getSupplierOrder().get(i) + "\"");
                continue;
            }
            supOrSB.append(",").append("\"" + reqBO.getSupplierOrder().get(i) + "\"");
        }
        supOrSB.append("]");
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"supplierOrder\":").append(supOrSB + ",").append("\"markId\":").append("\"" + reqBO.getMarkId() + "\",").append("\"settlementId\":").append("\"" + reqBO.getSettlementId() + "\",").append("\"invoiceType\":").append("" + reqBO.getInvoiceType() + ",").append("\"invoiceOrg\":").append("\"" + reqBO.getInvoiceOrg() + "\",").append("\"bizInvoiceContent\":").append("" + reqBO.getBizInvoiceContent() + ",").append("\"invoiceDate\":").append("\"" + reqBO.getInvoiceDate() + "\",").append("\"title\":").append("\"" + reqBO.getTitle() + "\",").append("\"invoiceNum\":").append("" + reqBO.getInvoiceNum() + ",").append("\"invoicePrice\":").append("" + reqBO.getInvoicePrice() + ",").append("\"currentBatch\":").append("\"" + reqBO.getCurrentBatch() + "\",").append("\"totalBatch\":").append("" + reqBO.getTotalBatch() + ",").append("\"totalBatchInvoiceAmount\":").append("" + reqBO.getTotalBatchInvoiceAmount() + ",").append("\"enterpriseTaxpayer\":").append("\"" + reqBO.getEnterpriseTaxpayer() + "\",").append("\"enterpriseRegAddress\":").append("\"" + reqBO.getAddress() + "\",").append("\"enterpriseRegPhone\":").append("\"" + reqBO.getTel() + "\",").append("\"enterpriseBankName\":").append("\"" + reqBO.getBank() + "\",").append("\"enterpriseBankAccount\":").append("\"" + reqBO.getAccount() + "\",").append("\"billToParty\":").append("\"" + reqBO.getBillToParty() + "\",").append("\"billToer\":").append("\"" + reqBO.getBillToer() + "\",").append("\"billToContact\":").append("\"" + reqBO.getBillToContact() + "\",").append("\"billToProvince\":").append("" + reqBO.getBillToProvince() + ",").append("\"billToCity\":").append("" + reqBO.getBillToCity() + ",").append("\"billToCounty\":").append("" + reqBO.getBillToCounty() + ",").append("\"billToTown\":").append("" + reqBO.getBillToTown() + ",").append("\"billToAddress\":").append("\"" + reqBO.getBillToAddress() + "\"").append("}");
        return sb.toString();
    }

    private BusiApplyInvoiceRspBO resolveRsp(String returnString) {
        BusiApplyInvoiceRspBO rspBO = new BusiApplyInvoiceRspBO();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setSuccess((Boolean)rspJsonObject.get((Object)"success"));
            rspBO.setResultCode((String)rspJsonObject.get((Object)"resultCode"));
            rspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                log.debug("\u8c03\u7528\u5f00\u7968\u901a\u77e5\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e);
            }
            throw new RuntimeException("\u8c03\u7528\u5f00\u7968\u901a\u77e5\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + e);
        }
        return rspBO;
    }
}

