/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.external.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StringUtils;

public class PropertiesUtil {
    private static final Properties props = new Properties();
    private static final String CONFIG_PATH_ARG = "config.path";
    private static final String classPathFIleName = "default.properties";

    public static String getProperty(String key) {
        return props.getProperty(key);
    }

    public static int getIntProperty(String key) {
        return Integer.parseInt(props.getProperty(key));
    }

    public static boolean getBooleanProperty(String key) {
        return Boolean.getBoolean(props.getProperty(key));
    }

    public static String getProperty(String key, String defaultValue) {
        return props.getProperty(key, defaultValue);
    }

    static {
        String configPath = System.getProperty(CONFIG_PATH_ARG);
        if (!StringUtils.isEmpty((Object)configPath)) {
            try {
                System.out.println("\u4ece\u5916\u7f6e\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u914d\u7f6e\uff0c\u5916\u7f6e\u8def\u5f84\u4e3a\uff1a" + configPath);
                props.load(new FileInputStream(configPath));
                System.out.println("\u5916\u7f6e\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u6210\u529f");
            }
            catch (IOException e) {
                System.err.println("\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u5f02\u5e38\uff1a" + e.getMessage());
                System.exit(-1);
            }
        } else {
            try {
                System.out.println("\u4ececlasspath\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6 start");
                props.load(new ClassPathResource(classPathFIleName).getInputStream());
                System.out.println("\u4ececlasspath\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u6210\u529f");
            }
            catch (IOException e) {
                System.err.println("\u4ececlasspath\u52a0\u8f7d\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
                System.exit(-1);
            }
        }
    }
}

