/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiApplyMailForInvoiceService;
import com.tydic.pfscext.api.busi.bo.BusiApplyMailForInvoiceReqBO;
import com.tydic.pfscext.api.busi.bo.BusiApplyMailForInvoiceRspBO;
import com.tydic.pfscext.api.busi.bo.QueryBillApplyForMailReqBO;
import com.tydic.pfscext.api.busi.vo.BusiApplyMailVO;
import com.tydic.pfscext.api.busi.vo.InvoiceForMailVO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceMailInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.JdexpressToken;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.dao.po.SaleInvoiceMailInfo;
import com.tydic.pfscext.enums.InvoiceMailSentStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiJdExpressService;
import com.tydic.pfscext.external.api.bo.JdexpressTokenVO;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.JdExpressTokenService;
import com.tydic.pfscext.service.busi.impl.BusiApplyMailForImportInvoiceService;
import com.tydic.pfscext.service.busi.impl.BusiApplyMailForInvoiceRunnable;
import com.tydic.pfscext.utils.FscStringUtils;
import com.tydic.pfscext.utils.SpringApplicationContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiApplyMailForInvoiceService"})
public class BusiApplyMailForInvoiceServiceImpl
implements BusiApplyMailForInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(BusiApplyMailForInvoiceServiceImpl.class);
    @Autowired
    private SaleInvoiceMailInfoMapper saleInvoiceMailInfoMapper;
    @Autowired
    private BusiJdExpressService busiJdExpressConfigService;
    @Autowired
    private JdExpressTokenService jdExpressTokenService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired(required=false)
    private BusiApplyMailForImportInvoiceService busiApplyMailForImportInvoiceService;

    @PostMapping(value={"makeMailForInvoice"})
    public BusiApplyMailForInvoiceRspBO makeMailForInvoice(@RequestBody BusiApplyMailForInvoiceReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d1\u8d77\u90ae\u5bc4\u53d1\u7968\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getCompanyId() == null) {
            throw new PfscExtBusinessException("0001", "\u4e13\u4e1a\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSenderName())) {
            throw new PfscExtBusinessException("0001", "\u5bc4\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSenderAddr())) {
            throw new PfscExtBusinessException("0001", "\u5bc4\u65b9\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSenderPhone())) {
            throw new PfscExtBusinessException("0001", "\u5bc4\u65b9\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getApplyMailVoList() == null || reqBO.getApplyMailVoList().isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u52fe\u9009");
        }
        if ("1".equals(((BusiApplyMailVO)reqBO.getApplyMailVoList().get(0)).getIsImport())) {
            this.busiApplyMailForImportInvoiceService.process(reqBO);
            return new BusiApplyMailForInvoiceRspBO();
        }
        DataSourceTransactionManager transactionManager = SpringApplicationContext.getTransactionManager();
        DefaultTransactionDefinition transDefinition = new DefaultTransactionDefinition();
        transDefinition.setPropagationBehavior(3);
        TransactionStatus transactionStatus = transactionManager.getTransaction((TransactionDefinition)transDefinition);
        List<BusiApplyMailForInvoiceRunnable> runnables = null;
        try {
            runnables = this.process(reqBO);
            transactionManager.commit(transactionStatus);
        }
        catch (Exception e) {
            logger.error("\u90ae\u5bc4\u5931\u8d25", (Throwable)e);
            transactionManager.rollback(transactionStatus);
            throw new PfscExtBusinessException("18000", e.getMessage());
        }
        int size = runnables.size();
        logger.debug("\u9700\u8981\u90ae\u5bc4\u7684\u5feb\u9012\u5355\u6570\u91cf\uff1a" + size);
        int maxThreadSize = this.enumsService.queryMaxThreadSize();
        ExecutorService executorService = Executors.newFixedThreadPool(size > maxThreadSize ? maxThreadSize : size);
        CountDownLatch latch = new CountDownLatch(size);
        for (BusiApplyMailForInvoiceRunnable runnable : runnables) {
            runnable.setLatch(latch);
            executorService.submit(runnable);
        }
        executorService.shutdown();
        try {
            latch.await(this.enumsService.queryMaxSleepTime(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        BusiApplyMailForInvoiceRspBO rspBO = new BusiApplyMailForInvoiceRspBO();
        return rspBO;
    }

    private List<BusiApplyMailForInvoiceRunnable> process(BusiApplyMailForInvoiceReqBO reqBO) {
        JdexpressTokenVO tokenVO = new JdexpressTokenVO();
        JdexpressToken token = this.jdExpressTokenService.getToken(reqBO.getCompanyId());
        if (null == token) {
            throw new PfscExtBusinessException("18000", "token\u4fe1\u606f\u672a\u7ef4\u62a4,\u8bf7\u5148\u7ef4\u62a4");
        }
        BeanUtils.copyProperties((Object)token, (Object)tokenVO);
        List toMailList = reqBO.getApplyMailVoList();
        List mailTicketNos = new ArrayList();
        int toMailCount = toMailList.size();
        try {
            if (toMailCount > 100) {
                int circleTimes = toMailCount % 100 > 0 ? toMailCount / 100 + 1 : toMailCount / 100;
                for (int i = 0; i < circleTimes; ++i) {
                    int count = i == circleTimes - 1 && toMailCount % 100 > 0 ? toMailCount % 100 : 100;
                    mailTicketNos.addAll(this.busiJdExpressConfigService.applyBillCode(count, tokenVO));
                }
            } else {
                mailTicketNos = this.busiJdExpressConfigService.applyBillCode(toMailCount, tokenVO);
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u4eac\u4e1c-\u7533\u8bf7\u5feb\u9012\u5355\u53f7\u63a5\u53e3\u51fa\u9519", (Throwable)e);
            throw new PfscExtBusinessException("18005", "\u8c03\u7528\u4eac\u4e1c-\u7533\u8bf7\u5feb\u9012\u5355\u53f7\u63a5\u53e3\u51fa\u9519", e);
        }
        if (null == mailTicketNos) {
            throw new PfscExtBusinessException("18005", "\u7533\u8bf7\u5feb\u9012\u5355\u53f7\u5931\u8d25");
        }
        if (mailTicketNos.size() < toMailCount) {
            logger.error("\u6ca1\u6709\u7533\u8bf7\u5230\u8db3\u591f\u6570\u91cf\u7684\u5feb\u9012\u5355\u53f7\uff0c\u9700\u8981\u7684\u6570\u91cf\uff1a" + toMailCount + "\uff0c\u7533\u8bf7\u7684\u6570\u91cf\uff1a" + mailTicketNos.size());
            throw new PfscExtBusinessException("18005", "\u6ca1\u6709\u7533\u8bf7\u5230\u8db3\u591f\u6570\u91cf\u7684\u5feb\u9012\u5355\u53f7");
        }
        ArrayList<BusiApplyMailForInvoiceRunnable> runnables = new ArrayList<BusiApplyMailForInvoiceRunnable>();
        QueryBillApplyForMailReqBO condition = new QueryBillApplyForMailReqBO();
        condition.setSource(reqBO.getSource());
        condition.setCompanyId(reqBO.getCompanyId());
        ArrayList<BusiApplyMailVO> keyFields = new ArrayList<BusiApplyMailVO>();
        condition.setKeyFields(keyFields);
        for (BusiApplyMailVO toMail : toMailList) {
            BusiApplyMailVO keyField = new BusiApplyMailVO();
            keyFields.add(keyField);
            keyField.setInvoceName(toMail.getInvoceName());
            keyField.setName(toMail.getName());
        }
        List<InvoiceForMailVO> invoiceForMailVOs = this.saleInvoiceMailInfoMapper.queryToMailInvoice(condition, null);
        int i = 0;
        for (BusiApplyMailVO toMail : toMailList) {
            String mailTicketNo = (String)mailTicketNos.get(i++);
            ArrayList<InvoiceForMailVO> invoices = new ArrayList<InvoiceForMailVO>();
            Iterator<InvoiceForMailVO> iterator = invoiceForMailVOs.iterator();
            while (iterator.hasNext()) {
                InvoiceForMailVO invoice = iterator.next();
                if (!toMail.getInvoceName().equals(invoice.getInvoceName()) || !toMail.getName().equals(invoice.getName())) continue;
                invoices.add(invoice);
                iterator.remove();
            }
            if (invoices.isEmpty()) continue;
            InvoiceForMailVO firstInvoice = (InvoiceForMailVO)invoices.get(0);
            BillApplyInfo applyInfoPO = this.billApplyInfoMapper.selectByPrimaryKey(firstInvoice.getApplyNo());
            String province = FscStringUtils.valueOf(applyInfoPO.getProvince());
            String city = FscStringUtils.valueOf(applyInfoPO.getCity());
            String county = FscStringUtils.valueOf(applyInfoPO.getCounty());
            String town = FscStringUtils.valueOf(applyInfoPO.getTown());
            String addrDesc = FscStringUtils.valueOf(applyInfoPO.getAddrDesc());
            String addressStr = FscStringUtils.simplifyAddrdesc(province, city, county, town, addrDesc);
            SaleInvoiceMailInfo po = new SaleInvoiceMailInfo();
            po.setMailTicketNo(mailTicketNo);
            po.setOperUnitNo(reqBO.getCompanyId());
            po.setInvoiceType(firstInvoice.getInvoiceType());
            po.setInvoceName(toMail.getInvoceName());
            po.setMailStatus(InvoiceMailSentStatus.PROCCESSING.getCode());
            po.setAddress(addressStr);
            po.setReceiver(toMail.getName());
            po.setTel(applyInfoPO.getMobile());
            po.setJdAssignStatus(null);
            po.setFailReason(null);
            po.setCreateUser(reqBO.getUsername());
            po.setCreateDate(new Date());
            po.setSender(reqBO.getSenderName());
            po.setSenderAddress(reqBO.getSenderAddr());
            po.setSenderTel(reqBO.getSenderPhone());
            this.saleInvoiceMailInfoMapper.insert(po);
            for (int j = 0; j < invoices.size(); ++j) {
                InvoiceForMailVO invoice = (InvoiceForMailVO)invoices.get(j);
                SaleInvoiceInfo saleInvoiceInfo = new SaleInvoiceInfo();
                saleInvoiceInfo.setInvoiceNo(invoice.getInvoiceNo());
                saleInvoiceInfo.setMailTicketNo(mailTicketNo);
                saleInvoiceInfo.setOrderId(j + 1);
                this.saleInvoiceInfoMapper.updateByPrimaryKeySelective(saleInvoiceInfo);
            }
            BusiApplyMailForInvoiceRunnable runnable = new BusiApplyMailForInvoiceRunnable();
            runnable.setJdToken(tokenVO);
            runnable.setMailTicketNo(mailTicketNo);
            runnables.add(runnable);
        }
        return runnables;
    }
}

