/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiPayResultModifyService;
import com.tydic.pfscext.api.busi.bo.BusiPayResultModifyReqBO;
import com.tydic.pfscext.api.busi.bo.BusiPayResultModifyRspBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.PayableService;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiPayResultModifyService"})
public class BusiPayResultModifyServiceImpl
implements BusiPayResultModifyService {
    private static final Logger logger = LoggerFactory.getLogger(BusiPayResultModifyServiceImpl.class);
    @Autowired
    private PayableService payableService;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;

    @PostMapping(value={"modifyResult"})
    public BusiPayResultModifyRspBO modifyResult(@RequestBody BusiPayResultModifyReqBO busiPayResultModifyReqBO) {
        logger.info("\u4ed8\u6b3e\u5355\u7ed3\u679c\u5f55\u5165BO=" + busiPayResultModifyReqBO);
        Long payNo = busiPayResultModifyReqBO.getPayNo();
        if (payNo == null) {
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u5355\u53f7(payNo)\u5fc5\u987b\u8f93\u5165");
        }
        String sta = busiPayResultModifyReqBO.getStatus();
        PayResultStatus newStatus = PayResultStatus.getInstance(sta);
        if (newStatus == null) {
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u7ed3\u679c\u72b6\u6001\u4e0d\u5408\u6cd5");
        }
        if (newStatus == PayResultStatus.APPLYING) {
            throw new PfscExtBusinessException("0001", "\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u72b6\u6001\u4e3a" + PayResultStatus.APPLYING.getDescr());
        }
        ApplyPayInfoPO applyPay = this.applyPayInfoMapper.getModelById(payNo);
        if (applyPay == null) {
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u5355" + payNo + "\u4e0d\u5b58\u5728");
        }
        PayResultStatus nowSta = PayResultStatus.getInstance(applyPay.getPayStatus());
        if (nowSta == null) {
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u5355\u7684\u72b6\u6001\u6570\u636e\u5f02\u5e38");
        }
        if (nowSta != PayResultStatus.APPLYING && nowSta != PayResultStatus.FAILED) {
            throw new PfscExtBusinessException("0001", "\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
        if (nowSta == PayResultStatus.FAILED && newStatus == PayResultStatus.FAILED) {
            throw new PfscExtBusinessException("0001", "\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u72b6\u6001\u4e3a" + PayResultStatus.FAILED.getDescr());
        }
        List<ApplyDetail> details = this.applyDetailMapper.selectPayableList(payNo);
        int size = details.size();
        if (size == 0) {
            throw new PfscExtBusinessException("0001", "\u672a\u627e\u5230\u6b64\u4ed8\u6b3e\u5355\u4e0b\u7684\u5e94\u4ed8\u6b3e\u5355\u660e\u7ec6\u8bb0\u5f55");
        }
        logger.info("\u4ed8\u6b3e\u5355\u8bbe\u7f6e\u4ed8\u6b3e\u7ed3\u679c,\u6d89\u53ca\u5e94\u4ed8\u5355\u6570\u91cf=" + size + ",\u4ed8\u6b3e\u5355\u53f7=" + payNo);
        if (newStatus != PayResultStatus.FAILED) {
            for (int i = 0; i < details.size(); ++i) {
                ApplyDetail detail = details.get(i);
                BigDecimal amount = detail.getAmt();
                String payableNo = detail.getPayableNo();
                if (newStatus == PayResultStatus.CANCEL) {
                    this.payableService.cancelPay(payableNo, amount);
                    continue;
                }
                if (newStatus != PayResultStatus.SUCCESS) continue;
                this.payableService.completePay(payableNo, amount);
            }
        }
        applyPay.setPayStatus(newStatus.getCode());
        applyPay.setRemark(busiPayResultModifyReqBO.getRemark());
        applyPay.setOperatorId(busiPayResultModifyReqBO.getUserId());
        this.applyPayInfoMapper.updateStatus(applyPay);
        ApplyDetail applyDetail = new ApplyDetail();
        applyDetail.setApplyNo(payNo);
        applyDetail.setStatus(newStatus.getCode());
        this.applyDetailMapper.updateByApplyNo(applyDetail);
        logger.info("\u4ed8\u6b3e\u5355[" + payNo + "]\u7684\u72b6\u6001\u6210\u529f\u7531[" + nowSta.getCodeDescr() + "]\u53d8\u4e3a" + newStatus.getCodeDescr() + "\u64cd\u4f5c\u4eba=" + applyPay.getOperatorId());
        BusiPayResultModifyRspBO resp = new BusiPayResultModifyRspBO();
        return resp;
    }
}

