/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.QueryApplyPayInfoService;
import com.tydic.pfscext.api.busi.bo.ApplyPayInfoBO;
import com.tydic.pfscext.api.busi.bo.PurchaseOrderDetailInfoRspBO;
import com.tydic.pfscext.api.busi.bo.QueryApplyPayInfoReqBO;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.vo.ApplyPayInfoVO;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.FinancialStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.enums.WFStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.atom.UserInfoService;
import com.tydic.pfscext.utils.AntiSqlInjectionManage;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.QueryApplyPayInfoService"})
public class QueryApplyPayInfoServiceImpl
implements QueryApplyPayInfoService {
    private static final Logger logger = LoggerFactory.getLogger(QueryApplyPayInfoServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private PayableDetailMapper payableDetailMapper;

    @PostMapping(value={"queryListPage"})
    public PfscExtRspPageBaseBO<ApplyPayInfoBO> queryListPage(@RequestBody QueryApplyPayInfoReqBO queryApplyPayInfoReqBO) {
        String orderBy;
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u4ed8\u6b3e\u7533\u8bf7\u670d\u52a1\u5165\u53c2\uff1a" + queryApplyPayInfoReqBO.toString());
        }
        PfscExtRspPageBaseBO rspPageBO = new PfscExtRspPageBaseBO();
        ApplyPayInfoVO applyPayInfoVO = new ApplyPayInfoVO();
        BeanUtils.copyProperties((Object)queryApplyPayInfoReqBO, (Object)applyPayInfoVO);
        if (queryApplyPayInfoReqBO.getSupplierId() != null) {
            applyPayInfoVO.setSupplierId(queryApplyPayInfoReqBO.getSupplierId());
        }
        if (queryApplyPayInfoReqBO.getSource() != null) {
            applyPayInfoVO.setSource(queryApplyPayInfoReqBO.getSource());
        }
        if (!StringUtils.isEmpty((CharSequence)queryApplyPayInfoReqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)queryApplyPayInfoReqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(queryApplyPayInfoReqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(queryApplyPayInfoReqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new PfscExtBusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = queryApplyPayInfoReqBO.getSortName() + " " + queryApplyPayInfoReqBO.getSortOrder();
        } else {
            orderBy = " PAYNO desc";
        }
        Page page = new Page(queryApplyPayInfoReqBO.getPageNo() < 1 ? 1 : queryApplyPayInfoReqBO.getPageNo(), queryApplyPayInfoReqBO.getPageSize() < 1 ? 10 : queryApplyPayInfoReqBO.getPageSize());
        BeanUtils.copyProperties((Object)queryApplyPayInfoReqBO, (Object)applyPayInfoVO);
        applyPayInfoVO.setCompanyId(queryApplyPayInfoReqBO.getCompanyId());
        Date startDate = queryApplyPayInfoReqBO.getApplyDateStart();
        Date endDate = queryApplyPayInfoReqBO.getApplyDateEnd();
        List<ApplyPayInfoVO> applyPayInfoVOs = this.applyPayInfoMapper.getListPageByTermsExt(applyPayInfoVO, startDate, endDate, (Page<Map<String, Object>>)page, orderBy);
        LinkedList<ApplyPayInfoBO> applyPayInfoBOs = new LinkedList<ApplyPayInfoBO>();
        if (!applyPayInfoVOs.isEmpty()) {
            Iterator<ApplyPayInfoVO> iterator = applyPayInfoVOs.iterator();
            while (iterator.hasNext()) {
                ApplyPayInfoVO payInfoVO;
                applyPayInfoVO = payInfoVO = iterator.next();
                ApplyPayInfoBO applyPayInfoBO = new ApplyPayInfoBO();
                BeanUtils.copyProperties((Object)applyPayInfoVO, (Object)applyPayInfoBO);
                OrderSource orderSourceEnum = OrderSource.getInstance((String)String.valueOf(applyPayInfoBO.getSource()));
                applyPayInfoBO.setSourceStr(this.enumsService.getDescr((BaseEnums)orderSourceEnum));
                String supplierStr = this.organizationInfoService.querySupplierName(applyPayInfoBO.getSupplierId());
                applyPayInfoBO.setSupplierStr(supplierStr);
                PayResultStatus payResultEnum = PayResultStatus.getInstance(applyPayInfoBO.getPayStatus());
                applyPayInfoBO.setPayStatusStr(this.enumsService.getDescr(payResultEnum));
                String operName = this.userInfoService.queryUserNameByUserId(applyPayInfoBO.getOperatorId());
                applyPayInfoBO.setOperatorName(operName);
                applyPayInfoBO.setBranchCompanyName(this.organizationInfoService.queryOrgName(applyPayInfoVO.getBranchCompany()));
                PayResultStatus sta = PayResultStatus.getInstance(applyPayInfoBO.getPayStatus());
                if (sta == PayResultStatus.CANCEL || sta == PayResultStatus.SUCCESS) {
                    applyPayInfoBO.setApplyClosed("Y");
                } else {
                    applyPayInfoBO.setApplyClosed("N");
                }
                if (StringUtils.isNotBlank((CharSequence)applyPayInfoBO.getFinancialStatus())) {
                    applyPayInfoBO.setFinancialStatusDescr(this.enumsService.getDescr(FinancialStatus.getInstance(applyPayInfoBO.getFinancialStatus())));
                }
                if (StringUtils.isNotBlank((CharSequence)applyPayInfoBO.getApprovalStatus())) {
                    applyPayInfoBO.setApprovalStatusDescr(this.enumsService.getDescr(WFStatus.getInstance(applyPayInfoBO.getApprovalStatus())));
                    if (WFStatus.APPROVAL_COMPLETE.getCode().equals(applyPayInfoBO.getApprovalStatus())) {
                        if (StringUtils.isNotBlank((CharSequence)applyPayInfoBO.getFinancialStatusDescr())) {
                            applyPayInfoBO.setApprovalStatusDescr(applyPayInfoBO.getApprovalStatusDescr() + "(" + applyPayInfoBO.getFinancialStatusDescr() + ")");
                        } else {
                            applyPayInfoBO.setApprovalStatusDescr(applyPayInfoBO.getApprovalStatusDescr() + "(\u53d1\u9001\u8d22\u52a1\u4e2d)");
                        }
                    }
                }
                applyPayInfoBO.setLastOperator(this.userInfoService.queryUserNameByUserId(applyPayInfoVO.getLastOperator()));
                LinkedList<PurchaseOrderDetailInfoRspBO> purchaseOrderDetailList = new LinkedList<PurchaseOrderDetailInfoRspBO>();
                List<PayableDetailPO> payDetailList = this.payableDetailMapper.selectListJoinApplyPayInfo(applyPayInfoBO.getPayno());
                for (PayableDetailPO po : payDetailList) {
                    PurchaseOrderDetailInfoRspBO rspBO = new PurchaseOrderDetailInfoRspBO();
                    rspBO.setInspectionId(po.getInspectionId());
                    rspBO.setPurchaseOrderCode(po.getPurchaseOrderCode());
                    rspBO.setPurchaseOrderName(po.getPurchaseOrderName());
                    purchaseOrderDetailList.add(rspBO);
                }
                applyPayInfoBO.setPurchaseOrderDetailList(purchaseOrderDetailList);
                applyPayInfoBOs.add(applyPayInfoBO);
            }
        }
        rspPageBO.setRows(applyPayInfoBOs);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBO;
    }
}

