/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.tydic.pfscext.api.deal.QueryPayOrderInfoDetailService;
import com.tydic.pfscext.api.deal.bo.PayOrderInfoDetailReqBO;
import com.tydic.pfscext.api.deal.bo.PayOrderInfoDetailRspBO;
import com.tydic.pfscext.dao.PayOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayOrderInfoPO;
import com.tydic.pfscext.enums.PayOrderInfoType;
import com.tydic.pfscext.enums.PayOrderStatus;
import com.tydic.pfscext.enums.PayType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.QueryPayOrderInfoDetailService"})
public class QueryPayOrderInfoDetailServiceImpl
implements QueryPayOrderInfoDetailService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryPayOrderInfoDetailServiceImpl.class);
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;

    @PostMapping(value={"queryPayOrderInfoDetail"})
    public PayOrderInfoDetailRspBO queryPayOrderInfoDetail(@RequestBody PayOrderInfoDetailReqBO payOrderInfoDetailReqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5165\u53c2\uff1a" + payOrderInfoDetailReqBO);
        }
        if (payOrderInfoDetailReqBO.getPayOrderId() == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayOrderInfoDetailRspBO payOrderInfoDetailRspBO = new PayOrderInfoDetailRspBO();
        try {
            PayOrderInfoPO payOrderInfoPO = this.payOrderInfoMapper.selectByPrimaryKey(payOrderInfoDetailReqBO.getPayOrderId());
            BeanUtils.copyProperties((Object)payOrderInfoPO, (Object)payOrderInfoDetailReqBO);
            payOrderInfoDetailRspBO.setPayOrderStatusStr(PayOrderStatus.getInstance(payOrderInfoPO.getPayOrderStatus()).getDescr());
            payOrderInfoDetailRspBO.setPayOrderTypeStr(PayOrderInfoType.getInstance(payOrderInfoPO.getPayOrderType()).getDescr());
            payOrderInfoDetailRspBO.setPayTypeStr(PayType.getInstance(payOrderInfoPO.getPayType()).getDescr());
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u6210\u4ea4\u670d\u52a1\u8d39\u8be6\u60c5\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u6210\u4ea4\u670d\u52a1\u8d39\u8be6\u60c5\u5931\u8d25");
        }
        return payOrderInfoDetailRspBO;
    }
}

