/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoOrderRspBO;
import com.tydic.pfscext.api.deal.QueryPayOrderInfoListService;
import com.tydic.pfscext.api.deal.bo.QueryPayOrderInfoReqBO;
import com.tydic.pfscext.api.deal.bo.QueryPayOrderInfoRspBO;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.pfscext.dao.PayOrderInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.InvoiceClasses;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.PayOrderInfoType;
import com.tydic.pfscext.enums.PayOrderStatus;
import com.tydic.pfscext.enums.PayType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.QueryPayOrderInfoListService"})
public class QueryPayOrderInfoListServiceImpl
implements QueryPayOrderInfoListService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryPayOrderInfoListServiceImpl.class);
    @Autowired
    private PayOrderInfoMapper payOrderInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;

    @PostMapping(value={"queryPayOrderInfoList"})
    public PfscExtRspPageBaseBO<QueryPayOrderInfoRspBO> queryPayOrderInfoList(@RequestBody QueryPayOrderInfoReqBO queryPayOrderInfoReqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5165\u53c2\uff1a" + queryPayOrderInfoReqBO);
        }
        PfscExtRspPageBaseBO rspPage = new PfscExtRspPageBaseBO();
        try {
            if (queryPayOrderInfoReqBO.getPayOrderTime() != null) {
                queryPayOrderInfoReqBO.setPayOrderYear(queryPayOrderInfoReqBO.getPayOrderTime().toString().substring(0, 4));
                queryPayOrderInfoReqBO.setPayOrderMonth(queryPayOrderInfoReqBO.getPayOrderTime().toString().substring(5, 7));
            }
            ArrayList<Long> payOrderIds = new ArrayList<Long>();
            Page page = new Page(queryPayOrderInfoReqBO.getPageNo().intValue(), queryPayOrderInfoReqBO.getPageSize().intValue());
            List<QueryPayOrderInfoRspBO> payOrderInfoPOs = this.payOrderInfoMapper.selectPageList(queryPayOrderInfoReqBO, (Page<Map<String, Object>>)page);
            for (QueryPayOrderInfoRspBO queryPayOrderInfoRspBO2 : payOrderInfoPOs) {
                payOrderIds.add(queryPayOrderInfoRspBO2.getPayOrderId());
            }
            SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
            saleOrderInfo.setPurchaseName(queryPayOrderInfoReqBO.getPurchaseName());
            saleOrderInfo.setSaleOrderCode(queryPayOrderInfoReqBO.getSaleOrderCode());
            saleOrderInfo.setPurchaserName(queryPayOrderInfoReqBO.getPurchaserName());
            saleOrderInfo.setContactName(queryPayOrderInfoReqBO.getContactName());
            List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getOrderInfoByPayOrderId(payOrderIds, saleOrderInfo);
            List queryPayOrderInfoRspBOs = payOrderInfoPOs.stream().map(queryPayOrderInfoRspBO -> {
                ArrayList<BusiQuerySaleOrderInfoOrderRspBO> busiQuerySaleOrderInfoOrderRspBOs = new ArrayList<BusiQuerySaleOrderInfoOrderRspBO>();
                for (SaleOrderInfo saleOrderInfoPO : saleOrderInfos) {
                    if (saleOrderInfoPO.getPayOrderId() != queryPayOrderInfoRspBO.getPayOrderId()) continue;
                    BusiQuerySaleOrderInfoOrderRspBO busiQuerySaleOrderInfoOrderRspBO = new BusiQuerySaleOrderInfoOrderRspBO();
                    BeanUtils.copyProperties((Object)saleOrderInfoPO, (Object)busiQuerySaleOrderInfoOrderRspBO);
                    busiQuerySaleOrderInfoOrderRspBOs.add(busiQuerySaleOrderInfoOrderRspBO);
                }
                queryPayOrderInfoRspBO.setBusiQuerySaleOrderInfoOrderRspBOs(busiQuerySaleOrderInfoOrderRspBOs);
                queryPayOrderInfoRspBO.setPayOrderStatusStr(PayOrderStatus.getInstance(queryPayOrderInfoRspBO.getPayOrderStatus()).getDescr());
                queryPayOrderInfoRspBO.setPayOrderTypeStr(PayOrderInfoType.getInstance(queryPayOrderInfoRspBO.getPayOrderType()).getDescr());
                queryPayOrderInfoRspBO.setPayTypeStr(PayType.getInstance(queryPayOrderInfoRspBO.getPayType()).getDescr());
                queryPayOrderInfoRspBO.setInvoiceClassesStr(InvoiceClasses.getInstance(queryPayOrderInfoRspBO.getInvoiceClasses().toString()).getDescr());
                queryPayOrderInfoRspBO.setInvoiceTypeStr(InvoiceType.getInstance(queryPayOrderInfoRspBO.getInvoiceType()).getDescr());
                queryPayOrderInfoRspBO.setBillStatusStr(BillStatus.getInstance(queryPayOrderInfoRspBO.getBillStatus().toString()).getDescr());
                return queryPayOrderInfoRspBO;
            }).collect(Collectors.toList());
            rspPage.setRows(queryPayOrderInfoRspBOs);
            rspPage.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspPage.setTotal(Integer.valueOf(page.getTotalPages()));
            rspPage.setPageNo(Integer.valueOf(page.getPageNo()));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u670d\u52a1\u5931\u8d25");
        }
        return rspPage;
    }
}

