/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.aop;

import java.util.Collections;
import java.util.HashMap;
import org.aopalliance.aop.Advice;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Aspect
@Component
@Order(value=10)
public class FscServiceTransactionAdvice {
    private static final String TRANSACTION_POINTCUT = "execution(* com.tydic.pfscext.service.busi..*(..))";
    private static final String NON_TRANSACTION_POINTCUT = "execution(* com.tydic.pfscext.service.comb..*(..))";
    private final PlatformTransactionManager transactionManager;

    @Autowired
    public FscServiceTransactionAdvice(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Bean
    public TransactionInterceptor txAdvice() {
        NameMatchTransactionAttributeSource source = new NameMatchTransactionAttributeSource();
        RuleBasedTransactionAttribute readOnlyRule = new RuleBasedTransactionAttribute();
        readOnlyRule.setReadOnly(true);
        readOnlyRule.setPropagationBehavior(4);
        RuleBasedTransactionAttribute requireRule = new RuleBasedTransactionAttribute();
        requireRule.setRollbackRules(Collections.singletonList(new RollbackRuleAttribute(Throwable.class)));
        requireRule.setPropagationBehavior(0);
        requireRule.setTimeout(5);
        HashMap<String, RuleBasedTransactionAttribute> txMap = new HashMap<String, RuleBasedTransactionAttribute>(16);
        txMap.put("create*", requireRule);
        txMap.put("register*", requireRule);
        txMap.put("update*", requireRule);
        txMap.put("delete*", requireRule);
        txMap.put("insert*", requireRule);
        txMap.put("add*", requireRule);
        txMap.put("modify*", requireRule);
        txMap.put("process*", requireRule);
        txMap.put("adjust*", requireRule);
        txMap.put("save*", requireRule);
        txMap.put("cancel*", requireRule);
        txMap.put("change*", requireRule);
        txMap.put("notify*", requireRule);
        txMap.put("break*", requireRule);
        txMap.put("marking*", requireRule);
        txMap.put("make*", requireRule);
        txMap.put("execute*", requireRule);
        txMap.put("chng*", requireRule);
        txMap.put("lock*", requireRule);
        txMap.put("unlock*", requireRule);
        txMap.put("derate*", requireRule);
        txMap.put("calc*", requireRule);
        txMap.put("into*", requireRule);
        txMap.put("out*", requireRule);
        txMap.put("preempted*", requireRule);
        txMap.put("occupy*", requireRule);
        txMap.put("logout*", requireRule);
        txMap.put("reLogin*", requireRule);
        txMap.put("delayOcp*", requireRule);
        txMap.put("relSelection*", requireRule);
        txMap.put("relPreempted*", requireRule);
        txMap.put("exec*", requireRule);
        txMap.put("reconcile*", requireRule);
        txMap.put("get*", requireRule);
        txMap.put("auth*", requireRule);
        txMap.put("zhi*", requireRule);
        txMap.put("*Verify", requireRule);
        txMap.put("apply*", requireRule);
        txMap.put("deal*", requireRule);
        txMap.put("*", readOnlyRule);
        source.setNameMap(txMap);
        return new TransactionInterceptor(this.transactionManager, (TransactionAttributeSource)source);
    }

    @Bean
    public Advisor txAdviceAdvisor() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(TRANSACTION_POINTCUT);
        return new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)this.txAdvice());
    }

    @Bean
    public TransactionInterceptor nonTxAdvice() {
        NameMatchTransactionAttributeSource source = new NameMatchTransactionAttributeSource();
        RuleBasedTransactionAttribute readOnlyRule = new RuleBasedTransactionAttribute();
        readOnlyRule.setReadOnly(true);
        readOnlyRule.setPropagationBehavior(4);
        HashMap<String, RuleBasedTransactionAttribute> txMap = new HashMap<String, RuleBasedTransactionAttribute>(4);
        txMap.put("*", readOnlyRule);
        source.setNameMap(txMap);
        return new TransactionInterceptor(this.transactionManager, (TransactionAttributeSource)source);
    }

    @Bean
    public Advisor nonTxAdviceAdvisor() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(NON_TRANSACTION_POINTCUT);
        return new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)this.nonTxAdvice());
    }
}

