/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoOrderRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoReqBO;
import com.tydic.pfscext.api.deal.QuerySaleOrderInfoListService;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.umcext.ability.account.UmcQryEnterpriseAccountDetailAbilityService;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountDetailAbilityReqBO;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountDetailAbilityRspBO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.QuerySaleOrderInfoListService"})
public class QuerySaleOrderInfoListServiceImpl
implements QuerySaleOrderInfoListService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuerySaleOrderInfoListServiceImpl.class);
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private UmcQryEnterpriseAccountDetailAbilityService umcQryEnterpriseAccountDetailAbilityService;

    @PostMapping(value={"querySaleOrderInfoList"})
    public PfscExtRspPageBaseBO<BusiQuerySaleOrderInfoOrderRspBO> querySaleOrderInfoList(@RequestBody BusiQuerySaleOrderInfoReqBO reqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)(\u4e13\u4e1a\u516c\u53f8\u548c\u91c7\u8d2d\u5355\u4f4d\u5171\u7528)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PfscExtRspPageBaseBO rapPage = new PfscExtRspPageBaseBO();
        try {
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            BeanUtils.copyProperties((Object)reqBO, (Object)saleOrderInfoVO);
            saleOrderInfoVO.setSaleOrderCodeLike(reqBO.getSaleOrderCode());
            Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
            List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListPage(saleOrderInfoVO, (Page<Map<String, Object>>)page);
            List busiQuerySaleOrderInfoOrderRspBOs = saleOrderInfoList.stream().map(saleOrderInfo -> {
                BusiQuerySaleOrderInfoOrderRspBO busiQuerySaleOrderInfoOrderRspBO = new BusiQuerySaleOrderInfoOrderRspBO();
                BeanUtils.copyProperties((Object)saleOrderInfo, (Object)busiQuerySaleOrderInfoOrderRspBO);
                busiQuerySaleOrderInfoOrderRspBO.setOrderStatusDescr(OrderStatus.getInstance(saleOrderInfo.getOrderStatus()).getDescr());
                busiQuerySaleOrderInfoOrderRspBO.setOrderId(saleOrderInfo.getOrderId().toString());
                UmcQryEnterpriseAccountDetailAbilityReqBO abilityReqBO = new UmcQryEnterpriseAccountDetailAbilityReqBO();
                abilityReqBO.setAccountId(saleOrderInfo.getPurchaseProjectId());
                UmcQryEnterpriseAccountDetailAbilityRspBO rspBO = this.umcQryEnterpriseAccountDetailAbilityService.qryEnterpriseAccountDetail(abilityReqBO);
                if (rspBO != null && rspBO.getUmcEnterpriseAccountBO() != null) {
                    busiQuerySaleOrderInfoOrderRspBO.setPurchaseProjectName(rspBO.getUmcEnterpriseAccountBO().getAccountName());
                }
                if (saleOrderInfo.getInspectionId() != null) {
                    busiQuerySaleOrderInfoOrderRspBO.setInspectionId(saleOrderInfo.getInspectionId().toString());
                }
                return busiQuerySaleOrderInfoOrderRspBO;
            }).collect(Collectors.toList());
            rapPage.setRows(busiQuerySaleOrderInfoOrderRspBOs);
            rapPage.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rapPage.setTotal(Integer.valueOf(page.getTotalPages()));
            rapPage.setPageNo(Integer.valueOf(page.getPageNo()));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u670d\u52a1\u5931\u8d25");
        }
        return rapPage;
    }
}

