/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.zm.impl;

import com.tydic.pfscext.api.zm.ReconcilitionDetailsService;
import com.tydic.pfscext.api.zm.bo.ReconcilitionDetails;
import com.tydic.pfscext.api.zm.bo.ReconcilitionDetailsReqBO;
import com.tydic.pfscext.api.zm.bo.ReconcilitionDetailsRspBO;
import com.tydic.pfscext.dao.CheckBillInfoMapper;
import com.tydic.pfscext.dao.ReconcilitionHisMapper;
import com.tydic.pfscext.dao.po.ReconcilitionDetailsReqPO;
import com.tydic.pfscext.dao.po.ReconcilitionDetailsRspPO;
import com.tydic.pfscext.dao.po.ReconcilitionZmPO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.DictionaryAtomService;
import com.tydic.pfscext.service.atom.bo.DictionaryAtomReqBo;
import com.tydic.pfscext.service.atom.bo.DictionaryAtomRspBo;
import com.tydic.umcext.ability.account.UmcQryEnterpriseAccountDetailAbilityService;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountDetailAbilityReqBO;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountDetailAbilityRspBO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.zm.ReconcilitionDetailsService"})
public class ReconcilitionDetailsServiceImpl
implements ReconcilitionDetailsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReconcilitionDetailsServiceImpl.class);
    private CheckBillInfoMapper checkBillInfoMapper;
    private ReconcilitionHisMapper reconcilitionHisMapper;
    private DictionaryAtomService dicDictionaryService;
    @Autowired
    private UmcQryEnterpriseAccountDetailAbilityService umcQryEnterpriseAccountDetailAbilityService;

    @Autowired
    public ReconcilitionDetailsServiceImpl(CheckBillInfoMapper checkBillInfoMapper, ReconcilitionHisMapper reconcilitionHisMapper, DictionaryAtomService dicDictionaryService) {
        this.checkBillInfoMapper = checkBillInfoMapper;
        this.reconcilitionHisMapper = reconcilitionHisMapper;
        this.dicDictionaryService = dicDictionaryService;
    }

    @PostMapping(value={"queryReconcilitionDetails"})
    public ReconcilitionDetailsRspBO queryReconcilitionDetails(@RequestBody ReconcilitionDetailsReqBO reconcilitionDetailsReqBO) {
        ReconcilitionDetailsRspBO rspBO = new ReconcilitionDetailsRspBO();
        if (reconcilitionDetailsReqBO.getReconciliationCode() == null) {
            throw new PfscExtBusinessException("18000", "\u5bf9\u8d26\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UmcQryEnterpriseAccountDetailAbilityReqBO umcReqBO = new UmcQryEnterpriseAccountDetailAbilityReqBO();
        UmcQryEnterpriseAccountDetailAbilityRspBO umcRspBO = new UmcQryEnterpriseAccountDetailAbilityRspBO();
        ArrayList<ReconcilitionDetails> reconcilitionDetails = new ArrayList<ReconcilitionDetails>();
        ReconcilitionDetailsReqPO reqPO = new ReconcilitionDetailsReqPO();
        ReconcilitionDetailsRspPO rspPO = new ReconcilitionDetailsRspPO();
        List<Object> rspPOList = new ArrayList();
        BeanUtils.copyProperties((Object)reconcilitionDetailsReqBO, (Object)reqPO);
        ReconcilitionZmPO reconcilitionZmPO = this.checkBillInfoMapper.selectByCode(reconcilitionDetailsReqBO.getReconciliationCode());
        rspBO.setUserName(reconcilitionZmPO.getUserName());
        rspBO.setSupName(reconcilitionZmPO.getSupName());
        rspBO.setReconciliationCode(reconcilitionZmPO.getReconcilitionCode());
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String string = format.format(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US).parse(reconcilitionZmPO.getReconcilitionDate().toString()));
            LOGGER.error("\u65f6\u95f4\u683c\u5f0f\uff1a" + string);
            System.out.println("\u65f6\u95f4\u683c\u5f0f\uff1a" + string);
            rspBO.setReconcilitionDate(string);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        rspPOList = this.checkBillInfoMapper.queryReconcilitionDetails(reqPO);
        if (rspPOList != null && rspPOList.size() > 0) {
            for (ReconcilitionDetailsRspPO reconcilitionDetailsRspPO : rspPOList) {
                String dd;
                SimpleDateFormat format;
                ReconcilitionDetails detailsBO = new ReconcilitionDetails();
                detailsBO.setBillConfirm(reconcilitionDetailsRspPO.getBillConfirm());
                if ("01".equals(reconcilitionDetailsRspPO.getBillConfirm())) {
                    detailsBO.setBillConfirmStr("\u672a\u786e\u8ba4");
                }
                if ("02".equals(reconcilitionDetailsRspPO.getBillConfirm())) {
                    detailsBO.setBillConfirmStr("\u5df2\u786e\u8ba4");
                }
                umcReqBO.setAccountId(reconcilitionDetailsRspPO.getPurchaseProjectId());
                umcRspBO = this.umcQryEnterpriseAccountDetailAbilityService.qryEnterpriseAccountDetail(umcReqBO);
                detailsBO.setPurchaseProjectName(umcRspBO.getUmcEnterpriseAccountBO().getAccountName());
                if (reconcilitionDetailsRspPO.getErpOrder() != null) {
                    detailsBO.setErpOrder(this.isErpMap().get(reconcilitionDetailsRspPO.getErpOrder()));
                }
                detailsBO.setErpOrderNo(reconcilitionDetailsRspPO.getErpOrderNo());
                detailsBO.setExtOrderId(reconcilitionDetailsRspPO.getExtOrderId());
                detailsBO.setOrderAmt(reconcilitionDetailsRspPO.getOrderAmt());
                try {
                    format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    dd = format.format(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US).parse(reconcilitionDetailsRspPO.getOrderDate().toString()));
                    LOGGER.error("\u65f6\u95f4\u683c\u5f0f\uff1a" + dd);
                    System.out.println("\u65f6\u95f4\u683c\u5f0f\uff1a" + dd);
                    detailsBO.setOrderDate(dd);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                if (reconcilitionDetailsRspPO.getOrderStatus() != null) {
                    detailsBO.setOrderStatus(reconcilitionDetailsRspPO.getOrderStatus());
                    detailsBO.setOrderStatusStr(this.getSaleOrderStatusMap().get(reconcilitionDetailsRspPO.getOrderStatus()));
                }
                detailsBO.setPurchaseOrderCode(reconcilitionDetailsRspPO.getPurchaseOrderCode());
                detailsBO.setPurchaseProjectId(reconcilitionDetailsRspPO.getPurchaseProjectId().toString());
                if (reconcilitionDetailsRspPO.getReconciliationStatus() != null) {
                    detailsBO.setReconciliationStatus(reconcilitionDetailsRspPO.getReconciliationStatus());
                    detailsBO.setReconciliationStatusStr(this.getReconcilStatusMap().get(reconcilitionDetailsRspPO.getReconciliationStatus()));
                }
                try {
                    format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    dd = format.format(new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US).parse(reconcilitionDetailsRspPO.getRecvDate().toString()));
                    LOGGER.error("\u65f6\u95f4\u683c\u5f0f\uff1a" + dd);
                    System.out.println("\u65f6\u95f4\u683c\u5f0f\uff1a" + dd);
                    detailsBO.setRecvDate(dd);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                if (reconcilitionDetailsRspPO.getStockOrgId() != null) {
                    detailsBO.setStockOrgId(reconcilitionDetailsRspPO.getStockOrgId());
                }
                if (reconcilitionDetailsRspPO.getStockOrgName() != null) {
                    detailsBO.setStockOrgName(reconcilitionDetailsRspPO.getStockOrgName());
                }
                if (reconcilitionDetailsRspPO.getUseDepartmentId() != null) {
                    detailsBO.setUseDepartmentId(reconcilitionDetailsRspPO.getUseDepartmentId());
                }
                if (reconcilitionDetailsRspPO.getUseDepartmentName() != null) {
                    detailsBO.setUseDepartmentName(reconcilitionDetailsRspPO.getUseDepartmentName());
                }
                reconcilitionDetails.add(detailsBO);
            }
        }
        rspBO.setReconcilitionDetails(reconcilitionDetails);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5bf9\u8d26\u5355\u8be6\u60c5\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    private Map<String, String> getReconcilStatusMap() {
        Map<String, String> map = new HashMap<String, String>(2);
        DictionaryAtomReqBo dictionaryAtomReqBo = new DictionaryAtomReqBo();
        dictionaryAtomReqBo.setpCode("RECONCIL_STATUS");
        DictionaryAtomRspBo dictionaryAtomRspBo = this.dicDictionaryService.qryDic(dictionaryAtomReqBo);
        if (null != dictionaryAtomRspBo) {
            map = dictionaryAtomRspBo.getData();
        }
        return map;
    }

    private Map<String, String> getSaleOrderStatusMap() {
        Map<String, String> map = new HashMap<String, String>(2);
        DictionaryAtomReqBo dictionaryAtomReqBo = new DictionaryAtomReqBo();
        dictionaryAtomReqBo.setpCode("D_SALE_ORDER_INFO_ORDER_STATUS");
        DictionaryAtomRspBo dictionaryAtomRspBo = this.dicDictionaryService.qryDic(dictionaryAtomReqBo);
        if (null != dictionaryAtomRspBo) {
            map = dictionaryAtomRspBo.getData();
        }
        return map;
    }

    private Map<String, String> isErpMap() {
        Map<String, String> map = new HashMap<String, String>(2);
        DictionaryAtomReqBo dictionaryAtomReqBo = new DictionaryAtomReqBo();
        dictionaryAtomReqBo.setpCode("IS_ERP");
        DictionaryAtomRspBo dictionaryAtomRspBo = this.dicDictionaryService.qryDic(dictionaryAtomReqBo);
        if (null != dictionaryAtomRspBo) {
            map = dictionaryAtomRspBo.getData();
        }
        return map;
    }
}

