/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiExportOutstockDetailInfoService;
import com.tydic.pfscext.api.busi.bo.BusiExportListOutstockInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiExportOutstockDetailInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiExportRowOutstockDetailInfoRspBO;
import com.tydic.pfscext.api.busi.vo.SaleInvoiceVO;
import com.tydic.pfscext.dao.OutstockDetailMapper;
import com.tydic.pfscext.dao.OutstockInfoMapper;
import com.tydic.pfscext.dao.OutstockTotalMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.StocksDetailMapper;
import com.tydic.pfscext.dao.po.OutstockDetail;
import com.tydic.pfscext.dao.po.OutstockInfo;
import com.tydic.pfscext.dao.po.OutstockTotal;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.dao.po.StocksDetail;
import com.tydic.pfscext.dao.vo.OutstockInfoVO;
import com.tydic.pfscext.dao.vo.OutstockTotalVO;
import com.tydic.pfscext.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.AmountUtils;
import com.tydic.pfscext.utils.BeanUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiExportOutstockDetailInfoServiceImpl
implements BusiExportOutstockDetailInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiExportOutstockDetailInfoServiceImpl.class);
    @Autowired
    private OutstockInfoMapper outstockInfoMapper;
    @Autowired
    private OutstockDetailMapper outstockDetailMapper;
    @Autowired
    private StocksDetailMapper stocksDetailMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private OutstockTotalMapper outstockTotalMapper;

    public BusiExportOutstockDetailInfoRspBO exportOutstockDetailInfo(BusiExportListOutstockInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5bfc\u51fa\u51fa\u5e93\u5355\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + reqBO);
        }
        BusiExportOutstockDetailInfoRspBO rspBO = new BusiExportOutstockDetailInfoRspBO();
        if (reqBO.getTotalNo() == null) {
            throw new PfscExtBusinessException("0001", "\u6c47\u603b\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OutstockTotalVO outstockTotalVO = new OutstockTotalVO();
        outstockTotalVO.setTotalNo(reqBO.getTotalNo());
        OutstockTotal outstockTotal = this.outstockTotalMapper.selectSelective(outstockTotalVO);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        BigDecimal sum = BigDecimal.ZERO;
        BigDecimal sumAmt = BigDecimal.ZERO;
        LinkedList<BusiExportRowOutstockDetailInfoRspBO> rows = new LinkedList<BusiExportRowOutstockDetailInfoRspBO>();
        OutstockInfoVO outstockInfoVO = new OutstockInfoVO();
        outstockInfoVO.setTotalNo(reqBO.getTotalNo());
        List<OutstockInfo> outstockInfoList = this.outstockInfoMapper.selectByCondition(outstockInfoVO);
        for (OutstockInfo outstockInfo : outstockInfoList) {
            BigDecimal untaxAmtSum = BigDecimal.ZERO;
            BusiExportRowOutstockDetailInfoRspBO row = new BusiExportRowOutstockDetailInfoRspBO();
            row.setOutstockNo(outstockInfo.getOutstockNo());
            List<OutstockDetail> list = this.outstockDetailMapper.selectByCondition(outstockInfo.getOutstockNo());
            for (OutstockDetail outstockDetail : list) {
                StocksDetail stocksDetail = this.stocksDetailMapper.selectByConditions(outstockDetail.getInspectionId(), outstockDetail.getPurchaseItemNo());
                if (stocksDetail == null || stocksDetail.getUntaxAmt() == null) continue;
                untaxAmtSum = untaxAmtSum.add(stocksDetail.getUntaxAmt());
            }
            row.setAmt(AmountUtils.format(untaxAmtSum));
            sum = sum.add(untaxAmtSum);
            String applyNo = outstockInfo.getApplyNo();
            SaleInvoiceInfoVO InvoiceInfoVO = new SaleInvoiceInfoVO();
            InvoiceInfoVO.setApplyNo(applyNo);
            List<SaleInvoiceInfo> InvoiceInfoList = this.saleInvoiceInfoMapper.selectBy(InvoiceInfoVO);
            ArrayList<SaleInvoiceVO> InvoiceList = new ArrayList<SaleInvoiceVO>();
            for (SaleInvoiceInfo InvoiceInfo : InvoiceInfoList) {
                SaleInvoiceVO saleInvoiceVO = new SaleInvoiceVO();
                saleInvoiceVO.setInvoiceNo(InvoiceInfo.getInvoiceNo());
                saleInvoiceVO.setUntaxAmt(AmountUtils.format(InvoiceInfo.getUntaxAmt()));
                saleInvoiceVO.setTaxAmt(AmountUtils.format(InvoiceInfo.getTaxAmt()));
                InvoiceList.add(saleInvoiceVO);
                sumAmt = sumAmt.add(InvoiceInfo.getUntaxAmt()).add(InvoiceInfo.getTaxAmt());
            }
            row.setSaleInvoiceList(InvoiceList);
            BeanUtils.null2DefaultValue(row);
            rows.add(row);
        }
        rspBO.setOrgId(outstockTotal.getOrgId());
        rspBO.setRows(rows);
        rspBO.setCreateDate(sdf.format(outstockTotal.getCreateDate()));
        rspBO.setSum(AmountUtils.format(sum));
        rspBO.setSumAmt(AmountUtils.format(sumAmt));
        return rspBO;
    }
}

