/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiExportReceiptDetailInfoService;
import com.tydic.pfscext.api.busi.bo.BusiExportListReceiptInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiExportReceiptDetailInfoRsqBO;
import com.tydic.pfscext.api.busi.bo.BusiExportRowReceiptDetailInfoRspBO;
import com.tydic.pfscext.api.busi.vo.PayInvoiceInfoRowVO;
import com.tydic.pfscext.dao.EntryInfoMapper;
import com.tydic.pfscext.dao.EntryTotalInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.po.EntryInfoPO;
import com.tydic.pfscext.dao.po.EntryTotalInfoPO;
import com.tydic.pfscext.dao.po.PayInvoiceInfo;
import com.tydic.pfscext.dao.vo.EntryTotalInfoVO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.AmountUtils;
import com.tydic.pfscext.utils.BeanUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiExportReceiptDetailInfoServiceImpl
implements BusiExportReceiptDetailInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiExportReceiptDetailInfoServiceImpl.class);
    @Autowired
    private EntryInfoMapper entryInfoMapper;
    @Autowired
    private EntryTotalInfoMapper entryTotalInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;

    public BusiExportReceiptDetailInfoRsqBO exportReceiptDetailInfo(BusiExportListReceiptInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5bfc\u51fa\u5165\u5e93\u5355\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        BusiExportReceiptDetailInfoRsqBO rspBO = new BusiExportReceiptDetailInfoRsqBO();
        if (reqBO.getApplyNo() == null) {
            throw new PfscExtBusinessException("0001", "\u6c47\u603b\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        EntryTotalInfoVO entryTotalInfoVO = new EntryTotalInfoVO();
        entryTotalInfoVO.setApplyNo(reqBO.getApplyNo());
        EntryTotalInfoPO entryTotalInfoPO = this.entryTotalInfoMapper.getModelById(entryTotalInfoVO);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        BigDecimal notTaxAmtSum = BigDecimal.ZERO;
        BigDecimal taxAmtSum = BigDecimal.ZERO;
        LinkedList<BusiExportRowReceiptDetailInfoRspBO> rows = new LinkedList<BusiExportRowReceiptDetailInfoRspBO>();
        EntryInfoPO entryInfoPO = new EntryInfoPO();
        entryInfoPO.setApplyNo(reqBO.getApplyNo());
        List<EntryInfoPO> entryInfoList = this.entryInfoMapper.getList(entryInfoPO);
        for (EntryInfoPO entryInfo : entryInfoList) {
            BusiExportRowReceiptDetailInfoRspBO row = new BusiExportRowReceiptDetailInfoRspBO();
            row.setEntryNo(entryInfo.getEntryNo());
            String notificationNo = entryInfo.getNotificationNo();
            List<PayInvoiceInfo> payInvoiceInfoList = this.payInvoiceInfoMapper.selectByNotifyNo(notificationNo);
            ArrayList<PayInvoiceInfoRowVO> InvoiceInfoList = new ArrayList<PayInvoiceInfoRowVO>();
            for (PayInvoiceInfo payInvoiceInfo : payInvoiceInfoList) {
                PayInvoiceInfoRowVO payInvoiceInfoVO = new PayInvoiceInfoRowVO();
                payInvoiceInfoVO.setInvoiceNo(payInvoiceInfo.getInvoiceNo());
                payInvoiceInfoVO.setNotTaxAmt(AmountUtils.format(payInvoiceInfo.getNotTaxAmt()));
                payInvoiceInfoVO.setTaxAmt(AmountUtils.format(payInvoiceInfo.getTaxAmt()));
                InvoiceInfoList.add(payInvoiceInfoVO);
                notTaxAmtSum = notTaxAmtSum.add(payInvoiceInfo.getNotTaxAmt());
                taxAmtSum = taxAmtSum.add(payInvoiceInfo.getTaxAmt());
            }
            row.setInvoiceInfoList(InvoiceInfoList);
            BeanUtils.null2DefaultValue(row);
            rows.add(row);
        }
        rspBO.setCompanyId(entryTotalInfoPO.getCompanyId());
        rspBO.setRows(rows);
        rspBO.setDocumentationDate(sdf.format(entryTotalInfoPO.getDocumentationDate()));
        rspBO.setNotTaxAmtSum(AmountUtils.format(notTaxAmtSum));
        rspBO.setTaxAmtSum(AmountUtils.format(taxAmtSum));
        return rspBO;
    }
}

