/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.RegisterReturnQueryBusiService;
import com.tydic.pfscext.api.busi.bo.BillApplyOrderInfoBO;
import com.tydic.pfscext.api.busi.bo.PayInvoiceInfoBO;
import com.tydic.pfscext.api.busi.bo.RegisterReturnQueryBusiReqBO;
import com.tydic.pfscext.api.busi.bo.RegisterReturnQueryBusiRspBO;
import com.tydic.pfscext.dao.AfterSaleMapper;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.PayInvoiceInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.AfterSaleVO;
import com.tydic.pfscext.dao.vo.BillApplyOrderInfoVO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.RegisterReturnQueryBusiService"})
public class RegisterReturnQueryBusiServiceImpl
implements RegisterReturnQueryBusiService {
    private static final Logger logger = LoggerFactory.getLogger(RegisterReturnQueryBusiServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private AfterSaleMapper afterSaleMapper;

    @PostMapping(value={"qryRegReturnOrder"})
    public RegisterReturnQueryBusiRspBO qryRegReturnOrder(@RequestBody RegisterReturnQueryBusiReqBO reqBO) {
        RegisterReturnQueryBusiRspBO rspBO = new RegisterReturnQueryBusiRspBO();
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getNotificationNo() == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5f00\u7968\u901a\u77e5\u5355\u53f7[notificatioNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(reqBO.getNotificationNo());
        if (billNotificationInfo == null) {
            throw new PfscExtBusinessException("18001", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5f00\u7968\u901a\u77e5\u5355\u8bb0\u5f55");
        }
        rspBO.setNotificationNo(reqBO.getNotificationNo());
        rspBO.setAmt(billNotificationInfo.getAmt());
        rspBO.setSupplierNo(billNotificationInfo.getSupplierNo());
        String supplierStr = this.organizationInfoService.querySupplierName(billNotificationInfo.getSupplierNo());
        rspBO.setSupplierName(supplierStr);
        List<PayInvoiceInfo> invoiceInfoList = this.payInvoiceInfoMapper.selectByNotifyNo(reqBO.getNotificationNo());
        if (invoiceInfoList == null || invoiceInfoList.isEmpty()) {
            logger.debug("\u5f00\u7968\u901a\u77e5\u5355\u53f7\u4e3a:" + reqBO.getNotificationNo() + "\u7684\u901a\u77e5\u5355\u672a\u67e5\u8be2\u5230\u53d1\u7968\u4fe1\u606f");
        } else {
            ArrayList<PayInvoiceInfoBO> invoiceInfoBOList = new ArrayList<PayInvoiceInfoBO>();
            for (PayInvoiceInfo payInvoiceInfo : invoiceInfoList) {
                PayInvoiceInfoBO payInvoiceInfoBO = new PayInvoiceInfoBO();
                BeanUtils.copyProperties((Object)payInvoiceInfo, (Object)payInvoiceInfoBO);
                AfterSaleVO afterSaleVO = new AfterSaleVO();
                afterSaleVO.setInvoiceCode(payInvoiceInfo.getInvoiceCode());
                afterSaleVO.setInvoiceNo(payInvoiceInfo.getInvoiceNo());
                int afterCount = this.afterSaleMapper.selectAfterCount(afterSaleVO);
                if (afterCount > 0) {
                    payInvoiceInfoBO.setCheckFlag(Integer.valueOf(1));
                } else {
                    payInvoiceInfoBO.setCheckFlag(Integer.valueOf(0));
                }
                invoiceInfoBOList.add(payInvoiceInfoBO);
            }
            rspBO.setInvoiceList(invoiceInfoBOList);
        }
        List<SaleOrderInfo> qryResultList = this.saleOrderInfoMapper.getSaleOrderListByNotifyNo(reqBO.getNotificationNo());
        if (qryResultList != null && qryResultList.size() > 0) {
            List<BillApplyOrderInfoVO> list;
            ArrayList<Long> orderIdList = new ArrayList<Long>();
            for (SaleOrderInfo saleOrderInfo : qryResultList) {
                if (saleOrderInfo.getOrderId() == null) continue;
                orderIdList.add(saleOrderInfo.getOrderId());
            }
            if (orderIdList.size() > 0 && (list = this.billApplyInfoMapper.getListByOrderIdList(orderIdList)) != null) {
                ArrayList<BillApplyOrderInfoBO> billApplyReturnList = new ArrayList<BillApplyOrderInfoBO>();
                for (BillApplyOrderInfoVO billApplyInfo : list) {
                    BillApplyOrderInfoBO billApplyOrderInfoBO = new BillApplyOrderInfoBO();
                    BeanUtils.copyProperties((Object)billApplyInfo, (Object)billApplyOrderInfoBO);
                    billApplyReturnList.add(billApplyOrderInfoBO);
                }
                rspBO.setApplyInfoList(billApplyReturnList);
            }
        }
        return rspBO;
    }
}

