/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.tydic.pfscext.api.busi.vo.InvoiceInfoVO;
import com.tydic.pfscext.api.deal.QueryPayInvoiceService;
import com.tydic.pfscext.api.deal.bo.PayInvoiceInfoBO;
import com.tydic.pfscext.api.deal.bo.PayItemInfoBO;
import com.tydic.pfscext.dao.PayInvoiceDetailMapper;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.po.PayInvoiceInfo;
import com.tydic.pfscext.dao.po.PayItemInfo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.QueryPayInvoiceService"})
public class QueryPayInvoiceByNotifiNoServiceImpl
implements QueryPayInvoiceService {
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayInvoiceDetailMapper payInvoiceDetailMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;

    @PostMapping(value={"selectByNotifyNo"})
    public List<PayInvoiceInfoBO> selectByNotifyNo(@RequestBody String notificationNo) {
        ArrayList<PayInvoiceInfoBO> boList = new ArrayList<PayInvoiceInfoBO>();
        List<PayInvoiceInfo> ls = this.payInvoiceInfoMapper.selectByNotifyNo(notificationNo);
        if (null != ls && ls.size() > 0) {
            for (PayInvoiceInfo payInvoiceInfo : ls) {
                PayInvoiceInfoBO bo = new PayInvoiceInfoBO();
                BeanUtils.copyProperties((Object)payInvoiceInfo, (Object)bo);
                boList.add(bo);
            }
        }
        return boList;
    }

    @PostMapping(value={"deleteByPrimaryKey"})
    public void deleteByPrimaryKey(@RequestBody PayInvoiceInfoBO payInvoiceInfoBO) {
        this.payInvoiceInfoMapper.deleteByPrimaryKey(payInvoiceInfoBO.getInvoiceCode(), payInvoiceInfoBO.getInvoiceNo(), payInvoiceInfoBO.getInvoiceDate());
    }

    @PostMapping(value={"selectByPrimaryKey"})
    public PayInvoiceInfoBO selectByPrimaryKey(@RequestBody InvoiceInfoVO ivVo) {
        PayInvoiceInfoBO bo = new PayInvoiceInfoBO();
        PayInvoiceInfo payInvoiceInfo = this.payInvoiceInfoMapper.selectByPrimaryKey(ivVo.getInvoiceCode(), ivVo.getInvoiceNo(), ivVo.getInvoiceDate());
        BeanUtils.copyProperties((Object)payInvoiceInfo, (Object)bo);
        return bo;
    }

    @PostMapping(value={"batchInsert"})
    public void batchInsert(@RequestBody List<PayInvoiceInfoBO> newIvDetails) {
        ArrayList<PayInvoiceInfo> list = new ArrayList<PayInvoiceInfo>();
        if (null != newIvDetails && newIvDetails.size() > 0) {
            for (PayInvoiceInfoBO bo : newIvDetails) {
                PayInvoiceInfo invoiceInfo = new PayInvoiceInfo();
                BeanUtils.copyProperties((Object)bo, (Object)invoiceInfo);
                list.add(invoiceInfo);
            }
        }
        this.payInvoiceInfoMapper.batchInsert(list);
    }

    @PostMapping(value={"updateByPrimaryKeySelective"})
    public int updateByPrimaryKeySelective(@RequestBody PayItemInfoBO payItemInfoBO) {
        PayItemInfo payItemInfo = new PayItemInfo();
        BeanUtils.copyProperties((Object)payItemInfoBO, (Object)payItemInfo);
        int cnt = this.payItemInfoMapper.updateByPrimaryKeySelective(payItemInfo);
        return cnt;
    }
}

