/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiUpdateNotificationExcepService;
import com.tydic.pfscext.api.busi.NotificationSendRequestService;
import com.tydic.pfscext.api.busi.bo.NotificationSendRequestReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.constants.FscCommonConstants;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SupplierInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.SupplierInfo;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiApplyInvoiceService;
import com.tydic.pfscext.external.api.bo.BusiApplyInvoiceReqBO;
import com.tydic.pfscext.external.api.bo.BusiApplyInvoiceRspBO;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.utils.FscCommonUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NotificationSendRequestServiceImpl
implements NotificationSendRequestService {
    private static final Logger logger = LoggerFactory.getLogger(NotificationSendRequestServiceImpl.class);
    @Autowired
    private BusiApplyInvoiceService busiApplyInvoiceService;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private SupplierInfoMapper supplierInfoMapper;
    @Autowired
    private BusiUpdateNotificationExcepService busiUpdateNotificationExcepService;
    @Autowired
    private EnumsService enumsService;

    public PfscExtRspBaseBO processPushInfo(NotificationSendRequestReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5f00\u7968\u901a\u77e5\u53d1\u9001\u8bf7\u6c42\u670d\u52a1\u5165\u53c2:" + reqBO);
        }
        BillNotificationInfo billNotificationInfo = new BillNotificationInfo();
        billNotificationInfo.setSource(OrderSource.ELECTRIC_MARKET.getCode());
        billNotificationInfo.setBatchNo(reqBO.getBatchNo());
        billNotificationInfo.setNotificationNo(reqBO.getNotificationNo());
        if (NotificationInvoiceStatus.SUBMITED_FAIL.getCode().equals(reqBO.getNotificationInvoiceStatus())) {
            billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED_FAIL.getCode());
        } else {
            billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.NO_SUBMITED.getCode());
        }
        List<BillNotificationInfo> billNotificationInfoList = this.billNotificationInfoMapper.selectList(billNotificationInfo);
        for (BillNotificationInfo notification : billNotificationInfoList) {
            BusiApplyInvoiceReqBO jdIntfceReqBO = new BusiApplyInvoiceReqBO();
            BusiApplyInvoiceRspBO jdIntfceRspBO = new BusiApplyInvoiceRspBO();
            try {
                jdIntfceReqBO.setSupplierId(notification.getSupplierNo());
                List<PayPurchaseOrderInfo> orders = this.payPurchaseOrderInfoMapper.selectByNotifNo(notification.getNotificationNo());
                LinkedList<String> orderIdCombStr = new LinkedList<String>();
                LinkedList<String> eorderIds = new LinkedList<String>();
                LinkedList<BigDecimal> orderAmt = new LinkedList<BigDecimal>();
                for (PayPurchaseOrderInfo singleOrder : orders) {
                    orderIdCombStr.add(singleOrder.getExtOrderId());
                    eorderIds.add(singleOrder.getPurchaseOrderCode());
                    orderAmt.add(singleOrder.getOrderAmt());
                }
                jdIntfceReqBO.setSupplierOrder(orderIdCombStr);
                jdIntfceReqBO.setEorderId(eorderIds);
                jdIntfceReqBO.setSettleAmt(orderAmt);
                jdIntfceReqBO.setMarkId(notification.getNotificationNo());
                jdIntfceReqBO.setSettlementId(notification.getNotificationNo());
                String curBatchStr = notification.getNotificationNo();
                String regEx = "[^0-9]";
                Pattern p = Pattern.compile(regEx);
                Matcher m = p.matcher(curBatchStr);
                curBatchStr = m.replaceAll("").trim();
                curBatchStr = curBatchStr.substring(curBatchStr.length() - 6, curBatchStr.length());
                jdIntfceReqBO.setCurrentBatch(curBatchStr);
                SimpleDateFormat sfWithSlash = new SimpleDateFormat("yyyy-MM-dd");
                String dateWithSlashStr = sfWithSlash.format(new Date());
                jdIntfceReqBO.setInvoiceDate(dateWithSlashStr);
                jdIntfceReqBO.setInvoiceNum(Integer.valueOf(orderIdCombStr.size()));
                jdIntfceReqBO.setTotalBatch(FscCommonConstants.BASIC_INVOICE_BATCH_NUM);
                jdIntfceReqBO.setInvoiceType(notification.getInvoceType());
                SupplierInfo supplierInfo = this.supplierInfoMapper.selectByPrimaryKey(notification.getSupplierNo());
                if (supplierInfo == null) {
                    throw new PfscExtBusinessException("18000", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u4f9b\u5e94\u5546\u5f00\u7968\u9650\u989d\u914d\u7f6e\u8868\uff0c\u4f9b\u5e94\u5546ID:" + String.valueOf(notification.getSupplierNo()) + "\u627e\u4e0d\u5230\u5bf9\u5e94\u914d\u7f6e\u4fe1\u606f");
                }
                String invoiceOrgSetting = supplierInfo.getBillOrg();
                jdIntfceReqBO.setInvoiceOrg(invoiceOrgSetting);
                jdIntfceReqBO.setTitle(notification.getInvoceName());
                jdIntfceReqBO.setBizInvoiceContent(Integer.valueOf(1));
                jdIntfceReqBO.setInvoicePrice(notification.getAmt());
                jdIntfceReqBO.setTotalBatchInvoiceAmount(notification.getAmt());
                jdIntfceReqBO.setEnterpriseTaxpayer(notification.getTaxNo());
                jdIntfceReqBO.setAddress(notification.getAddr());
                jdIntfceReqBO.setTel(notification.getPhone());
                jdIntfceReqBO.setBank(notification.getBankName());
                String accountStr = notification.getBankAccNo();
                accountStr = accountStr.replaceAll("\\s*", "");
                jdIntfceReqBO.setAccount(accountStr);
                jdIntfceReqBO.setBillToParty(notification.getCompany());
                jdIntfceReqBO.setBillToer(notification.getName());
                jdIntfceReqBO.setBillToContact(notification.getMobile());
                jdIntfceReqBO.setBillToProvince(FscCommonUtils.long2Integer((Long)notification.getProvId()));
                jdIntfceReqBO.setBillToCity(FscCommonUtils.long2Integer((Long)notification.getCityId()));
                jdIntfceReqBO.setBillToCounty(FscCommonUtils.long2Integer((Long)notification.getCountyId()));
                jdIntfceReqBO.setBillToTown(FscCommonUtils.long2Integer((Long)notification.getTownId()));
                jdIntfceReqBO.setBillToAddress(notification.getAddrDesc());
                jdIntfceReqBO.setOpenSwitch(this.enumsService.queryOpenSwitch(jdIntfceReqBO.getSupplierId()));
                logger.debug("\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u8c03\u7528\u63a5\u53e3\u5e73\u53f0\u3002\u5165\u53c2\uff1a" + jdIntfceReqBO);
                jdIntfceRspBO = this.busiApplyInvoiceService.applyInvoice(jdIntfceReqBO);
            }
            catch (Exception e) {
                logger.error("\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u8c03\u7528\u63a5\u53e3\u5e73\u53f0\u51fa\u9519\u3002\u5165\u53c2\uff1a" + jdIntfceReqBO, (Throwable)e);
                this.rollbackBillNotificationInfo(notification.getNotificationNo(), e.getMessage());
                continue;
            }
            if (jdIntfceRspBO == null) {
                logger.error("\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u8c03\u7528\u63a5\u53e3\u5e73\u53f0\u51fa\u9519\u3002\u5165\u53c2\uff1a" + jdIntfceReqBO);
                this.rollbackBillNotificationInfo(notification.getNotificationNo(), "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u8c03\u7528\u63a5\u53e3\u5e73\u53f0\u51fa\u9519");
                continue;
            }
            if (!jdIntfceRspBO.getSuccess().booleanValue()) {
                logger.error("\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u8c03\u7528\u63a5\u53e3\u5e73\u53f0\u51fa\u9519\u3002\u5165\u53c2\uff1a" + jdIntfceReqBO + "\u3002\u51fa\u53c2\uff1a" + jdIntfceRspBO);
                this.rollbackBillNotificationInfo(notification.getNotificationNo(), jdIntfceRspBO.getResultMessage());
                continue;
            }
            BillNotificationInfo updateBill = new BillNotificationInfo();
            updateBill.setNotificationNo(notification.getNotificationNo());
            updateBill.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
            this.billNotificationInfoMapper.updateByPrimaryKeySelective(updateBill);
        }
        PfscExtRspBaseBO rspBO = new PfscExtRspBaseBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void rollbackBillNotificationInfo(String notificationNo, String exceptionStr) {
        this.busiUpdateNotificationExcepService.updateNotificationException(exceptionStr, notificationNo);
        BillNotificationInfo updateBill = new BillNotificationInfo();
        updateBill.setNotificationNo(notificationNo);
        updateBill.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED_FAIL.getCode());
        this.billNotificationInfoMapper.updateByPrimaryKeySelective(updateBill);
    }
}

