/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiPayResultModifyService;
import com.tydic.pfscext.api.busi.bo.BusiPayResultModifyReqBO;
import com.tydic.pfscext.api.busi.bo.BusiPayResultModifyRspBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiPayResultModifyService"})
public class BusiPayResultModifyServiceImpl
implements BusiPayResultModifyService {
    private static final Logger logger = LoggerFactory.getLogger(BusiPayResultModifyServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    @PostMapping(value={"modifyResult"})
    public BusiPayResultModifyRspBO modifyResult(@RequestBody BusiPayResultModifyReqBO busiPayResultModifyReqBO) {
        logger.info("\u4ed8\u6b3e\u67e5\u8be2-\u786e\u8ba4\u7f34\u8d39\u72b6\u6001BO=" + busiPayResultModifyReqBO);
        BusiPayResultModifyRspBO resp = new BusiPayResultModifyRspBO();
        List payNos = busiPayResultModifyReqBO.getPayNos();
        if (payNos == null || payNos.size() == 0) {
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u5355\u53f7(payNo)\u5fc5\u987b\u8f93\u5165");
        }
        List statuss = busiPayResultModifyReqBO.getStatuss();
        for (String status : statuss) {
            PayResultStatus newStatus = PayResultStatus.getInstance(status);
            if (newStatus == null) {
                throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u7ed3\u679c\u72b6\u6001\u4e0d\u5408\u6cd5");
            }
            if (newStatus == PayResultStatus.PAY_CONFIRMED) continue;
            throw new PfscExtBusinessException("0001", "\u53ea\u6709\uff1a" + PayResultStatus.PAY_CONFIRMED.getDescr() + "\u72b6\u6001\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u624d\u80fd\uff0c\u5f53\u524d\u4ed8\u6b3e\u7533\u8bf7\u5355\u72b6\u6001\u4e3a\uff1a" + (Object)((Object)newStatus));
        }
        for (String spayNo : payNos) {
            List<PayPurchaseOrderInfo> payPurchaseOrderInfoList;
            Long payNo = Long.valueOf(spayNo);
            ApplyPayInfoPO applyPay = this.applyPayInfoMapper.getModelById(payNo);
            if (applyPay == null) {
                throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u5355" + payNo + "\u4e0d\u5b58\u5728");
            }
            List<ApplyDetail> details = this.applyDetailMapper.selectPayableList(payNo);
            int size = details.size();
            if (size == 0) {
                throw new PfscExtBusinessException("0001", "\u672a\u627e\u5230\u6b64\u4ed8\u6b3e\u5355\u4e0b\u7684\u5e94\u4ed8\u6b3e\u5355\u660e\u7ec6\u8bb0\u5f55");
            }
            logger.info("\u4ed8\u6b3e\u5355\u8bbe\u7f6e\u4ed8\u6b3e\u7ed3\u679c,\u6d89\u53ca\u5e94\u4ed8\u5355\u6570\u91cf=" + size + ",\u4ed8\u6b3e\u5355\u53f7=" + payNo);
            applyPay.setPayStatus(PayResultStatus.SUCCESS.getCode());
            applyPay.setRemark(busiPayResultModifyReqBO.getRemark());
            applyPay.setOperatorId(busiPayResultModifyReqBO.getUserId());
            this.applyPayInfoMapper.updateStatus(applyPay);
            ApplyDetail applyDetail = new ApplyDetail();
            applyDetail.setApplyNo(payNo);
            applyDetail.setStatus(PayResultStatus.SUCCESS.getCode());
            this.applyDetailMapper.updateByApplyNo(applyDetail);
            String payableNo = applyDetail.getPayableNo();
            PayableDetailPO payableDetailPO = this.payableDetailMapper.getModelById(payableNo);
            if (null == payableDetailPO || null == (payPurchaseOrderInfoList = this.payPurchaseOrderInfoMapper.selectByNotifNo(payableDetailPO.getNotificationNo())) || payPurchaseOrderInfoList.size() <= 0) continue;
            for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfoList) {
                payPurchaseOrderInfo.setPayType("01");
                this.payPurchaseOrderInfoMapper.updateByPrimaryKeySelective(payPurchaseOrderInfo);
            }
        }
        return resp;
    }
}

