/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.druid.util.StringUtils;
import com.tydic.pfscext.api.busi.DzcsInvoiceReturnQryApplyDetailService;
import com.tydic.pfscext.api.busi.bo.DzcsInvoiceReturnQryApplyDetailItemRspBO;
import com.tydic.pfscext.api.busi.bo.DzcsInvoiceReturnQryApplyDetailReqBO;
import com.tydic.pfscext.api.busi.bo.DzcsInvoiceReturnQryApplyDetailRspBO;
import com.tydic.pfscext.dao.InvoiceReturnDetailMapper;
import com.tydic.pfscext.dao.InvoiceReturnMapper;
import com.tydic.pfscext.dao.po.InvoiceReturn;
import com.tydic.pfscext.dao.po.InvoiceReturnDetail;
import com.tydic.pfscext.dao.vo.InvoiceReturnDetailExt;
import com.tydic.pfscext.dao.vo.InvoiceReturnDetailVO;
import com.tydic.pfscext.enums.InvoiceClasses;
import com.tydic.pfscext.enums.InvoiceReturnType;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.utils.FileUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DzcsInvoiceReturnQryApplyDetailServiceImpl
implements DzcsInvoiceReturnQryApplyDetailService {
    private static final Logger logger = LoggerFactory.getLogger(DzcsInvoiceReturnQryApplyDetailServiceImpl.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private EnumsService enumsService;

    public DzcsInvoiceReturnQryApplyDetailRspBO query(DzcsInvoiceReturnQryApplyDetailReqBO reqBO) {
        if (isDebugEnabled) {
            logger.debug("\u7535\u5b50\u8d85\u5e02\u67e5\u770b\u9000\u7968\u7533\u8bf7\u8be6\u60c5\u9875\u9762\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u6c42\u5165\u53c2\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getBillNo())) {
            throw new PfscExtBusinessException("0001", "\u9000\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String billNo = reqBO.getBillNo();
        InvoiceReturn invoiceReturn = this.invoiceReturnMapper.selectByPrimaryKey(billNo);
        if (invoiceReturn == null) {
            throw new PfscExtBusinessException("0001", "\u9000\u7968\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e");
        }
        DzcsInvoiceReturnQryApplyDetailRspBO resultRspBO = new DzcsInvoiceReturnQryApplyDetailRspBO();
        resultRspBO.setAuthRemark(invoiceReturn.getAuthRemark());
        resultRspBO.setCreateMail(invoiceReturn.getCreateMail());
        resultRspBO.setCreateOrg(invoiceReturn.getCreateOrg());
        resultRspBO.setCreatePhone(invoiceReturn.getCreatePhone());
        resultRspBO.setCreateUser(invoiceReturn.getCreateUser());
        resultRspBO.setReturnRemark(invoiceReturn.getRemark());
        resultRspBO.setType(invoiceReturn.getType());
        resultRspBO.setTypeDescr(this.enumsService.getDescr(InvoiceReturnType.getInstance(invoiceReturn.getType())));
        ArrayList<DzcsInvoiceReturnQryApplyDetailItemRspBO> detailItemList = new ArrayList<DzcsInvoiceReturnQryApplyDetailItemRspBO>();
        resultRspBO.setDetailItemList(detailItemList);
        InvoiceReturnDetailVO vo = new InvoiceReturnDetailVO();
        vo.setBillNo(invoiceReturn.getBillNo());
        vo.setOrderBy("BILL_NO, APPLY_NO_1");
        List<InvoiceReturnDetail> returnDetailList = this.invoiceReturnDetailMapper.selectList(vo);
        for (InvoiceReturnDetail detailVO : returnDetailList) {
            vo.setBillNoConcatInvoiceNo(detailVO.getBillNo() + "-" + detailVO.getInvoiceNo1());
            List<InvoiceReturnDetailExt> detailExtList = this.invoiceReturnDetailMapper.selectJoinApplyAndInvoice(vo);
            DzcsInvoiceReturnQryApplyDetailItemRspBO itemRspBO = new DzcsInvoiceReturnQryApplyDetailItemRspBO();
            for (InvoiceReturnDetailExt extBO : detailExtList) {
                DzcsInvoiceReturnQryApplyDetailItemRspBO.DzcsInvoiceReturnQryInvoiceDetailRspBO invoiceDetailRspBO = new DzcsInvoiceReturnQryApplyDetailItemRspBO.DzcsInvoiceReturnQryInvoiceDetailRspBO(itemRspBO);
                BeanUtils.copyProperties((Object)extBO, (Object)invoiceDetailRspBO);
                Integer invoiceTypeValue = StringUtils.isEmpty((String)invoiceDetailRspBO.getInvoiceType()) ? null : Integer.valueOf(Integer.parseInt(invoiceDetailRspBO.getInvoiceType()));
                invoiceDetailRspBO.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(invoiceTypeValue)));
                invoiceDetailRspBO.setInvoiceClassesDescr(this.enumsService.getDescr(InvoiceClasses.getInstance(invoiceDetailRspBO.getInvoiceClasses())));
                invoiceDetailRspBO.setInvoiceStatusDescr(this.enumsService.getDescr(SaleInvoiceInfoInvoiceStatus.getInstance(invoiceDetailRspBO.getInvoiceStatus())));
                invoiceDetailRspBO.setInvoiceUrl(FileUtils.obtainOSSUrl(invoiceDetailRspBO.getElectronicInvoiceName()));
                if ("1".equals(extBO.getReturnFlag())) {
                    itemRspBO.setOriginInvoiceDetailRspBO(invoiceDetailRspBO);
                    continue;
                }
                if ("2".equals(extBO.getReturnFlag())) {
                    itemRspBO.setRedInvoiceDetailRspBO(invoiceDetailRspBO);
                    continue;
                }
                if (!"3".equals(extBO.getReturnFlag())) continue;
                itemRspBO.setBlueInvoiceDetailRspBO(invoiceDetailRspBO);
            }
            detailItemList.add(itemRspBO);
        }
        return resultRspBO;
    }
}

