/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.pfscext.api.deal.GetElectronicInvoiceService;
import com.tydic.pfscext.api.deal.bo.InvoiceInfoBO;
import com.tydic.pfscext.base.ComFscFileAppBO;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.external.utils.ESBParamUtil;
import com.tydic.pfscext.external.utils.http.HSHttpHelper;
import com.tydic.pfscext.external.utils.http.HSNHttpHeader;
import com.tydic.pfscext.external.utils.http.HttpRetBean;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.http.Header;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.GetElectronicInvoiceService"})
public class GetElectronicInvoiceServiceImpl
implements GetElectronicInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(GetElectronicInvoiceServiceImpl.class);
    @Autowired
    private Environment prop;
    @Autowired
    private FileClient fileClient;
    private static final String path = "pesapp-common";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;

    @PostMapping(value={"getElectronicInvoice"})
    public InvoiceInfoBO getElectronicInvoice(@RequestBody InvoiceInfoBO invoiceInfoReqBO) {
        try {
            InvoiceInfoBO invoiceInfoBO = new InvoiceInfoBO();
            String fileUrl = invoiceInfoReqBO.getElectronicInvoiceUrl();
            if (fileUrl == null || "".equals(fileUrl)) {
                fileUrl = this.getFileUrl(invoiceInfoReqBO);
            }
            File file = this.getFileByUrl(fileUrl);
            invoiceInfoBO = this.upload(file, invoiceInfoReqBO);
            invoiceInfoBO.setRespCode("0000");
            invoiceInfoBO.setRespDesc("\u6210\u529f");
            return invoiceInfoBO;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7535\u5b50\u53d1\u7968\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u83b7\u53d6\u7535\u5b50\u53d1\u7968\u5931\u8d25");
        }
    }

    private InvoiceInfoBO upload(File file, InvoiceInfoBO invoiceInfoBO) {
        InputStream inputStream = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            inputStream = multipartFile.getInputStream();
            String fileName = multipartFile.getOriginalFilename();
            String suffix = fileName.substring(fileName.lastIndexOf("."));
            byte[] bytes = new byte[inputStream.available()];
            inputStream.read(bytes);
            ComFscFileAppBO comFscFileAppBO = new ComFscFileAppBO();
            comFscFileAppBO.setFile(bytes);
            comFscFileAppBO.setFileName(fileName);
            comFscFileAppBO.setFileType(suffix);
            InvoiceInfoBO invoiceInfoBO2 = this.upload(comFscFileAppBO, invoiceInfoBO);
            return invoiceInfoBO2;
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error("\u6587\u4ef6\u4e0a\u4f20\u5173\u95ed\u6d41\u5931\u8d25");
            }
        }
    }

    private InvoiceInfoBO upload(ComFscFileAppBO file, InvoiceInfoBO invoiceInfoBO) {
        String fileUrl;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getFile());
        String fileName = null;
        fileName = invoiceInfoBO.getFlag() == 1 ? invoiceInfoBO.getNotificationNo() + file.getFileType() : invoiceInfoBO.getApplyNo() + file.getFileType();
        String path = this.fileClient.uploadFileByInputStream(path, fileName, (InputStream)inputStream);
        if ("OSS".equals(this.fileType)) {
            String httphead = "https://";
            if (path.endsWith(".jpg") || path.endsWith(".jpeg") || path.endsWith(".png") || path.endsWith(".pdf")) {
                httphead = "http://";
            }
            fileUrl = httphead + this.ossFileUrl + path;
        } else if ("FASTDFS".equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            String httphead = "http://";
            fileUrl = httphead + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        invoiceInfoBO.setElectronicInvoiceName(fileName);
        invoiceInfoBO.setElectronicInvoiceUrl(fileUrl);
        return invoiceInfoBO;
    }

    private String getFileUrl(InvoiceInfoBO invoiceInfoReqBO) {
        JSONObject rspJsonObject;
        HttpRetBean httpRetBean;
        String fileUrl = null;
        StringBuffer sb = new StringBuffer();
        String reqStr = null;
        reqStr = invoiceInfoReqBO.getFlag() == 1 ? sb.append("{").append("\"markId\":").append("\"" + invoiceInfoReqBO.getNotificationNo() + "\",").append("}").toString() : sb.append("{").append("\"markId\":").append("\"" + invoiceInfoReqBO.getApplyNo() + "\",").append("}").toString();
        String hsn = this.prop.getProperty("SUPPLIER_ID_" + invoiceInfoReqBO.getSupplierId());
        String reqEsbStr = ESBParamUtil.getEsbReqStr((String)reqStr, (String)hsn, (String)"BUSINESS_PAY");
        log.info("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1--->\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u670d\u52a1\u5b9e\u73b0\u7c7b--\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u62a5\u6587:" + reqEsbStr);
        try {
            httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.prop.getProperty("ESB_ELECTRONIC_INVOICE_URL")), (Header[])HSNHttpHeader.getRequestHeaders((String)"json"), (byte[])reqEsbStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
        }
        catch (Exception e) {
            log.error("\u4eac\u4e1c\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1--->\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u6570\u636e\u63a5\u53e3\u5931\u8d25,\u5f00\u59cb\u65e5\u671f\u4e3a" + invoiceInfoReqBO.getSupplierId(), (Throwable)e);
            throw new PfscExternalBusinessException("18002", "\u8c03\u7528\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u5931\u8d25");
        }
        if (httpRetBean.getStatus() != 200) {
            log.error("\u8c03\u7528\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_RECONCILITION_QUERY_JD_URL") + "]");
            throw new RuntimeException("\u8c03\u7528\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25");
        }
        log.info("\u8c03\u7528\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
        String returnString = httpRetBean.getStr();
        if (StringUtils.isEmpty((Object)returnString)) {
            log.info("\u8c03\u7528\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            throw new RuntimeException("\u8c03\u7528\u83b7\u53d6\u5bf9\u8d26\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        log.debug("--\u63a5\u53e3\u8fd4\u56de\u7684\u62a5\u6587:" + returnString);
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error("\u4eac\u4e1c\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519" + returnString, (Throwable)e);
            throw new PfscExternalBusinessException("18000", "\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
        }
        String resultCode = (String)rspJsonObject.get((Object)"resultCode");
        Boolean success = (Boolean)rspJsonObject.get((Object)"success");
        if (null == resultCode) {
            log.error("\u4eac\u4e1c\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u51fa\u9519,\u7f3a\u5c11resultCode");
            throw new PfscExternalBusinessException("18000", "\u4eac\u4e1c\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u51fa\u9519,\u7f3a\u5c11resultCode");
        }
        if (success.equals(true) || "9000".equals(resultCode)) {
            JSONObject jsonObject = null;
            try {
                jsonObject = (JSONObject)rspJsonObject.get((Object)"result");
            }
            catch (Exception e) {
                log.error("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u83b7\u53d6\u8fd4\u56de\u5f00\u7968\u4fe1\u606f\u9519\u8bef", (Throwable)e);
                throw new PfscExternalBusinessException("18000", "\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u83b7\u53d6\u8fd4\u56de\u5f00\u7968\u4fe1\u606f\u9519\u8bef");
            }
            JSONObject js = (JSONObject)jsonObject.get((Object)"orderDetail ");
            fileUrl = js.getString("fileUrl");
        }
        return fileUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFileByUrl(String fileUrl) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        FilterOutputStream stream = null;
        InputStream inputStream = null;
        File file = null;
        try {
            URL imageUrl = new URL(fileUrl);
            HttpURLConnection conn = (HttpURLConnection)imageUrl.openConnection();
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            inputStream = conn.getInputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            file = File.createTempFile("file", fileUrl.substring(fileUrl.lastIndexOf("."), fileUrl.length()));
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            stream = new BufferedOutputStream(fileOutputStream);
            stream.write(outStream.toByteArray());
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (stream != null) {
                    stream.close();
                }
                outStream.close();
            }
            catch (Exception exception) {}
        }
        return file;
    }
}

