/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.utils;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanUtils {
    private static final Log logger = LogFactory.getLog(BeanUtils.class);

    public static void null2DefaultValue(Object object) {
        if (object != null) {
            Field[] fields;
            for (Field field : fields = object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    if (field.get(object) != null || field.getType() != String.class) continue;
                    field.set(object, "");
                }
                catch (Exception e) {
                    logger.error((Object)"\u628anull\u5b57\u6bb5\u8f6c\u6362\u4e3a\u9ed8\u8ba4\u503c\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    public static <T> Map<String, Object> bean2Map(T bean) throws IllegalAccessException {
        Field[] fields;
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        for (Field field : fields = bean.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            result.put(field.getName(), field.get(bean));
        }
        Class<?> superclass = bean.getClass().getSuperclass();
        if (superclass != null) {
            for (Field field : fields = superclass.getDeclaredFields()) {
                field.setAccessible(true);
                result.put(field.getName(), field.get(bean));
            }
        }
        return result;
    }
}

