/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiAddPayAbleService;
import com.tydic.pfscext.api.busi.bo.BusiAddPayAbleReqBO;
import com.tydic.pfscext.api.busi.bo.BusiAddPayAbleRspBO;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.BillSNService;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiAddPayAbleService"})
public class BusiAddPayAbleServiceImpl
implements BusiAddPayAbleService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAddPayAbleServiceImpl.class);
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private PayableDetailMapper payableDetailMapper;

    @PostMapping(value={"createPayAble"})
    public BusiAddPayAbleRspBO createPayAble(@RequestBody BusiAddPayAbleReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u751f\u6210\u5e94\u4ed8\u5355\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getSource() == null || "".equals(reqBO.getSource())) {
            throw new PfscExtBusinessException("0001", "\u6765\u6e90\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new PfscExtBusinessException("0001", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayType() || "".equals(reqBO.getPayType())) {
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayableType()) {
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiAddPayAbleRspBO rspBO = new BusiAddPayAbleRspBO();
        try {
            PayableDetailPO po = new PayableDetailPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)po);
            Long snNo = this.billSNService.getSn(BillType.PAYABLE_ACCOUNT);
            po.setPayableNo(String.valueOf(snNo));
            po.setPaidAmt(BigDecimal.ZERO);
            po.setPendingAmt(BigDecimal.ZERO);
            po.setPaidDate(new Date());
            this.payableDetailMapper.insert(po);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rspBO;
    }
}

