/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiCheckAccountBalanceManageService;
import com.tydic.pfscext.api.busi.bo.BusiCheckAccountBalanceManageReqBO;
import com.tydic.pfscext.api.busi.bo.BusiCheckAccountBalanceManageRspBO;
import com.tydic.pfscext.api.busi.bo.SubAcctInfoExt;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SubAcctInfoMapper;
import com.tydic.pfscext.dao.TranDetailMapper;
import com.tydic.pfscext.dao.bo.TranDetailExt;
import com.tydic.pfscext.dao.vo.BillApplyInfoVO;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.SubAccountServiceType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.atom.RoleService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiCheckAccountBalanceManageServiceImpl
implements BusiCheckAccountBalanceManageService {
    private static final Logger logger = LoggerFactory.getLogger(BusiCheckAccountBalanceManageServiceImpl.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private SubAcctInfoMapper subAcctInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private TranDetailMapper tranDetailMapper;
    @Autowired
    private RoleService roleService;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    public PfscExtRspPageBaseBO<BusiCheckAccountBalanceManageRspBO> query(BusiCheckAccountBalanceManageReqBO reqBO) {
        if (isDebugEnabled) {
            logger.debug("\u67e5\u8be2\u5bf9\u8d26\u4f59\u989d\u7ba1\u7406\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getCompanyId() == null || reqBO.getCompanyId() <= 0L) {
            throw new PfscExtBusinessException("0001", "\u4e13\u4e1a\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean isDepartSettle = this.roleService.isOperUnitSettleRole(reqBO.getUserId());
        List<Object> childrenOrgIds = new ArrayList();
        if (!isDepartSettle) {
            childrenOrgIds = this.organizationInfoService.getChildrenOrgIds(reqBO.getCompanyId());
        }
        logger.info("\u5b50\u673a\u6784\u96c6\u5408\u4e3a\uff1a" + childrenOrgIds);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        SubAcctInfoExt subAcctInfoExt = new SubAcctInfoExt();
        if (childrenOrgIds != null && childrenOrgIds.size() > 0) {
            subAcctInfoExt.setMultiOrgIds(childrenOrgIds);
        }
        subAcctInfoExt.setProjectId(reqBO.getProjectId());
        subAcctInfoExt.setSource(OrderSource.ELECTRIC_AREA.getCode());
        subAcctInfoExt.setServiceType(SubAccountServiceType.DEFAULT.getCode());
        int total = this.subAcctInfoMapper.selectCountWihtMainAcct(subAcctInfoExt);
        page.setTotalCount(total);
        subAcctInfoExt.setPageSize(Integer.valueOf(page.getPageSize()));
        subAcctInfoExt.setRowIndex(Integer.valueOf(page.getPageSize() * (page.getPageNo() - 1)));
        subAcctInfoExt.setOrderBy("SUB_ACCT_NAME ASC");
        List<SubAcctInfoExt> extList = this.subAcctInfoMapper.selectWihtMainAcct(subAcctInfoExt);
        ArrayList<BusiCheckAccountBalanceManageRspBO> rows = new ArrayList<BusiCheckAccountBalanceManageRspBO>();
        for (SubAcctInfoExt ext : extList) {
            BusiCheckAccountBalanceManageRspBO row = new BusiCheckAccountBalanceManageRspBO();
            row.setSubAcctNo(ext.getSubAcctNo());
            row.setSubAcctName(ext.getSubAcctName());
            row.setInvoiceAmtSum(this.getAmtSumApplyInfo(ext.getProjectId(), OrderSource.ELECTRIC_AREA.getCode(), BillStatus.SEND_BILL.getCode(), ext.getSuperiorOrgId()));
            row.setAddItemAmtSum(this.getTranDetailAddItemSum(ext.getSubAcctNo()));
            row.setCheckBalanceAmtSum(row.getAddItemAmtSum().subtract(row.getInvoiceAmtSum()));
            rows.add(row);
        }
        PfscExtRspPageBaseBO resultRspBO = new PfscExtRspPageBaseBO();
        resultRspBO.setRows(rows);
        resultRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        resultRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        resultRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return resultRspBO;
    }

    private BigDecimal getAmtSumApplyInfo(Long projectId, String source, String billStatus, Long operUnitNo) {
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setPurchaseProjectId(projectId);
        billApplyInfoVO.setBillStatus(billStatus);
        billApplyInfoVO.setSource(source);
        billApplyInfoVO.setOperUnitNo(operUnitNo);
        BigDecimal sumAmt = this.billApplyInfoMapper.getAmtSumApplyInfo(billApplyInfoVO);
        return sumAmt;
    }

    private BigDecimal getTranDetailAddItemSum(String subAcctNo) {
        TranDetailExt ext = new TranDetailExt();
        ext.setSubAcctNo(subAcctNo);
        BigDecimal addItemAmt = this.tranDetailMapper.selectManageTranDetailSum(ext);
        return addItemAmt;
    }
}

