/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.QueryPayableDetailByIdService;
import com.tydic.pfscext.api.busi.bo.PayableDetailBO;
import com.tydic.pfscext.api.busi.bo.QueryPayableDetailByIdReqBO;
import com.tydic.pfscext.api.busi.bo.QueryPayableDetailByIdRspBO;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.SupplierInfoMapper;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrderService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.atom.bo.SaleOrderBO;
import com.tydic.pfscext.utils.FscStringUtils;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoDetailAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityRspBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.QueryPayableDetailByIdService"})
public class QueryPayableDetailByIdServiceImpl
implements QueryPayableDetailByIdService {
    private static final Logger logger = LoggerFactory.getLogger(QueryPayableDetailByIdServiceImpl.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private SupplierInfoMapper supplierInfoMapper;
    @Autowired
    private OrderService orderService;
    @Autowired
    private UmcQrySupplierInfoDetailAbilityService umcQrySupplierInfoDetailAbilityService;

    @PostMapping(value={"queryById"})
    public QueryPayableDetailByIdRspBO queryById(@RequestBody QueryPayableDetailByIdReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5e94\u4ed8\u660e\u7ec6\u8868\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getIds())) {
            throw new PfscExtBusinessException("18001", "\u5e94\u4ed8\u660e\u7ec6\u8868\u8be6\u60c5\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1-\u5165\u53c2ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryPayableDetailByIdRspBO rspBO = new QueryPayableDetailByIdRspBO();
        List idList = reqBO.getIds();
        LinkedList<PayableDetailBO> payDetailBOList = new LinkedList<PayableDetailBO>();
        HashSet<Long> purchaseOrderIdsSet = new HashSet<Long>();
        for (String id : idList) {
            PayableDetailPO payableDetailPO = this.payableDetailMapper.getModelById(id);
            if (payableDetailPO == null) {
                throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u7f16\u53f7:" + id + "\uff0c\u5728\u5e94\u4ed8\u5355\u8be6\u60c5\u67e5\u8be2\u4e2d\u65e0\u5339\u914d\u7ed3\u679c");
            }
            String payType = payableDetailPO.getPayType();
            UmcQrySupplierInfoDetailAbilityReqBO umcQrySupplierInfoDetailAbilityReqBO = new UmcQrySupplierInfoDetailAbilityReqBO();
            umcQrySupplierInfoDetailAbilityReqBO.setSupplierId(payableDetailPO.getSupplierId());
            UmcQrySupplierInfoDetailAbilityRspBO umcQrySupplierInfoDetailAbilityRspBO = this.umcQrySupplierInfoDetailAbilityService.qrySupplierInfoDetail(umcQrySupplierInfoDetailAbilityReqBO);
            if (null != umcQrySupplierInfoDetailAbilityRspBO) {
                String bankName;
                String bankAccountName;
                String bankAcct = umcQrySupplierInfoDetailAbilityRspBO.getBankAccount();
                if (null != bankAcct && !"".equals(bankAcct)) {
                    rspBO.setBankAcct(bankAcct);
                }
                if (null != (bankAccountName = umcQrySupplierInfoDetailAbilityRspBO.getBankAccountName()) && !"".equals(bankAccountName)) {
                    rspBO.setRecieverAcctName(bankAccountName);
                }
                if (null != (bankName = umcQrySupplierInfoDetailAbilityRspBO.getBankName()) && !"".equals(bankName)) {
                    rspBO.setOpenBank(bankName);
                }
            }
            rspBO.setSupplierId(String.valueOf(payableDetailPO.getSupplierId()));
            String supplierStr = this.organizationInfoService.querySupplierName(payableDetailPO.getSupplierId());
            rspBO.setSupplierName(supplierStr);
            PayableDetailBO payableDetailBO = new PayableDetailBO();
            BeanUtils.copyProperties((Object)payableDetailPO, (Object)payableDetailBO);
            payableDetailBO.setOrderId(FscStringUtils.valueOf(payableDetailPO.getOrderId()));
            if (payableDetailPO.getOrderId() != null) {
                purchaseOrderIdsSet.add(payableDetailPO.getOrderId());
            }
            BigDecimal payingAmt = payableDetailBO.getPayableAmt().subtract(payableDetailBO.getPendingAmt()).subtract(payableDetailBO.getPaidAmt());
            payableDetailBO.setPayingAmt(payingAmt);
            payableDetailBO.setSupplierStr(supplierStr);
            PayableStatus payableEnum = PayableStatus.getInstance(payableDetailBO.getPayableStatus());
            payableDetailBO.setPayableStatusStr(this.enumsService.getDescr(payableEnum));
            OrderSource orderSourceEnum = OrderSource.getInstance((String)payableDetailBO.getSource());
            payableDetailBO.setSourceStr(this.enumsService.getDescr((BaseEnums)orderSourceEnum));
            String orgNameStr = this.organizationInfoService.queryOrgName(payableDetailBO.getOperatorId());
            payableDetailBO.setOperatorStr(orgNameStr);
            SaleOrderBO saleOrderBO = this.orderService.obtainSaleOrder(payableDetailPO.getOrderId());
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setSource(payableDetailPO.getSource());
            saleOrderInfoVO.setOrderId(saleOrderBO.getSaleOrderId());
            saleOrderInfoVO.setSaleOrderCode(saleOrderBO.getSaleOrderCode());
            payDetailBOList.add(payableDetailBO);
        }
        rspBO.setRows(payDetailBOList);
        return rspBO;
    }
}

