/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiSumUpSaleOrderInfoService;
import com.tydic.pfscext.api.busi.bo.BusiAddBillApplyInfoByItemsDetailReqBO;
import com.tydic.pfscext.api.busi.bo.BusiAddBillApplyInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiSumUpSaleOrderInfoRspBO;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiSumUpSaleOrderInfoService"})
public class BusiSumUpSaleOrderInfoServiceImpl
implements BusiSumUpSaleOrderInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiSumUpSaleOrderInfoServiceImpl.class);
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;

    @PostMapping(value={"query"})
    public BusiSumUpSaleOrderInfoRspBO query(@RequestBody BusiAddBillApplyInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u7edf\u8ba1\u9500\u552e\u8ba2\u5355\u7b14\u6570\u548c\u91d1\u989d\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)(\u4e13\u4e1a\u516c\u53f8\u548c\u91c7\u8d2d\u5355\u4f4d\u5171\u7528)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer type = reqBO.getType();
        if (type == null || type <= 0) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u7533\u8bf7\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getInspectionIds())) {
            throw new PfscExtBusinessException("0001", "\u672a\u52fe\u9009\u8ba2\u5355\u6570\u636e\uff0c\u8bf7\u9009\u62e9");
        }
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        saleOrderInfoVO.setInspectionIdList(reqBO.getInspectionIds());
        List<SaleOrderInfo> saleOrderList = this.saleOrderInfoMapper.getList(saleOrderInfoVO);
        HashSet<Long> purchaseProjectIdSets = new HashSet<Long>();
        for (SaleOrderInfo saleOrderInfo : saleOrderList) {
            purchaseProjectIdSets.add(saleOrderInfo.getPurchaseProjectId());
        }
        if (purchaseProjectIdSets.size() > 1) {
            throw new PfscExtBusinessException("0001", "\u4e0d\u540c\u91c7\u8d2d\u5355\u4f4d\u4e0d\u80fd\u4e00\u8d77\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7");
        }
        BigDecimal totalAmt = BigDecimal.ZERO;
        HashSet<Long> inspectionSets = new HashSet<Long>();
        if (type == 1) {
            List inspectionIds = reqBO.getInspectionIds();
            SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
            saleItemInfoVO.setInspectionIdList(inspectionIds);
            saleItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
            List<SaleItemInfoVO> saleItemList = this.saleItemInfoMapper.querySaleJoinOrderItemList(saleItemInfoVO);
            if (saleItemList.isEmpty()) {
                throw new PfscExtBusinessException("18001", "\u8ba2\u5355\u660e\u7ec6\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e");
            }
            for (SaleItemInfoVO saleItemVO : saleItemList) {
                BigDecimal quantityRemain = saleItemVO.getQuantity().subtract(saleItemVO.getQuantityApplied());
                BigDecimal amountRemain = saleItemVO.getAmount().subtract(saleItemVO.getAmountApplied());
                inspectionSets.add(saleItemVO.getInspectionId());
                if (quantityRemain.compareTo(BigDecimal.ZERO) <= 0 || amountRemain.compareTo(BigDecimal.ZERO) <= 0) continue;
                totalAmt = totalAmt.add(amountRemain);
            }
            HashSet inspectionIdsSet = new HashSet(inspectionIds);
            inspectionIdsSet.removeAll(inspectionSets);
            if (inspectionIdsSet.size() > 0) {
                StringBuffer notFoundOrder = new StringBuffer();
                for (Long inspectionId : inspectionIdsSet) {
                    notFoundOrder.append(String.valueOf(inspectionId)).append(",");
                }
                throw new PfscExtBusinessException("18001", "\u4ee5\u4e0b\u9a8c\u6536\u5355\u53f7\u4e3a" + notFoundOrder + "\u7684\u8ba2\u5355\u5bf9\u5e94\u7684\u660e\u7ec6\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\uff01");
            }
        } else {
            List detailInfoList = reqBO.getDetailInfoList();
            if (detailInfoList == null || detailInfoList.isEmpty()) {
                throw new PfscExtBusinessException("0001", "\u8bf7\u9009\u62e9\u5f85\u63d0\u4ea4\u7684\u5546\u54c1\u660e\u7ec6");
            }
            for (BusiAddBillApplyInfoByItemsDetailReqBO detail : detailInfoList) {
                BigDecimal quantityApplied;
                BigDecimal quantityApply = detail.getQuantityApply();
                if (detail.getSeq() == null || detail.getSeq() <= 0L) {
                    throw new PfscExtBusinessException("0001", "\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (quantityApply == null || quantityApply.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new PfscExtBusinessException("0001", "\u5f85\u5f00\u7968\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
                }
                SaleItemInfo saleInfo = this.saleItemInfoMapper.getModelByPrimaryKey(detail.getSeq());
                if (saleInfo == null) {
                    throw new PfscExtBusinessException("0001", "\u5546\u54c1\u660e\u7ec6\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e");
                }
                BigDecimal quantity = saleInfo.getQuantity();
                if (quantityApply.compareTo(quantity.subtract(quantityApplied = saleInfo.getQuantityApplied())) > 0) {
                    throw new PfscExtBusinessException("0001", "\u586b\u5199\u7684\u5f00\u7968\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5269\u4f59\u53ef\u63d0\u5f00\u7968\u7533\u8bf7\u6570\u91cf");
                }
                BigDecimal amountToApply = saleInfo.getAmount().multiply(quantityApply).divide(quantity, 2, 4);
                BigDecimal amountRemain = saleInfo.getAmount().subtract(saleInfo.getAmountApplied());
                BigDecimal quantityRemain = quantity.subtract(quantityApplied);
                if (amountRemain.compareTo(amountToApply) <= 0) {
                    amountToApply = amountRemain;
                }
                if (quantityApply.compareTo(quantityRemain) == 0) {
                    amountToApply = amountRemain;
                }
                totalAmt = totalAmt.add(amountToApply);
                inspectionSets.add(saleInfo.getInspectionId());
            }
        }
        BusiSumUpSaleOrderInfoRspBO rspBO = new BusiSumUpSaleOrderInfoRspBO();
        rspBO.setInspectionIds(new LinkedList(inspectionSets));
        rspBO.setType(type);
        rspBO.setRecordsTotal(Integer.valueOf(inspectionSets.size()));
        rspBO.setTotalAmt(totalAmt);
        return rspBO;
    }
}

