/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiGetBillDataService;
import com.tydic.pfscext.api.busi.bo.BusiGetBillDataReqBO;
import com.tydic.pfscext.api.busi.bo.BusiGetBillDataRspBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.vo.BillApplyInfoVO;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.enums.ApplyType;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.InquiryPayFeeType;
import com.tydic.pfscext.enums.InvoiceClasses;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.SaleItemApplyInfoStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.busi.impl.BusiGetBillDataDzcsInvoiceReturnService;
import com.tydic.pfscext.utils.FscStringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiGetBillDataService"})
public class BusiGetBillDataServiceImpl
implements BusiGetBillDataService {
    private static final Logger logger = LoggerFactory.getLogger(BusiGetBillDataServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private BusiGetBillDataDzcsInvoiceReturnService busiGetBillDataDzcsInvoiceReturnService;

    @PostMapping(value={"getBills"})
    public BusiGetBillDataRspBO getBills(@RequestBody BusiGetBillDataReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u7a0e\u63a7\u83b7\u53d6\u5f00\u7968\u7533\u8bf7\u5355\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (null == reqBO.getCompany_no()) {
            throw new PfscExtBusinessException("0001", "\u4e13\u4e1a\u516c\u53f8\u7f16\u53f7[company_no]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiGetBillDataRspBO rspBO = new BusiGetBillDataRspBO();
        LinkedList<BusiGetBillDataRspBO.BusiGetBillData> result = new LinkedList<BusiGetBillDataRspBO.BusiGetBillData>();
        int pageSize = this.enumsService.queryTaxOrgQueryPageSize();
        Page page = new Page(1, pageSize);
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setOperUnitNo(reqBO.getCompany_no());
        billApplyInfoVO.setBillStatus(BillStatus.APPLIED.getCode());
        billApplyInfoVO.setInvoiceClasses(InvoiceClasses.PAPER_INVOICE.getCode());
        billApplyInfoVO.setOrderBy("t.INVOCE_NAME,t.NAME");
        List<BillApplyInfo> list1 = this.billApplyInfoMapper.getListPage(billApplyInfoVO, (Page<Map<String, Object>>)page);
        for (BillApplyInfo bai : list1) {
            String[] addrAndPhoneVal;
            BusiGetBillDataRspBO.BusiGetBillData busiGetBillData;
            if (OrderSource.ELECTRIC_MARKET.getCode().equals(bai.getSource()) && StringUtils.hasText((String)bai.getReturnBillNo())) {
                try {
                    List<BusiGetBillDataRspBO.BusiGetBillData> billsList = this.busiGetBillDataDzcsInvoiceReturnService.getBills(bai);
                    if (CollectionUtils.isEmpty(billsList)) continue;
                    result.addAll(billsList);
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u7535\u5b50\u8d85\u5e02\u9000\u7968\u5f00\u7968\u7533\u8bf7\u5355\u4fe1\u606f\u5931\u8d25!\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + bai.getApplyNo());
                }
                continue;
            }
            String applyNo = bai.getApplyNo();
            String source = bai.getSource();
            String applyType = bai.getApplyType();
            String payFeeType = bai.getPayFeeType();
            BigDecimal amt = bai.getAmt();
            if (OrderSource.ELECTRIC_MARKET.getCode().equals(source) || OrderSource.ELECTRIC_AREA.getCode().equals(source) || OrderSource.CONSULT_PRICE.getCode().equals(source) && !StringUtils.hasText((String)bai.getPayFeeType()) || OrderSource.COAL_AREA.getCode().equals(source)) {
                SaleItemInfoVO saleItemInfoVO;
                busiGetBillData = new BusiGetBillDataRspBO.BusiGetBillData(rspBO);
                busiGetBillData.setBill_no(applyNo);
                busiGetBillData.setBuyer_name(bai.getInvoceName());
                busiGetBillData.setBuyer_tax(FscStringUtils.valueOf(bai.getTaxNo()));
                addrAndPhoneVal = FscStringUtils.getCutStrByByte(bai.getAddr(), bai.getPhone(), "GBK", 100);
                busiGetBillData.setBuyer_addr(FscStringUtils.valueOf(addrAndPhoneVal[0]));
                busiGetBillData.setBuyer_tel(FscStringUtils.valueOf(addrAndPhoneVal[1]));
                busiGetBillData.setBuyer_bank(FscStringUtils.valueOf(bai.getBankName()));
                busiGetBillData.setBuyer_acc(FscStringUtils.valueOf(bai.getBankAcctNo()));
                if (InvoiceType.NORMAL.getCode().equals(Integer.valueOf(bai.getInvoiceType()))) {
                    busiGetBillData.setInvoice_type("2");
                } else {
                    busiGetBillData.setInvoice_type("0");
                }
                List<SaleItemInfo> list2 = null;
                if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(applyType)) {
                    saleItemInfoVO = new SaleItemInfoVO();
                    saleItemInfoVO.setApplyNo(applyNo);
                    saleItemInfoVO.setSaleItemApplyInfoStatus(SaleItemApplyInfoStatus.VALID.getCode());
                    list2 = this.saleItemInfoMapper.getListJoinSaleItemApplyInfo(saleItemInfoVO);
                } else {
                    saleItemInfoVO = new SaleItemInfoVO();
                    saleItemInfoVO.setApplyNo(applyNo);
                    list2 = this.saleItemInfoMapper.getList(saleItemInfoVO);
                }
                if (list2.isEmpty()) {
                    logger.error("\u6839\u636e\u5f00\u7968\u7533\u8bf7\u5355\u53f7[" + applyNo + "]\u67e5\u4e0d\u5230\u5546\u54c1\u660e\u7ec6");
                    continue;
                }
                String orgName = this.organizationInfoService.queryProjectName(bai.getPurchaseProjectId()).getPurchaseOrgName();
                HashSet<String> saleOrderCodes = new HashSet<String>();
                for (SaleItemInfo saleItemInfo : list2) {
                    saleOrderCodes.add(saleItemInfo.getSaleOrderCode());
                }
                StringBuilder notes = new StringBuilder();
                notes.append("\u91c7\u8d2d\u5355\u4f4d\uff1a").append(orgName).append(",\u8ba2\u5355\u7f16\u53f7\uff1a");
                notes = new StringBuilder(notes.toString().replace("(\u8d26\u5957)", ""));
                for (String saleOrderCode : saleOrderCodes) {
                    notes.append(saleOrderCode).append(",");
                }
                if (!saleOrderCodes.isEmpty()) {
                    notes.deleteCharAt(notes.length() - 1);
                }
                busiGetBillData.setNotes(notes.length() > 160 ? notes.substring(0, 160) : notes.toString());
                LinkedList<BusiGetBillDataRspBO.BusiGetBillData.BusiGetBillDataDetailRspBO> linkedList = new LinkedList<BusiGetBillDataRspBO.BusiGetBillData.BusiGetBillDataDetailRspBO>();
                boolean continueFlag = false;
                HashMap orders = new HashMap();
                for (SaleItemInfo saleItemInfo3 : list2) {
                    Long inspectionId = saleItemInfo3.getInspectionId();
                    BusiGetBillDataRspBO.BusiGetBillData.BusiGetBillDataDetailRspBO busiBillDataDetail = new BusiGetBillDataRspBO.BusiGetBillData.BusiGetBillDataDetailRspBO(busiGetBillData);
                    busiBillDataDetail.setOrder_no(saleItemInfo3.getInspectionId());
                    busiBillDataDetail.setLines_number(saleItemInfo3.getItemNo());
                    busiBillDataDetail.setMateriel_unit(saleItemInfo3.getUnitName());
                    busiBillDataDetail.setQuantity(saleItemInfo3.getQuantity());
                    if (!StringUtils.hasText((String)busiBillDataDetail.getTax_class_code())) {
                        logger.error("\u5546\u54c1\u6ca1\u6709\u83b7\u53d6\u5230\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u3002\u9a8c\u6536\u5355\u53f7=" + saleItemInfo3.getInspectionId() + "\uff0c\u5546\u54c1\u884c\u53f7=" + saleItemInfo3.getItemNo());
                        continueFlag = true;
                        break;
                    }
                    busiBillDataDetail.setPrice(saleItemInfo3.getSaleUnitPrice());
                    busiBillDataDetail.setAmount(saleItemInfo3.getAmount());
                    busiBillDataDetail.setTax(saleItemInfo3.getTaxAmt());
                    busiBillDataDetail.setTax_rate(saleItemInfo3.getTaxRate());
                    busiBillDataDetail.setTax_flag(Integer.valueOf(1));
                    String materiel_name = FscStringUtils.valueOf(saleItemInfo3.getSkuName());
                    materiel_name = materiel_name.replaceAll("\n", " ");
                    String materiel_standard = FscStringUtils.valueOf(saleItemInfo3.getSpec()) + FscStringUtils.valueOf(saleItemInfo3.getModel()) + FscStringUtils.valueOf(saleItemInfo3.getFigureNo());
                    materiel_standard = materiel_standard.replaceAll("\n", " ");
                    materiel_name = FscStringUtils.cutStringByByte(materiel_name, "GBK", 35);
                    materiel_standard = FscStringUtils.cutStringByByte(materiel_standard, "GBK", 30);
                    busiBillDataDetail.setMateriel_name(materiel_name);
                    busiBillDataDetail.setMateriel_standard(StringUtils.hasText((String)materiel_standard) ? materiel_standard : "\u65e0");
                    linkedList.add(busiBillDataDetail);
                }
                if (continueFlag) continue;
                busiGetBillData.setDetail(linkedList);
                result.add(busiGetBillData);
                continue;
            }
            if (!OrderSource.CONSULT_PRICE.getCode().equals(source)) continue;
            busiGetBillData = new BusiGetBillDataRspBO.BusiGetBillData(rspBO);
            busiGetBillData.setBill_no(applyNo);
            busiGetBillData.setBuyer_name(bai.getInvoceName());
            busiGetBillData.setBuyer_tax(FscStringUtils.valueOf(bai.getTaxNo()));
            addrAndPhoneVal = FscStringUtils.getCutStrByByte(bai.getAddr(), bai.getPhone(), "GBK", 100);
            busiGetBillData.setBuyer_addr(FscStringUtils.valueOf(addrAndPhoneVal[0]));
            busiGetBillData.setBuyer_tel(FscStringUtils.valueOf(addrAndPhoneVal[1]));
            busiGetBillData.setBuyer_bank(FscStringUtils.valueOf(bai.getBankName()));
            busiGetBillData.setBuyer_acc(FscStringUtils.valueOf(bai.getBankAcctNo()));
            if (InvoiceType.NORMAL.getCode().equals(Integer.valueOf(bai.getInvoiceType()))) {
                busiGetBillData.setInvoice_type("2");
            } else {
                busiGetBillData.setInvoice_type("0");
            }
            String materielName = null;
            String taxClassCode = null;
            if (InquiryPayFeeType.PLAT_USE_FEE.getCode().equals(payFeeType)) {
                materielName = this.enumsService.queryPlatUseFeeMaterialName();
                materielName = materielName.replaceAll("\n", " ");
                taxClassCode = this.enumsService.queryPlatUseFeeTaxClassCode();
            } else if (InquiryPayFeeType.TRADE_SERVICE_FEE.getCode().equals(payFeeType)) {
                materielName = this.enumsService.queryTradeServiceFeeMaterialName();
                materielName = materielName.replaceAll("\n", " ");
                taxClassCode = this.enumsService.queryTradeServiceFeeTaxClassCode();
            }
            if (!StringUtils.hasText((String)materielName)) {
                logger.error("\u5f00\u7968\u7533\u8bf7\u5355[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "]\u7684\u7269\u6599\u540d\u79f0\u4e0d\u6b63\u786e");
                continue;
            }
            if (!StringUtils.hasText(taxClassCode)) {
                logger.error("\u5f00\u7968\u7533\u8bf7\u5355[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "]\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u6b63\u786e");
                continue;
            }
            LinkedList<BusiGetBillDataRspBO.BusiGetBillData.BusiGetBillDataDetailRspBO> detail = new LinkedList<BusiGetBillDataRspBO.BusiGetBillData.BusiGetBillDataDetailRspBO>();
            BusiGetBillDataRspBO.BusiGetBillData.BusiGetBillDataDetailRspBO busiBillDataDetail = new BusiGetBillDataRspBO.BusiGetBillData.BusiGetBillDataDetailRspBO(busiGetBillData);
            busiBillDataDetail.setOrder_no(Long.valueOf(0L));
            busiBillDataDetail.setLines_number(Long.valueOf(0L));
            busiBillDataDetail.setMateriel_unit("");
            busiBillDataDetail.setQuantity(BigDecimal.ONE);
            busiBillDataDetail.setTax_class_code(taxClassCode);
            busiBillDataDetail.setPrice(amt);
            busiBillDataDetail.setAmount(amt);
            busiBillDataDetail.setTax(null);
            busiBillDataDetail.setTax_rate(this.enumsService.queryDefaultServiceFeeTaxRate());
            busiBillDataDetail.setTax_flag(Integer.valueOf(1));
            materielName = FscStringUtils.cutStringByByte(materielName, "GBK", 35);
            busiBillDataDetail.setMateriel_name(materielName);
            busiBillDataDetail.setMateriel_standard("");
            detail.add(busiBillDataDetail);
            busiGetBillData.setDetail(detail);
            result.add(busiGetBillData);
        }
        rspBO.setResult(result);
        return rspBO;
    }
}

