/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiPushSaleOrderInfoService;
import com.tydic.pfscext.api.busi.bo.BusiPushSaleOrderInfoItemReqBO;
import com.tydic.pfscext.api.busi.bo.BusiPushSaleOrderInfoOrderReqBO;
import com.tydic.pfscext.api.busi.bo.BusiPushSaleOrderInfoReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.enums.SaleOrderPayType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiPushSaleOrderInfoService"})
public class BusiPushSaleOrderInfoServiceImpl
implements BusiPushSaleOrderInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiPushSaleOrderInfoServiceImpl.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private EnumsService enumsService;

    @PostMapping(value={"add"})
    public PfscExtRspBaseBO add(@RequestBody BusiPushSaleOrderInfoReqBO reqBO) {
        BusiPushSaleOrderInfoOrderReqBO orderInfo;
        if (logger.isDebugEnabled()) {
            logger.debug("\u63a5\u6536\u8ba2\u5355\u4e2d\u5fc3\u63a8\u9001\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOrderInfo() != null && reqBO.getOrderInfo().getWelfareType() != null && reqBO.getOrderInfo().getWelfareType() != "") {
            if ("\u5de5\u4f1a".equals(reqBO.getOrderInfo().getWelfareType())) {
                reqBO.getOrderInfo().setWelfareType("1");
            } else {
                reqBO.getOrderInfo().setWelfareType("2");
            }
        }
        if ((orderInfo = reqBO.getOrderInfo()) == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u3010orderInfo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long orderId = orderInfo.getOrderId();
        Long inspectionId = orderInfo.getInspectionId();
        Long purchaseOrderId = orderInfo.getPurchaseOrderId();
        if (orderId == null || orderId <= 0L) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u9500\u552e\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (inspectionId == null || inspectionId <= 0L) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u9a8c\u6536\u5355\u53f7\u3010inspectionId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (purchaseOrderId == null || purchaseOrderId <= 0L) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7\u3010purchaseOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList itemList = reqBO.getItemList();
        if (itemList == null || itemList.isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u9500\u552e\u5546\u54c1\u4fe1\u606f\u3010itemList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Long, BusiPushSaleOrderInfoItemReqBO> itemMap = new HashMap<Long, BusiPushSaleOrderInfoItemReqBO>(itemList.size() + 1);
        for (BusiPushSaleOrderInfoItemReqBO itemInfo : itemList) {
            if (!itemMap.containsKey(itemInfo.getItemNo())) {
                itemMap.put(itemInfo.getItemNo(), itemInfo);
                continue;
            }
            BusiPushSaleOrderInfoItemReqBO itemInMap = (BusiPushSaleOrderInfoItemReqBO)itemMap.get(itemInfo.getItemNo());
            itemInMap.setQuantity(itemInMap.getQuantity().add(itemInfo.getQuantity()));
            itemInMap.setAmount(itemInMap.getAmount().add(itemInfo.getAmount()));
        }
        itemList = new ArrayList(itemMap.values());
        SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
        saleOrderInfo.setInspectionId(inspectionId);
        saleOrderInfo = this.saleOrderInfoMapper.getModelBy(saleOrderInfo);
        SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
        saleItemInfoVO.setInspectionId(inspectionId);
        ArrayList<String> itemStatusNotIn = new ArrayList<String>();
        itemStatusNotIn.add(OrderStatus.NO_APPLY.getCode());
        saleItemInfoVO.setItemStatusNotIn(itemStatusNotIn);
        int count = this.saleItemInfoMapper.selectCount(saleItemInfoVO);
        if (saleOrderInfo != null) {
            if (count > 0) {
                logger.error("\u4ea4\u6613\u5931\u8d25\uff1a\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u91cd\u590d\u63a8\u9001\uff0c\u4e14\u539f\u63a8\u9001\u9a8c\u6536\u5355\u6709\u5546\u54c1\u5df2\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7\u3002");
                throw new PfscExtBusinessException("18000", "\u4ea4\u6613\u5931\u8d25\uff1a\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u91cd\u590d\u63a8\u9001\uff0c\u4e14\u539f\u63a8\u9001\u9a8c\u6536\u5355\u6709\u5546\u54c1\u5df2\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7\u3002");
            }
            SaleItemInfo saleItemInfo = new SaleItemInfo();
            saleItemInfo.setInspectionId(inspectionId);
            this.saleItemInfoMapper.deleteBy(saleItemInfo);
            saleOrderInfo = new SaleOrderInfo();
            saleOrderInfo.setInspectionId(inspectionId);
            this.saleOrderInfoMapper.deleteBy(saleOrderInfo);
        }
        String source = orderInfo.getSource();
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
            saleOrderInfo = new SaleOrderInfo();
            saleOrderInfo.setOrderId(orderId);
            saleOrderInfo = this.saleOrderInfoMapper.getModelBy(saleOrderInfo);
            if (saleOrderInfo != null) {
                saleOrderInfo = new SaleOrderInfo();
                saleOrderInfo.setOrderId(orderId);
                this.saleOrderInfoMapper.deleteBy(saleOrderInfo);
                SaleItemInfo saleItemInfo = new SaleItemInfo();
                saleItemInfo.setOrderId(orderId);
                this.saleItemInfoMapper.deleteBy(saleItemInfo);
            }
        }
        saleOrderInfo = new SaleOrderInfo();
        BeanUtils.copyProperties((Object)orderInfo, (Object)saleOrderInfo);
        saleOrderInfo.setBusiModel(orderInfo.getBusiMode());
        String supplierName = this.organizationInfoService.querySupplierName(saleOrderInfo.getSupplierNo());
        saleOrderInfo.setSupplierName(supplierName);
        String orgName = this.organizationInfoService.queryOrgName(saleOrderInfo.getPurchaseNo());
        saleOrderInfo.setPurchaseName(orgName);
        orgName = this.organizationInfoService.queryOrgName(saleOrderInfo.getOperUnitNo());
        saleOrderInfo.setOperUnitName(orgName);
        saleOrderInfo.setApplyNo(null);
        saleOrderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        if (OrderSource.CONSULT_PRICE_FRAME.getCode().equals(source) || OrderSource.CONSULT_PRICE.getCode().equals(source)) {
            Object branchCompany = this.organizationInfoService.queryBranchCompanyByAccountId(saleOrderInfo.getPurchaseProjectId());
            saleOrderInfo.setBranchCompany((Long)branchCompany);
        }
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
            saleOrderInfo.setIsPayFlag("0");
        } else {
            saleOrderInfo.setIsPayFlag("2");
        }
        if (null != saleOrderInfo.getPayType()) {
            switch (saleOrderInfo.getPayType()) {
                case "0": {
                    saleOrderInfo.setPayType(SaleOrderPayType.BANK_RECEIVE.getCode());
                    break;
                }
                case "1": {
                    saleOrderInfo.setPayType(SaleOrderPayType.BILL_AGREEMENT.getCode());
                    break;
                }
                case "2": {
                    saleOrderInfo.setPayType(SaleOrderPayType.BILL_RECEIVE.getCode());
                }
            }
        } else {
            throw new PfscExtBusinessException("18000", "\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3010payType\u3011");
        }
        saleOrderInfo.setPayStatus(PayableStatus.PENDING.getCode());
        this.saleOrderInfoMapper.insert(saleOrderInfo);
        ArrayList<SaleItemInfo> saleItemInfoList = new ArrayList<SaleItemInfo>();
        for (BusiPushSaleOrderInfoItemReqBO itemInfo : itemList) {
            SaleItemInfo saleItemInfo = new SaleItemInfo();
            BeanUtils.copyProperties((Object)itemInfo, (Object)saleItemInfo);
            saleItemInfo.setOrderId(orderId);
            saleItemInfo.setSaleOrderCode(saleOrderInfo.getSaleOrderCode());
            saleItemInfo.setInspectionId(inspectionId);
            saleItemInfo.setPurchaseOrderId(purchaseOrderId);
            saleItemInfo.setApplyNo(null);
            saleItemInfo.setItemStatus(OrderStatus.NO_APPLY.getCode());
            if (!StringUtils.hasText((String)saleItemInfo.getUnitName())) {
                saleItemInfo.setUnitName("\u4e2a");
            }
            if (StringUtils.hasText((String)saleItemInfo.getSkuName()) && saleItemInfo.getSkuName().length() > 100) {
                saleItemInfo.setSkuName(saleItemInfo.getSkuName().substring(0, 100));
            }
            if (saleItemInfo.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            if (StringUtils.hasText((String)itemInfo.getTaxId())) {
                try {
                    saleItemInfo.setTaxCatCode(Long.parseLong(itemInfo.getTaxId()));
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u5931\u8d25,\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a:" + itemInfo.getTaxId());
                }
            }
            if (null == saleItemInfo.getTaxRate()) {
                saleItemInfo.setTaxRate(this.enumsService.queryDefaultTaxRate());
            } else {
                BigDecimal taxAmt = saleItemInfo.getAmount().divide(BigDecimal.ONE.add(new BigDecimal(saleItemInfo.getTaxRate().toString())), 5, 4).multiply(new BigDecimal(saleItemInfo.getTaxRate().toString())).setScale(2, 4);
                saleItemInfo.setUntaxAmt(saleItemInfo.getAmount().subtract(taxAmt));
                logger.error("taxAmt" + taxAmt + "UntaxAmt " + saleItemInfo.getUntaxAmt());
                saleItemInfo.setTaxAmt(taxAmt);
                logger.error("getAmount" + saleItemInfo.getAmount() + "taxAmt" + taxAmt);
            }
            if (null != saleItemInfo.getSettleRate() && saleItemInfo.getSettleRate().intValue() == 0) {
                saleItemInfo.setSettleRate(null);
            }
            if (null != saleItemInfo.getSettleRate()) {
                if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
                    saleItemInfo.setQuantitySale(itemInfo.getQuantity());
                    BigDecimal quantity = itemInfo.getQuantity().multiply(itemInfo.getSettleRate()).setScale(6, 4);
                    saleItemInfo.setQuantity(quantity);
                    saleItemInfo.setSaleUnitPriceSale(itemInfo.getSaleUnitPrice());
                    saleItemInfo.setSaleUnitPrice(itemInfo.getAmount().divide(quantity, 2, 4));
                    saleItemInfo.setUnitNameSale(itemInfo.getUnitName());
                    if (!StringUtils.hasText((String)saleItemInfo.getUnitNameSale())) {
                        saleItemInfo.setUnitNameSale("\u4e2a");
                    }
                    saleItemInfo.setUnitName(itemInfo.getSettleUnit());
                    if (!StringUtils.hasText((String)saleItemInfo.getUnitName())) {
                        saleItemInfo.setUnitName("\u4e2a");
                    }
                } else if (OrderSource.ELECTRIC_AREA.getCode().equals(source) || OrderSource.COAL_AREA.getCode().equals(source)) {
                    // empty if block
                }
            }
            saleItemInfoList.add(saleItemInfo);
        }
        if (saleItemInfoList.isEmpty()) {
            logger.error("\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u6ca1\u6709\u6709\u6548\u7684\u5546\u54c1\u660e\u7ec6\u3002");
            throw new PfscExtBusinessException("18000", "\u9a8c\u6536\u5355[\u9a8c\u6536\u5355\u53f7=" + inspectionId + "]\u6ca1\u6709\u6709\u6548\u7684\u5546\u54c1\u660e\u7ec6\u3002");
        }
        this.saleItemInfoMapper.insertBatch(saleItemInfoList);
        PfscExtRspBaseBO rspBo = new PfscExtRspBaseBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

