/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.utils;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Component;

@Component
@Lazy(value=false)
public class SpringApplicationContext
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Object getBean(String name) {
        return applicationContext.getBean(name);
    }

    public static <T> T getBean(String name, Class<T> t) {
        return (T)applicationContext.getBean(name, t);
    }

    public static <T> T getBean(Class<T> t) {
        return (T)applicationContext.getBean(t);
    }

    public static String getMessage(String code, Object[] args, Locale locale) {
        return applicationContext.getMessage(code, args, locale);
    }

    public static String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return applicationContext.getMessage(code, args, defaultMessage, locale);
    }

    public static boolean containsBean(String name) {
        return applicationContext.containsBean(name);
    }

    public static String getRootRealPath() throws IOException {
        return SpringApplicationContext.getApplicationContext().getResource("").getFile().getAbsolutePath();
    }

    public static String getResourceRootRealPath() throws IOException {
        return new DefaultResourceLoader().getResource("").getFile().getAbsolutePath();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringApplicationContext.applicationContext = applicationContext;
    }

    public static DataSourceTransactionManager getTransactionManager() {
        Map beansOfType = applicationContext.getBeansOfType(DataSourceTransactionManager.class);
        DataSourceTransactionManager dataSourceTransactionManager = null;
        for (String s : beansOfType.keySet()) {
            dataSourceTransactionManager = (DataSourceTransactionManager)beansOfType.get(s);
        }
        return dataSourceTransactionManager;
    }
}

