/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.order.uoc.constant.BusinessException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DuplicateCommitLimitAspect {
    private static final Logger log = LoggerFactory.getLogger(DuplicateCommitLimitAspect.class);
    @Autowired
    private CacheClient cacheService;
    @Value(value="${uoc.commit.limit:false}")
    private boolean limit;

    @Pointcut(value="@annotation(com.tydic.pfscext.annotation.DuplicateCommitLimit)")
    public void duplicateCommitLimit() {
    }

    @Before(value="duplicateCommitLimit()")
    public void deBefore(JoinPoint joinPoint) throws Throwable {
        log.error("\u6b63\u5728\u62e6\u622a\u8bf7\u6c42");
        if (!this.limit) {
            return;
        }
        String reqMd = null;
        Object[] args = joinPoint.getArgs();
        if (null != args && args.length > 0) {
            block11: {
                try {
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    reqMd = Hex.encodeHexString((byte[])md.digest(JSON.toJSONString((Object)args[0]).getBytes(StandardCharsets.UTF_8)));
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                    JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)args[0]));
                    Long userIdIn = (Long)jsonObject.get((Object)"userId");
                    if (null == userIdIn || 0L == userIdIn) break block11;
                    reqMd = userIdIn + joinPoint.toShortString();
                }
            }
            if (null != reqMd) {
                Object o = null;
                try {
                    o = this.cacheService.get(reqMd);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    reqMd = null;
                }
                if (null != o) {
                    throw new BusinessException("0100", "\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4");
                }
                if (null != reqMd) {
                    try {
                        this.cacheService.set(reqMd, (Object)"", 10);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

