/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.consumer;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.order.pec.ability.pay.UocPebUpdateBillStatusAbilityService;
import com.tydic.order.pec.bo.pay.UocPebUpdateBillStatusReqBO;
import com.tydic.pfscext.api.aisino.bo.BusiMakeNotificationReqBO;
import com.tydic.pfscext.api.busi.bo.QueryPayPurchaseOrderInfoAwaitReqBO;
import com.tydic.pfscext.api.busi.vo.InvoiceHeaderVO;
import com.tydic.pfscext.api.zm.bo.MakeBillApplyInfoMsgReqBO;
import com.tydic.pfscext.consumer.MakeNotificationConsumer;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleOrderInfoQueryVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.ReconciliationStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.SplitApplyService;
import com.tydic.pfscext.service.busi.BusiGenerateApplyService;
import com.tydic.pfscext.service.busi.bo.BusiGenerateApplyReqBO;
import com.tydic.pfscext.service.busi.bo.BusiGenerateApplyRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MakeApplyConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(MakeApplyConsumer.class);
    @Autowired
    private UocPebUpdateBillStatusAbilityService uocPebUpdateBillStatusAbilityService;
    @Autowired
    private SplitApplyService splitApplyService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private BusiGenerateApplyService busiGenerateApplyService;
    @Autowired
    private MakeNotificationConsumer makeNotificationConsumer;
    private final String PURCHASE = "purchaser";

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            String content = message.getContent();
            JSONObject jsonObject = JSONObject.parseObject((String)content);
            String s = jsonObject.get((Object)"makeApply").toString();
            MakeBillApplyInfoMsgReqBO makeBillApplyInfoMsgReqBO = (MakeBillApplyInfoMsgReqBO)JSONObject.parseObject((String)s, MakeBillApplyInfoMsgReqBO.class);
            SaleOrderInfoQueryVO vo = new SaleOrderInfoQueryVO();
            List<Long> inspectionIds = this.queryApplyOrderIds(makeBillApplyInfoMsgReqBO);
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setOrderStatus(OrderStatus.SENDING.getCode());
            saleOrderInfoVO.setInspectionIdList(inspectionIds);
            this.saleOrderInfoMapper.updateStatusBatchByOrderIds(saleOrderInfoVO);
            vo.setInspectionIdList(inspectionIds);
            vo.setOrderStatus(OrderStatus.SENDING.getCode());
            List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListByInspectionIds(vo);
            if (!CollectionUtils.isEmpty(saleOrderInfoList)) {
                List<List<SaleOrderInfo>> splitOrders = this.splitApplyService.splitApply(saleOrderInfoList, makeBillApplyInfoMsgReqBO.getGroupWay());
                ArrayList<Long> uocOrderIds = new ArrayList<Long>();
                for (List<SaleOrderInfo> splitOrder : splitOrders) {
                    try {
                        BusiGenerateApplyReqBO generateApplyReqBO = new BusiGenerateApplyReqBO();
                        BeanUtils.copyProperties((Object)makeBillApplyInfoMsgReqBO, (Object)((Object)generateApplyReqBO));
                        generateApplyReqBO.setSaleOrderInfoList(splitOrder);
                        BusiGenerateApplyRspBO busiGenerateApplyRspBO = this.busiGenerateApplyService.busiGenerateApply(generateApplyReqBO);
                        if (!"0000".equals(busiGenerateApplyRspBO.getRespCode())) continue;
                        List orderIdList = splitOrder.stream().map(SaleOrderInfo::getOrderId).collect(Collectors.toList());
                        uocOrderIds.addAll(orderIdList);
                    }
                    catch (Exception e) {
                        log.error("\u5f00\u7968\u7533\u8bf7\u5355\u751f\u6210\u4e1a\u52a1\u5931\u8d25:" + e.getMessage());
                    }
                }
                this.updateUocBillStatus(uocOrderIds, OrderStatus.APPLIED);
                try {
                    BusiMakeNotificationReqBO makeNotificationReqBO = new BusiMakeNotificationReqBO();
                    BeanUtils.copyProperties((Object)makeBillApplyInfoMsgReqBO, (Object)makeNotificationReqBO);
                    LinkedList<String> inspectionIdStrList = new LinkedList<String>();
                    for (Long id : inspectionIds) {
                        inspectionIdStrList.add(id + "");
                    }
                    makeNotificationReqBO.setInspectionIdList(inspectionIdStrList);
                    makeNotificationReqBO.setIsApplyDriveNoti("1");
                    makeNotificationReqBO.setGroupWay("0");
                    makeNotificationReqBO.setIsSelectOrder("1");
                    if ("1".equals(makeBillApplyInfoMsgReqBO.getRemarkWay())) {
                        InvoiceHeaderVO invoiceHeaderVO = new InvoiceHeaderVO();
                        invoiceHeaderVO.setInvoiceRemark(makeBillApplyInfoMsgReqBO.getInvoiceInfo().getInvoiceRemark());
                        makeNotificationReqBO.setInvoiceInfo(invoiceHeaderVO);
                    }
                    this.makeNotificationConsumer.makeNotification(makeNotificationReqBO);
                }
                catch (Exception e) {
                    log.error("\u4e0b\u6e38\u5e26\u52a8\u4e0a\u6e38\u5f00\u7968\u5931\u8d25\uff1a" + e);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5f00\u7968\u7533\u8bf7\u53d1\u8d77-\u6d88\u8d39\u8005\u62a5\u9519" + e);
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    public void updateUocBillStatus(List<Long> orderIdList, OrderStatus orderStatus) {
        UocPebUpdateBillStatusReqBO updateBillStatusReqBO = new UocPebUpdateBillStatusReqBO();
        updateBillStatusReqBO.setOrderIds(orderIdList);
        updateBillStatusReqBO.setBillState(Integer.valueOf(orderStatus.getCode()));
        this.uocPebUpdateBillStatusAbilityService.updateBillStatus(updateBillStatusReqBO);
    }

    private List<Long> queryApplyOrderIds(MakeBillApplyInfoMsgReqBO reqBO) {
        List<Long> inspectionIds = new LinkedList<Long>();
        QueryPayPurchaseOrderInfoAwaitReqBO queryReqBO = reqBO.getQueryPayPurchaseOrderInfoAwaitReqBO();
        if ("1".equals(reqBO.getIsSelectOrder()) && !CollectionUtils.isEmpty((Collection)reqBO.getInspectionIdList())) {
            for (String id : reqBO.getInspectionIdList()) {
                inspectionIds.add(Long.valueOf(id));
            }
        } else {
            SaleOrderInfoQueryVO vo = new SaleOrderInfoQueryVO();
            BeanUtils.copyProperties((Object)queryReqBO, (Object)vo);
            if (!StringUtils.isEmpty((Object)queryReqBO.getSupplierNo())) {
                vo.setSupplierNo(Long.parseLong(queryReqBO.getSupplierNo()));
            }
            if (!StringUtils.isEmpty((Object)queryReqBO.getPurchaseNo())) {
                vo.setPurchaseNo(Long.parseLong(queryReqBO.getPurchaseNo()));
            }
            if (!StringUtils.isEmpty((Object)queryReqBO.getInspectionId())) {
                vo.setInspectionId(Long.parseLong(queryReqBO.getInspectionId()));
            }
            if (!StringUtils.isEmpty((Object)queryReqBO.getPurchaserId())) {
                vo.setPurchaserId(Long.parseLong(queryReqBO.getPurchaserId()));
            }
            if (!StringUtils.isEmpty((Object)queryReqBO.getPurchaseProjectId())) {
                vo.setPurchaseProjectId(Long.valueOf(queryReqBO.getPurchaseProjectId()));
            }
            if (!StringUtils.isEmpty((Object)queryReqBO.getActivityId())) {
                vo.setActivityId(Long.parseLong(queryReqBO.getActivityId()));
            }
            Long excludeOrg = null;
            if ("0".equals(reqBO.getIsProfessionalOrgExt())) {
                vo.setOperUnitNo(reqBO.getCompanyId());
                vo.setBusiModel(BusiModel.TRADE_MODEL.getCode());
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)queryReqBO.getPurchaseNo())) {
                    vo.setPurchaseNo(Long.valueOf(queryReqBO.getPurchaseNo()));
                } else {
                    excludeOrg = reqBO.getCompanyId();
                }
                vo.setExcludeOrg(excludeOrg);
            } else if ("1".equals(reqBO.getIsProfessionalOrgExt())) {
                vo.setPurchaseNo(reqBO.getCompanyId());
                vo.setBusiModel(BusiModel.TRADE_MODEL.getCode());
            } else if ("2".equals(reqBO.getIsProfessionalOrgExt())) {
                throw new PfscExtBusinessException("0001", "\u4f9b\u5e94\u5546\u4e0d\u80fd\u53d1\u8d77\u5f00\u7968\u7533\u8bf7");
            }
            if ("1".equals(queryReqBO.getIsActivity())) {
                vo.setOrderCategory("1");
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)queryReqBO.getActivityId())) {
                    vo.setActivityId(Long.valueOf(queryReqBO.getActivityId()));
                }
            } else {
                vo.setIsNotActivity("0");
            }
            vo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
            vo.setReconciliationStatus(ReconciliationStatus.AGREEMENT.getCode());
            if ("purchaser".equals(reqBO.getSettleModel()) && !"2".equals(reqBO.getVerifyFrom())) {
                vo.setPurchaserId(reqBO.getUserId());
            }
            if ("purchaser".equals(reqBO.getSettleModel()) && "2".equals(reqBO.getVerifyFrom()) && !CollectionUtils.isEmpty((Collection)queryReqBO.getActivityIds())) {
                vo.setActivityIds(queryReqBO.getActivityIds());
            }
            inspectionIds = this.saleOrderInfoMapper.getOrderIdListByCondition(vo);
        }
        return inspectionIds;
    }
}

