/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.activity.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.activity.QueryPaySaleOrderInfoYgflService;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoItemRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoOrderRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoRspBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.service.atom.DictionaryAtomService;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.umcext.ability.account.UmcQryEnterpriseAccountListAbilityService;
import com.tydic.umcext.ability.account.bo.UmcEnterpriseAccountAbilityBO;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountListNoPageAbilityReqBO;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountListNoPageAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.activity.QueryPaySaleOrderInfoYgflService"})
public class QueryPaySaleOrderInfoYgflServiceImpl
implements QueryPaySaleOrderInfoYgflService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryPaySaleOrderInfoYgflServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private DictionaryAtomService dictionaryAtomService;
    @Autowired
    private UmcQryEnterpriseAccountListAbilityService umcQryEnterpriseAccountListAbilityService;

    @PostMapping(value={"query"})
    public BusiQuerySaleOrderInfoRspBO query(@RequestBody BusiQuerySaleOrderInfoReqBO reqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5458\u5de5\u798f\u5229\u9500\u552e\u8ba2\u5355\u5217\u8868\uff1a" + reqBO);
        }
        BusiQuerySaleOrderInfoRspBO rspBO = new BusiQuerySaleOrderInfoRspBO();
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)saleOrderInfoVO);
        saleOrderInfoVO.setOrderCategory("1");
        if (!"0".equals(reqBO.getIsProfessionalOrgExt())) {
            saleOrderInfoVO.setPurchaseNo(reqBO.getCompanyId());
        }
        saleOrderInfoVO.setOrderBy("t.ORDER_ID DESC,t.INSPECTION_ID DESC");
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListPageJoin(saleOrderInfoVO, (Page<Map<String, Object>>)page);
        if (CollectionUtils.isEmpty(saleOrderInfoList)) {
            rspBO.setReconOkCount(Integer.valueOf(0));
            rspBO.setReconFailCount(Integer.valueOf(0));
            rspBO.setReconDiffCount(Integer.valueOf(0));
            rspBO.setRows(null);
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        ArrayList<BusiQuerySaleOrderInfoOrderRspBO> orderList = new ArrayList<BusiQuerySaleOrderInfoOrderRspBO>();
        ArrayList<Long> accountIds = new ArrayList<Long>();
        ArrayList<Long> inspectionIdList = new ArrayList<Long>();
        for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
            inspectionIdList.add(saleOrderInfo.getInspectionId());
            accountIds.add(saleOrderInfo.getPurchaseProjectId());
        }
        HashMap saleItemMap = new HashMap();
        SaleItemInfoVO vo = new SaleItemInfoVO();
        vo.setInspectionIdList(new ArrayList<Long>(inspectionIdList));
        List<SaleItemInfo> saleItemInfoListResult = this.saleItemInfoMapper.getList(vo);
        if (!CollectionUtils.isEmpty(saleItemInfoListResult)) {
            for (SaleItemInfo saleItemInfo : saleItemInfoListResult) {
                if (saleItemMap.containsKey(saleItemInfo.getInspectionId())) {
                    ((List)saleItemMap.get(saleItemInfo.getInspectionId())).add(saleItemInfo);
                    continue;
                }
                ArrayList<SaleItemInfo> saleItemInfos = new ArrayList<SaleItemInfo>();
                saleItemInfos.add(saleItemInfo);
                saleItemMap.put(saleItemInfo.getInspectionId(), saleItemInfos);
            }
        }
        HashMap<Long, String> accountIdMap = new HashMap<Long, String>();
        if (accountIds.size() > 0) {
            UmcQryEnterpriseAccountListNoPageAbilityReqBO umcQryEnterpriseAccountListNoPageAbilityReqBO = new UmcQryEnterpriseAccountListNoPageAbilityReqBO();
            umcQryEnterpriseAccountListNoPageAbilityReqBO.setInAccountIds(accountIds);
            UmcQryEnterpriseAccountListNoPageAbilityRspBO rspBo = this.umcQryEnterpriseAccountListAbilityService.qryEnterpriseAccountListNoPage(umcQryEnterpriseAccountListNoPageAbilityReqBO);
            System.out.println("+++++++++++++++++++++" + rspBo);
            if (rspBo != null & rspBo.getRows() != null && rspBo.getRows().size() > 0) {
                for (UmcEnterpriseAccountAbilityBO umcEnterpriseAccountAbilityBO : rspBo.getRows()) {
                    accountIdMap.put(umcEnterpriseAccountAbilityBO.getAccountId(), umcEnterpriseAccountAbilityBO.getAccountName());
                }
            }
        }
        for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
            List saleItemInfoList = (List)saleItemMap.get(saleOrderInfo.getInspectionId());
            ArrayList<BusiQuerySaleOrderInfoItemRspBO> itemList = new ArrayList<BusiQuerySaleOrderInfoItemRspBO>();
            for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                BusiQuerySaleOrderInfoItemRspBO item = new BusiQuerySaleOrderInfoItemRspBO();
                BeanUtils.copyProperties((Object)saleItemInfo, (Object)item);
                item.setSeq(String.valueOf(saleItemInfo.getSeq()));
                item.setItemNo(String.valueOf(saleItemInfo.getItemNo()));
                item.setItemStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleItemInfo.getItemStatus())));
                itemList.add(item);
            }
            BusiQuerySaleOrderInfoOrderRspBO order = new BusiQuerySaleOrderInfoOrderRspBO();
            BeanUtils.copyProperties((Object)saleOrderInfo, (Object)order);
            order.setOrderId(String.valueOf(saleOrderInfo.getOrderId()));
            order.setInspectionId(String.valueOf(saleOrderInfo.getInspectionId()));
            order.setOrderStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleOrderInfo.getOrderStatus())));
            order.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)saleOrderInfo.getSource())));
            order.setItemInfos(itemList);
            if (accountIdMap.containsKey(saleOrderInfo.getPurchaseProjectId())) {
                order.setPurchaseProjectName((String)accountIdMap.get(saleOrderInfo.getPurchaseProjectId()));
            }
            orderList.add(order);
        }
        SaleOrderInfo saleOrderInfoSum = this.saleOrderInfoMapper.getListPageJoinSum(saleOrderInfoVO);
        if (saleOrderInfoSum != null) {
            if (saleOrderInfoSum.getOrderAmt() != null) {
                rspBO.setTotalAmt(saleOrderInfoSum.getOrderAmt());
            } else {
                rspBO.setTotalAmt(BigDecimal.ZERO);
            }
            rspBO.setOrderCount(saleOrderInfoSum.getOrderCount());
        }
        saleOrderInfoVO.setReconciliationStatus("1");
        SaleOrderInfo saleOrderInfoOK = this.saleOrderInfoMapper.getListPageJoinSum(saleOrderInfoVO);
        if (saleOrderInfoOK != null) {
            rspBO.setReconOkCount(saleOrderInfoOK.getOrderCount());
        }
        saleOrderInfoVO.setReconciliationStatus("2");
        SaleOrderInfo saleOrderInfoDiff = this.saleOrderInfoMapper.getListPageJoinSum(saleOrderInfoVO);
        if (saleOrderInfoDiff != null) {
            rspBO.setReconDiffCount(saleOrderInfoDiff.getOrderCount());
        }
        saleOrderInfoVO.setReconciliationStatus("0");
        SaleOrderInfo saleOrderInfoFail = this.saleOrderInfoMapper.getListPageJoinSum(saleOrderInfoVO);
        if (saleOrderInfoFail != null) {
            rspBO.setReconFailCount(saleOrderInfoFail.getOrderCount());
        }
        rspBO.setRows(orderList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"updateSaleOrderInfo"})
    public PfscExtRspBaseBO updateSaleOrderInfo(@RequestBody BusiQuerySaleOrderInfoReqBO reqBO) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u9500\u552e\u8ba2\u5355\u5217\u8868\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getInspectionId() == null) {
            throw new BusinessException("18000", "\u5165\u53c2\u9a8c\u6536\u5355id\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PfscExtRspBaseBO pfscExtRspBaseBO = new PfscExtRspBaseBO();
        try {
            SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
            saleOrderInfo.setInspectionId(reqBO.getInspectionId());
            saleOrderInfo.setOrderStatus(reqBO.getOrderStatus());
            this.saleOrderInfoMapper.updateByPrimaryKeySelective(saleOrderInfo);
            pfscExtRspBaseBO.setRespCode("0000");
            pfscExtRspBaseBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u6302\u8d77\u5931\u8d25", (Throwable)e);
            throw new BusinessException("18000", "\u6302\u8d77\u5931\u8d25");
        }
        return pfscExtRspBaseBO;
    }
}

