/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.aisino.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.pfscext.api.aisino.BusiApplyDriveNotiService;
import com.tydic.pfscext.api.busi.bo.BusiApplyDriveNotiReqBO;
import com.tydic.pfscext.api.busi.bo.BusiApplyDriveNotiRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQuerySaleOrderInfoReqBO;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.aisino.BusiApplyDriveNotiService"})
public class BusiApplyDriveNotiServiceImpl
implements BusiApplyDriveNotiService {
    private static final Logger log = LoggerFactory.getLogger(BusiApplyDriveNotiServiceImpl.class);
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Resource(name="fscApplyDriveNotiMsgProvider")
    private ProxyMessageProducer proxyMessageProducer;
    private final String SEND_SUCCESS = "SEND_OK";
    @Value(value="${FSC_APPLY_NOTI_TOPIC:FSC_APPLY_NOTI_TOPIC}")
    private String applyDriveNotiTopic;
    @Value(value="${FSC_APPLY_NOTI_TAG:*}")
    private String tag;

    @PostMapping(value={"applyDriveNotification"})
    public BusiApplyDriveNotiRspBO applyDriveNotification(@RequestBody BusiApplyDriveNotiReqBO reqBO) {
        log.info("\u4e0b\u6e38\u5e26\u52a8\u4e0a\u6e38\u5f00\u7968\u2014\u2014\u6d88\u606f\u751f\u4ea7\u8005\u5165\u53c2:" + JSON.toJSONString((Object)reqBO));
        List saleOrderInfoList = reqBO.getSaleOrderInfoList();
        if (reqBO == null || CollectionUtils.isEmpty((Collection)saleOrderInfoList)) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiApplyDriveNotiRspBO rspBO = new BusiApplyDriveNotiRspBO();
        ArrayList<String> orderCodeList = new ArrayList<String>();
        for (int i = 0; i < saleOrderInfoList.size(); ++i) {
            PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
            payPurchaseOrderInfo.setPurchaseOrderCode(((BusiQuerySaleOrderInfoReqBO)saleOrderInfoList.get(i)).getSaleOrderCode());
            payPurchaseOrderInfo.setSource(((BusiQuerySaleOrderInfoReqBO)saleOrderInfoList.get(i)).getSource());
            int count = this.payPurchaseOrderInfoMapper.getAvailableNotiOrder(payPurchaseOrderInfo);
            if (count != 0) continue;
            orderCodeList.add(((BusiQuerySaleOrderInfoReqBO)saleOrderInfoList.get(i)).getSaleOrderCode());
        }
        if (!CollectionUtils.isEmpty(orderCodeList)) {
            HashMap<String, BusiApplyDriveNotiReqBO> map = new HashMap<String, BusiApplyDriveNotiReqBO>();
            reqBO.setSaleOrderInfoList(null);
            reqBO.setOrderCodeList(orderCodeList);
            map.put("applyDriveNotiOrder", reqBO);
            ProxyMessage message = new ProxyMessage(this.applyDriveNotiTopic, this.tag, JSON.toJSONString(map));
            ProxySendResult sendResult = this.proxyMessageProducer.send(message);
            if (!"SEND_OK".equals(sendResult.getStatus())) {
                this.proxyMessageProducer.send(message);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

