/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom.impl;

import com.tydic.order.pec.ability.pay.UocPebUpdateBillStatusAbilityService;
import com.tydic.order.pec.bo.pay.UocPebUpdateBillStatusReqBO;
import com.tydic.pfscext.api.notify.bo.CancelApplyInfoBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.CancelApplyInfoMapper;
import com.tydic.pfscext.dao.NotificationRejectOrderInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.NotificationRejectOrderInfo;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.CancelApplyStatus;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.CancelApplyAuditAtomService;
import com.tydic.pfscext.service.atom.bo.AuditCancelInfoReqBO;
import com.tydic.pfscext.service.atom.bo.AuditCancelInfoRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CancelApplyAuditAtomServiceImpl
implements CancelApplyAuditAtomService {
    private static final Logger logger = LoggerFactory.getLogger(CancelApplyAuditAtomServiceImpl.class);
    @Resource
    CancelApplyInfoMapper cancelApplyInfoMapper;
    @Resource
    BillNotificationInfoMapper billNotificationInfoMapper;
    @Resource
    PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Resource
    PayItemInfoMapper payItemInfoMapper;
    @Resource
    BillApplyInfoMapper billApplyInfoMapper;
    @Resource
    SaleOrderInfoMapper saleOrderInfoMapper;
    @Resource
    SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private UocPebUpdateBillStatusAbilityService uocPebUpdateBillStatusAbilityService;
    @Autowired
    private NotificationRejectOrderInfoMapper notificationRejectOrderInfoMapper;

    @Override
    @Transactional
    public AuditCancelInfoRspBO auditCancelInfo(AuditCancelInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5ba1\u6838\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (StringUtils.isEmpty((Object)reqBO.getQxApplyNo())) {
            throw new PfscExtBusinessException("0001", "\u5ba1\u6838\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2-\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u53f7[qxApplyNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getUserId()) {
            throw new PfscExtBusinessException("0001", "\u5ba1\u6838\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2-\u5ba1\u6838\u4ebaID[userID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getName())) {
            throw new PfscExtBusinessException("0001", "\u5ba1\u6838\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2-\u5ba1\u6838\u4eba\u540d\u79f0[name]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getQxApplyStatus())) {
            throw new PfscExtBusinessException("0001", "\u5ba1\u6838\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2-\u72b6\u6001[qxApplyStatus]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AuditCancelInfoRspBO rspBO = new AuditCancelInfoRspBO();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("qxApplyNo", reqBO.getQxApplyNo());
        param.put("applyNo", reqBO.getApplyNo());
        CancelApplyInfoBO info = this.cancelApplyInfoMapper.selectCancelApplyInfoByCondition(param);
        if (null == info) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u8be5\u53d6\u6d88\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01\u7533\u8bf7\u5355\u53f7\uff1a" + reqBO.getQxApplyNo());
            return rspBO;
        }
        info.setAuditId(reqBO.getUserId());
        info.setAuditName(reqBO.getName());
        info.setAuditDate(new Date());
        info.setAuditDesc(reqBO.getAuditDesc());
        info.setQxApplyStatus(reqBO.getQxApplyStatus());
        int a = this.cancelApplyInfoMapper.updateCancelApplyInfo(info);
        if (a <= 0) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5ba1\u6838\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25\uff01");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5ba1\u6838\u8bb0\u5f55\u5df2\u66f4\u65b0\uff01");
        if ("1".equals(info.getQxApplyType())) {
            BillNotificationInfo updateInfo = new BillNotificationInfo();
            updateInfo.setNotificationNo(info.getApplyNo());
            if (CancelApplyStatus.PASSED.getCode().equals(info.getQxApplyStatus())) {
                updateInfo.setInvoiceStatus(NotificationInvoiceStatus.HAS_CANCEL.getCode());
                this.dealNotifiRejectInsert(info.getApplyNo());
                PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
                vo.setNotificationNo(info.getApplyNo());
                vo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
                this.payPurchaseOrderInfoMapper.updateFailResult(vo);
                PayItemInfo itemInfo = new PayItemInfo();
                itemInfo.setNotificationNo(info.getApplyNo());
                this.payItemInfoMapper.updateBackToInit(itemInfo);
                this.updateUocBillStatus(info.getApplyNo(), OrderStatus.NO_APPLY, info.getQxApplyType());
            } else if (CancelApplyStatus.REJECT.getCode().equals(info.getQxApplyStatus())) {
                updateInfo.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
            }
            this.billNotificationInfoMapper.updateByPrimaryKeySelective(updateInfo);
        } else if ("2".equals(info.getQxApplyType())) {
            BillApplyInfo billApplyInfo = new BillApplyInfo();
            billApplyInfo.setApplyNo(info.getApplyNo());
            if (CancelApplyStatus.PASSED.getCode().equals(info.getQxApplyStatus())) {
                billApplyInfo.setBillStatus(BillStatus.CANCEL_APPLY.getCode());
                SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
                saleOrderInfo.setApplyNo(info.getApplyNo());
                saleOrderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
                this.saleOrderInfoMapper.updateBillStatusToNoApply(saleOrderInfo);
                SaleItemInfo saleItemInfo = new SaleItemInfo();
                saleItemInfo.setApplyNo(info.getApplyNo());
                saleItemInfo.setItemStatus("00");
                this.saleItemInfoMapper.updateItemStatusBackToNew(saleItemInfo);
                this.updateUocBillStatus(info.getApplyNo(), OrderStatus.NO_APPLY, info.getQxApplyType());
            } else if (CancelApplyStatus.REJECT.getCode().equals(info.getQxApplyStatus())) {
                billApplyInfo.setBillStatus(BillStatus.NO_APPLY.getCode());
            }
            this.billApplyInfoMapper.updateByPrimaryKeySelective(billApplyInfo);
        }
        return rspBO;
    }

    private void updateUocBillStatus(String applyNo, OrderStatus orderStatus, String qxApplyType) {
        List<SaleOrderInfo> orderInfos;
        if ("1".equals(qxApplyType)) {
            List<PayPurchaseOrderInfo> orderInfos2 = this.payPurchaseOrderInfoMapper.selectByNotifNo(applyNo);
            if (!CollectionUtils.isEmpty(orderInfos2) && BusiModel.MATCH_UP_MODEL.getCode().equals(orderInfos2.get(0).getBusiModel())) {
                ArrayList<Long> orderIds = new ArrayList<Long>();
                for (PayPurchaseOrderInfo orderInfo : orderInfos2) {
                    orderIds.add(orderInfo.getOrderId());
                }
                UocPebUpdateBillStatusReqBO updateBillStatusReqBO = new UocPebUpdateBillStatusReqBO();
                updateBillStatusReqBO.setOrderIds(orderIds);
                updateBillStatusReqBO.setBillState(Integer.valueOf(orderStatus.getCode()));
                this.uocPebUpdateBillStatusAbilityService.updateBillStatus(updateBillStatusReqBO);
            }
        } else if ("2".equals(qxApplyType) && !CollectionUtils.isEmpty(orderInfos = this.saleOrderInfoMapper.getModelByApplyNo(applyNo))) {
            ArrayList<Long> orderIds = new ArrayList<Long>();
            for (SaleOrderInfo orderInfo : orderInfos) {
                orderIds.add(orderInfo.getOrderId());
            }
            UocPebUpdateBillStatusReqBO updateBillStatusReqBO = new UocPebUpdateBillStatusReqBO();
            updateBillStatusReqBO.setBillState(Integer.valueOf(orderStatus.getCode()));
            updateBillStatusReqBO.setOrderIds(orderIds);
            this.uocPebUpdateBillStatusAbilityService.updateBillStatus(updateBillStatusReqBO);
        }
    }

    private void dealNotifiRejectInsert(String notificationNo) {
        List<PayPurchaseOrderInfo> orders = this.payPurchaseOrderInfoMapper.selectByNotifNo(notificationNo);
        if (CollectionUtils.isEmpty(orders)) {
            throw new PfscExtBusinessException("18000", "\u901a\u77e5\u5355\u6240\u542b\u8ba2\u5355\u4e3a\u7a7a");
        }
        List<NotificationRejectOrderInfo> rejectOrderInfoList = orders.stream().map(payPurchaseOrderInfo -> {
            NotificationRejectOrderInfo rejectOrderInfo = new NotificationRejectOrderInfo();
            BeanUtils.copyProperties((Object)payPurchaseOrderInfo, (Object)rejectOrderInfo);
            rejectOrderInfo.setCreateDate(new Date());
            rejectOrderInfo.setOrderCode(payPurchaseOrderInfo.getPurchaseOrderCode());
            return rejectOrderInfo;
        }).collect(Collectors.toList());
        this.notificationRejectOrderInfoMapper.insertBatch(rejectOrderInfoList);
    }
}

