/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.atom.impl;

import com.google.common.collect.Maps;
import com.tydic.pfscext.dao.DicDictionaryMapper;
import com.tydic.pfscext.dao.bo.DicDictionaryPO;
import com.tydic.pfscext.service.atom.DictionaryAtomService;
import com.tydic.pfscext.service.atom.bo.DictionaryAtomReqBo;
import com.tydic.pfscext.service.atom.bo.DictionaryAtomRspBo;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DictionaryAtomServiceImpl
implements DictionaryAtomService {
    private final DicDictionaryMapper dicDictionaryMapper;
    private static final Integer EFFECTIVE = 0;

    public DictionaryAtomServiceImpl(DicDictionaryMapper dicDictionaryMapper) {
        this.dicDictionaryMapper = dicDictionaryMapper;
    }

    @Override
    public DictionaryAtomRspBo qryDic(DictionaryAtomReqBo reqBo) {
        DictionaryAtomRspBo retBo = new DictionaryAtomRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("180058");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        DicDictionaryPO qryPo = new DicDictionaryPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryPo);
        qryPo.setDelFlag(EFFECTIVE);
        List<DicDictionaryPO> listByCondition = this.dicDictionaryMapper.getListByCondition(qryPo);
        if (!CollectionUtils.isEmpty(listByCondition)) {
            HashMap data = Maps.newHashMapWithExpectedSize((int)listByCondition.size());
            for (DicDictionaryPO po : listByCondition) {
                if (po == null) continue;
                data.put(po.getCode(), po.getTitle());
            }
            retBo.setData(data);
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArg(DictionaryAtomReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getpCode())) {
            return "\u5165\u53c2\u5bf9\u8c61pCode\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    @Override
    public DictionaryAtomRspBo qryDicDescp(DictionaryAtomReqBo reqBo) {
        DictionaryAtomRspBo retBo = new DictionaryAtomRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("180058");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        DicDictionaryPO qryPo = new DicDictionaryPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryPo);
        qryPo.setDelFlag(EFFECTIVE);
        List<DicDictionaryPO> listByCondition = this.dicDictionaryMapper.getListByCondition(qryPo);
        if (!CollectionUtils.isEmpty(listByCondition)) {
            HashMap data = Maps.newHashMapWithExpectedSize((int)listByCondition.size());
            for (DicDictionaryPO po : listByCondition) {
                if (po == null) continue;
                data.put(po.getCode(), po.getDescrip());
            }
            retBo.setData(data);
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }
}

