/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.order.pec.ability.pay.UocPebUpdateBillStatusAbilityService;
import com.tydic.order.pec.bo.pay.UocPebUpdateBillStatusReqBO;
import com.tydic.pfscext.api.busi.BusiCancelNotificationService;
import com.tydic.pfscext.api.busi.bo.BusiCancelNotificationReqBO;
import com.tydic.pfscext.api.busi.bo.BusiCancelNotificationRspBO;
import com.tydic.pfscext.api.notify.bo.CancelApplyInfoBO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.CancelApplyInfoMapper;
import com.tydic.pfscext.dao.NotificationRejectOrderInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.CancelApplyInfo;
import com.tydic.pfscext.dao.po.NotificationRejectOrderInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.vo.PayInvoiceInfoVO;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.CancelApplyStatus;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiGetInvoiceDataService;
import com.tydic.pfscext.external.api.CancelInvoiceIntfService;
import com.tydic.pfscext.external.api.bo.BusiCancelInvoiceReqBO;
import com.tydic.pfscext.external.api.bo.BusiCancelInvoiceRspBO;
import com.tydic.pfscext.service.atom.BillSNService;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiCancelNotificationService"})
public class BusiCancelNotificationServiceImpl
implements BusiCancelNotificationService {
    private static final Logger log = LoggerFactory.getLogger(BusiCancelNotificationServiceImpl.class);
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    private BusiGetInvoiceDataService apiGetInvoiceDataService;
    @Autowired
    private UocPebUpdateBillStatusAbilityService uocPebUpdateBillStatusAbilityService;
    @Autowired
    private CancelInvoiceIntfService cancelInvoiceIntfService;
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private NotificationRejectOrderInfoMapper notificationRejectOrderInfoMapper;
    @Autowired
    private CancelApplyInfoMapper cancelApplyInfoMapper;
    private final Long SUPPLIER_NO = 100055L;
    @Value(value="${CANCEL_INVOICE_EXCEPTION}")
    private String cancelInvoiceException;

    @Autowired
    public BusiCancelNotificationServiceImpl(PayItemInfoMapper payItemInfoMapper, BillNotificationInfoMapper billNotificationInfoMapper, PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper, BusiGetInvoiceDataService apiGetInvoiceDataService, PayInvoiceInfoMapper payInvoiceInfoMapper) {
        this.payItemInfoMapper = payItemInfoMapper;
        this.billNotificationInfoMapper = billNotificationInfoMapper;
        this.payPurchaseOrderInfoMapper = payPurchaseOrderInfoMapper;
        this.apiGetInvoiceDataService = apiGetInvoiceDataService;
        this.payInvoiceInfoMapper = payInvoiceInfoMapper;
    }

    @PostMapping(value={"cancelNotification"})
    public BusiCancelNotificationRspBO cancelNotification(@RequestBody BusiCancelNotificationReqBO reqBO) {
        String notificationNo = reqBO.getNotificationNo();
        Long companyId = reqBO.getCompanyId();
        if (!StringUtils.hasText((String)notificationNo)) {
            throw new PfscExtBusinessException("0001", "\u53d6\u6d88\u5f00\u7968\u901a\u77e5\u5355\u670d\u52a1-\u5f00\u7968\u901a\u77e5\u5355\u53f7[notificationNo]\u5fc5\u987b\u8f93\u5165");
        }
        if (null == companyId) {
            throw new PfscExtBusinessException("0001", "\u53d6\u6d88\u5f00\u7968\u901a\u77e5\u5355\u670d\u52a1-\u5728\u8bf7\u6c42\u6570\u636e\u4e2d\u65e0\u6cd5\u786e\u5b9a\u4e13\u4e1a\u516c\u53f8");
        }
        BillNotificationInfo bill = this.billNotificationInfoMapper.selectByPrimaryAndCompany(notificationNo, companyId);
        if (null == bill) {
            throw new PfscExtBusinessException("0001", "\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        }
        if (NotificationInvoiceStatus.RECEIVED.getCode().equals(bill.getInvoiceStatus()) || NotificationInvoiceStatus.RETURN_BACK.getCode().equals(bill.getInvoiceStatus()) || NotificationInvoiceStatus.HAS_CANCEL.getCode().equals(bill.getInvoiceStatus()) || NotificationInvoiceStatus.CANCELING.getCode().equals(bill.getInvoiceStatus())) {
            throw new PfscExtBusinessException("0001", "\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u53d6\u6d88");
        }
        if (!StringUtils.isEmpty((Object)this.cancelInvoiceException) && this.cancelInvoiceException.contains(bill.getSupplierNo().toString())) {
            throw new PfscExtBusinessException("0001", "\u5f53\u524d\u4f9b\u5e94\u5546\u4e0d\u652f\u6301\u53d6\u6d88\u53d1\u7968");
        }
        BusiCancelNotificationRspBO rsp = new BusiCancelNotificationRspBO();
        PayInvoiceInfoVO payInvoiceInfoVO = new PayInvoiceInfoVO();
        payInvoiceInfoVO.setNotificationNo(notificationNo);
        int count = this.payInvoiceInfoMapper.selectCount(payInvoiceInfoVO);
        if (count > 0) {
            throw new PfscExtBusinessException("18000", "\u5df2\u6709\u53d1\u7968\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88");
        }
        List<PayPurchaseOrderInfo> orders = this.payPurchaseOrderInfoMapper.selectByNotifNo(notificationNo);
        if (CollectionUtils.isEmpty(orders)) {
            throw new PfscExtBusinessException("18000", "\u901a\u77e5\u5355\u6240\u542b\u8ba2\u5355\u4e3a\u7a7a");
        }
        BillNotificationInfo updBill = new BillNotificationInfo();
        updBill.setNotificationNo(notificationNo);
        updBill.setInvoiceStatus(NotificationInvoiceStatus.CANCELING.getCode());
        this.billNotificationInfoMapper.updateByPrimaryKeySelective(updBill);
        CancelApplyInfo cancelApplyInfo = new CancelApplyInfo();
        String cancleApplyNo = this.billSNService.getSnAsString(BillType.CANCLE_APPLICATION);
        cancelApplyInfo.setQxApplyNo(cancleApplyNo);
        cancelApplyInfo.setApplyNo(notificationNo);
        cancelApplyInfo.setQxApplyDate(new Date());
        cancelApplyInfo.setQxApplyId(reqBO.getUserId());
        cancelApplyInfo.setQxApplyName(reqBO.getName());
        cancelApplyInfo.setQxApplyType("1");
        cancelApplyInfo.setQxApplyStatus(CancelApplyStatus.APPLYING.getCode());
        this.cancelApplyInfoMapper.insert(cancelApplyInfo);
        boolean flag = false;
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(bill.getSource())) {
            BusiCancelInvoiceReqBO cancelInvoiceReqBO = new BusiCancelInvoiceReqBO();
            cancelInvoiceReqBO.setSupplierId(bill.getSupplierNo());
            cancelInvoiceReqBO.setMarkId(notificationNo);
            BusiCancelInvoiceRspBO busiCancelInvoiceRspBO = this.cancelInvoiceIntfService.applyInvoice(cancelInvoiceReqBO);
            if (busiCancelInvoiceRspBO == null) {
                throw new PfscExtBusinessException("18000", "\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u53d6\u6d88\u5f00\u7968\u8fd4\u56de\u53c2\u6570\u4e3a\u7a7a");
            }
            BillNotificationInfo notificationInfo = new BillNotificationInfo();
            notificationInfo.setNotificationNo(notificationNo);
            CancelApplyInfoBO cancelApplyInfoBO = new CancelApplyInfoBO();
            cancelApplyInfoBO.setQxApplyNo(cancleApplyNo);
            cancelApplyInfoBO.setResultMsg(busiCancelInvoiceRspBO.getResultMessage());
            if (this.SUPPLIER_NO.equals(bill.getSupplierNo())) {
                if (busiCancelInvoiceRspBO.getSuccess().booleanValue()) {
                    notificationInfo.setInvoiceStatus(NotificationInvoiceStatus.HAS_CANCEL.getCode());
                    cancelApplyInfoBO.setQxApplyStatus(CancelApplyStatus.PASSED.getCode());
                    flag = true;
                } else {
                    notificationInfo.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
                    cancelApplyInfoBO.setQxApplyStatus(CancelApplyStatus.REJECT.getCode());
                }
            } else if (busiCancelInvoiceRspBO.getResult().booleanValue()) {
                if (!"1".equals(busiCancelInvoiceRspBO.getNeedAudit())) {
                    notificationInfo.setInvoiceStatus(NotificationInvoiceStatus.HAS_CANCEL.getCode());
                    cancelApplyInfoBO.setQxApplyStatus(CancelApplyStatus.PASSED.getCode());
                    flag = true;
                } else {
                    notificationInfo.setInvoiceStatus(NotificationInvoiceStatus.CANCELING.getCode());
                    cancelApplyInfoBO.setQxApplyStatus(CancelApplyStatus.APPLYING.getCode());
                }
            } else {
                notificationInfo.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
                cancelApplyInfoBO.setQxApplyStatus(CancelApplyStatus.REJECT.getCode());
            }
            this.billNotificationInfoMapper.updateByPrimaryKeySelective(notificationInfo);
            this.cancelApplyInfoMapper.updateCancelApplyInfo(cancelApplyInfoBO);
        }
        if (flag) {
            LinkedList<Long> orderIdList = new LinkedList<Long>();
            LinkedList<String> orderCodeList = new LinkedList<String>();
            LinkedList<Long> inspectionIdList = new LinkedList<Long>();
            for (PayPurchaseOrderInfo order : orders) {
                orderIdList.add(order.getOrderId());
                orderCodeList.add(order.getPurchaseOrderCode());
                inspectionIdList.add(order.getInspectionId());
            }
            this.payPurchaseOrderInfoMapper.updateByReset(orderIdList, inspectionIdList);
            this.payItemInfoMapper.updateByReset(orderIdList, inspectionIdList);
            List<NotificationRejectOrderInfo> rejectOrderInfoList = orders.stream().map(payPurchaseOrderInfo -> {
                NotificationRejectOrderInfo rejectOrderInfo = new NotificationRejectOrderInfo();
                BeanUtils.copyProperties((Object)payPurchaseOrderInfo, (Object)rejectOrderInfo);
                rejectOrderInfo.setCreateDate(new Date());
                rejectOrderInfo.setOrderCode(payPurchaseOrderInfo.getPurchaseOrderCode());
                return rejectOrderInfo;
            }).collect(Collectors.toList());
            this.notificationRejectOrderInfoMapper.insertBatch(rejectOrderInfoList);
            if (BusiModel.MATCH_UP_MODEL.equals((Object)orders.get(0).getBusiModel())) {
                try {
                    UocPebUpdateBillStatusReqBO ubsreqBO = new UocPebUpdateBillStatusReqBO();
                    ubsreqBO.setOrderIds(orderIdList);
                    ubsreqBO.setBillState(Integer.valueOf(OrderStatus.NO_APPLY.getCode()));
                    log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u4fee\u6539\u72b6\u6001\u5165\u53c2\uff1a" + JSON.toJSONString((Object)ubsreqBO));
                    this.uocPebUpdateBillStatusAbilityService.updateBillStatus(ubsreqBO);
                }
                catch (Exception e) {
                    log.error("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u4fee\u6539\u72b6\u6001\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        return rsp;
    }
}

