/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiCreateOutstockInfoService;
import com.tydic.pfscext.api.busi.bo.BusiCreateOutstockInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiCreateOutstockInfoRspBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.EntryInfoMapper;
import com.tydic.pfscext.dao.OutstockDetailMapper;
import com.tydic.pfscext.dao.OutstockInfoMapper;
import com.tydic.pfscext.dao.ReceiptInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceDetailMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.StocksDetailMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.EntryInfoPO;
import com.tydic.pfscext.dao.po.OutstockDetail;
import com.tydic.pfscext.dao.po.OutstockInfo;
import com.tydic.pfscext.dao.po.ReceiptInfoPO;
import com.tydic.pfscext.dao.po.StocksDetail;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.enums.ApplyType;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.enums.OutstockInfoStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.AccountantEngineService;
import com.tydic.pfscext.service.atom.BillSNService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiCreateOutstockInfoService"})
public class BusiCreateOutstockInfoServiceImpl
implements BusiCreateOutstockInfoService {
    private static final Logger log = LoggerFactory.getLogger(BusiCreateOutstockInfoServiceImpl.class);
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private OutstockDetailMapper outstockDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private OutstockInfoMapper outstockInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private StocksDetailMapper stocksDetailMapper;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired
    private AccountantEngineService accountantEngineService;
    @Autowired
    private ReceiptInfoMapper receiptInfoMapper;
    @Autowired
    private EntryInfoMapper entryInfoMapper;

    @PostMapping(value={"addOutstockInfo"})
    public BusiCreateOutstockInfoRspBO addOutstockInfo(@RequestBody BusiCreateOutstockInfoReqBO reqBO) {
        BusiCreateOutstockInfoRspBO rspBO = new BusiCreateOutstockInfoRspBO();
        if (reqBO.getApplyNo() == null && !StringUtils.hasText((String)reqBO.getApplyNo())) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date outstockDate = new Date();
        String applyNo = reqBO.getApplyNo();
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        String source = billApplyInfo.getSource();
        String applyType = billApplyInfo.getApplyType();
        BigDecimal taxAmt = BigDecimal.ZERO;
        BigDecimal untaxAmt = BigDecimal.ZERO;
        BigDecimal amt = BigDecimal.ZERO;
        SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
        saleItemInfoVO.setApplyNo(applyNo);
        List<SaleItemInfoVO> saleItemInfoVOs = this.saleItemInfoMapper.selectVOJoinSaleItemApplyInfoA(saleItemInfoVO);
        ArrayList<SaleItemInfoVO> noAutotrophySaleItems = new ArrayList<SaleItemInfoVO>();
        ArrayList<SaleItemInfoVO> autotrophySaleItems = new ArrayList<SaleItemInfoVO>();
        for (SaleItemInfoVO saleItemInfo : saleItemInfoVOs) {
            if ("1".equals(saleItemInfo.getNoAgreeOrderCategory())) {
                autotrophySaleItems.add(saleItemInfo);
                continue;
            }
            noAutotrophySaleItems.add(saleItemInfo);
        }
        ArrayList<ArrayList<SaleItemInfoVO>> saleItems = new ArrayList<ArrayList<SaleItemInfoVO>>();
        saleItems.add(noAutotrophySaleItems);
        saleItems.add(autotrophySaleItems);
        if (autotrophySaleItems.size() > 0) {
            Date entryDate = new Date();
            String string = this.billSNService.getSnAsString(BillType.PURCHASE_STORAGE);
            for (SaleItemInfoVO saleItemInfo : autotrophySaleItems) {
                ReceiptInfoPO receiptInfoPO = new ReceiptInfoPO();
                BeanUtils.copyProperties((Object)saleItemInfo, (Object)receiptInfoPO);
                receiptInfoPO.setOrderNo(saleItemInfo.getOrderId());
                receiptInfoPO.setNotTaxAmt(saleItemInfo.getUntaxAmt());
                receiptInfoPO.setTaxPercent(saleItemInfo.getTaxRate());
                receiptInfoPO.setEntryDate(entryDate);
                receiptInfoPO.setEntryNo(string);
                this.receiptInfoMapper.insert(receiptInfoPO);
                StocksDetail stocksDetail = new StocksDetail();
                BeanUtils.copyProperties((Object)saleItemInfo, (Object)stocksDetail);
                stocksDetail.setEntryNo(string);
                stocksDetail.setRemainQuality(saleItemInfo.getQuantity());
                stocksDetail.setEntryDate(entryDate);
                stocksDetail.setSupplierNo(billApplyInfo.getSupplierNo());
                this.stocksDetailMapper.insert(stocksDetail);
            }
            EntryInfoPO entryInfoPO = new EntryInfoPO();
            entryInfoPO.setEntryDate(entryDate);
            entryInfoPO.setEntryNo(string);
            entryInfoPO.setEntryType(2);
            entryInfoPO.setNotificationNo(reqBO.getApplyNo());
            entryInfoPO.setPurchaseId(billApplyInfo.getSupplierNo());
            entryInfoPO.setNotTaxAmt(untaxAmt);
            entryInfoPO.setTax(taxAmt);
            entryInfoPO.setAmt(amt);
            entryInfoPO.setStatus("01");
            entryInfoPO.setSource(billApplyInfo.getSource());
            entryInfoPO.setOprCompanyId(billApplyInfo.getOperUnitNo());
            entryInfoPO.setWriteoffAmt(reqBO.getWriteoffAmt());
            entryInfoPO.setCreateUser(reqBO.getUserId());
            entryInfoPO.setBranchCompany(billApplyInfo.getBranchCompany());
            this.entryInfoMapper.insert(entryInfoPO);
        }
        for (List list : saleItems) {
            if (list == null || list.size() <= 0) continue;
            String outstockNo = this.billSNService.getSnAsString(BillType.STOCK_OUT);
            LinkedList<OutstockDetail> outstockDetailList = new LinkedList<OutstockDetail>();
            for (SaleItemInfoVO saleItemInfo : list) {
                String entryNo = this.billSNService.getSnAsString(BillType.PURCHASE_STORAGE);
                log.error("\u7535\u5b50\u8d85\u5e02\u662f\u6309\u5546\u54c1\u6570\u91cf\u7ef4\u5ea6\u63d0\u4ea4\u5f00\u7968\u7684");
                if (saleItemInfoVO == null) {
                    throw new PfscExtBusinessException("18000", "\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
                }
                OutstockDetail outstockDetail = new OutstockDetail();
                BeanUtils.copyProperties((Object)saleItemInfo, (Object)outstockDetail);
                outstockDetail.setSeq(saleItemInfo.getSeq());
                if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(applyType)) {
                    outstockDetail.setQuantity(saleItemInfo.getQuantityApply());
                }
                outstockDetail.setAmount(saleItemInfo.getAmount());
                outstockDetail.setUntaxAmt(saleItemInfo.getUntaxAmt());
                outstockDetail.setTaxAmt(saleItemInfo.getTaxAmt());
                outstockDetail.setOutstockNo(outstockNo);
                outstockDetail.setOutstockDate(outstockDate);
                outstockDetailList.add(outstockDetail);
                amt = amt.add(saleItemInfo.getAmount());
                untaxAmt = untaxAmt.add(saleItemInfo.getUntaxAmt());
                taxAmt = taxAmt.add(saleItemInfo.getTaxAmt());
            }
            this.outstockDetailMapper.insertBatch(outstockDetailList);
            OutstockInfo outstockInfo = new OutstockInfo();
            outstockInfo.setOutstockNo(outstockNo);
            outstockInfo.setOutstockDate(outstockDate);
            outstockInfo.setPurchaseNo(billApplyInfo.getPurchaseNo());
            outstockInfo.setPurchaseProjectId(billApplyInfo.getPurchaseProjectId());
            outstockInfo.setSource(source);
            outstockInfo.setCompanyOrg(billApplyInfo.getOperUnitNo());
            outstockInfo.setUntaxAmt(untaxAmt);
            outstockInfo.setTaxAmt(taxAmt);
            outstockInfo.setAmount(amt);
            outstockInfo.setSupplierNo(billApplyInfo.getSupplierNo());
            outstockInfo.setApplyNo(applyNo);
            outstockInfo.setStatus(OutstockInfoStatus.NO_SUM.getCode());
            outstockInfo.setBranchCompany(billApplyInfo.getBranchCompany());
            this.outstockInfoMapper.insertSelective(outstockInfo);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

