/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiExportEntryInfoService;
import com.tydic.pfscext.api.busi.bo.ExportEntryInfoBO;
import com.tydic.pfscext.api.busi.bo.ExportEntryInfoReqBO;
import com.tydic.pfscext.api.busi.bo.ExportEntryInfoRspBO;
import com.tydic.pfscext.dao.ReceiptInfoMapper;
import com.tydic.pfscext.enums.Source;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiExportEntryInfoService"})
public class BusiExportEntryInfoServiceImpl
implements BusiExportEntryInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiExportEntryInfoServiceImpl.class);
    @Resource
    private ReceiptInfoMapper receiptInfoMapper;

    @PostMapping(value={"exportEntryInfo"})
    public ExportEntryInfoRspBO exportEntryInfo(@RequestBody ExportEntryInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5165\u5e93\u5355\u5bfc\u51fa\u67e5\u8be2\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getEntryNoList())) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u9009\u62e9\u5165\u5e93\u5355\u53f7\u5bfc\u51fa\uff01");
        }
        ExportEntryInfoRspBO rspBO = new ExportEntryInfoRspBO();
        Page page = new Page(-1, -1);
        List<ExportEntryInfoBO> list = this.receiptInfoMapper.queryReceiptInfoByEntryNo(reqBO.getEntryNoList(), (Page<Map<String, Object>>)page);
        if (CollectionUtils.isEmpty(list)) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u67e5\u8be2\u65e0\u6570\u636e\uff01");
            return rspBO;
        }
        HashSet<String> supplierSet = new HashSet<String>();
        HashSet<String> contractIdSet = new HashSet<String>();
        HashSet<String> agreementIdSet = new HashSet<String>();
        HashMap<String, String> contractMap = new HashMap<String, String>();
        HashMap<String, String> agreementIdMap = new HashMap<String, String>();
        BigDecimal totalQuantity = BigDecimal.ZERO;
        BigDecimal totalPrice = BigDecimal.ZERO;
        BigDecimal totalNoTaxPrice = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalNoTaxAmt = BigDecimal.ZERO;
        BigDecimal totalTaxAmt = BigDecimal.ZERO;
        for (ExportEntryInfoBO bo : list) {
            if (Source.SPECIAL.getCode().equals(bo.getSource()) && Source.NORMAL_ELC.getCode().equals(bo.getSource())) {
                contractIdSet.add(bo.getContractId());
                contractMap.put("contractName", bo.getContractName());
                contractMap.put("enterpriseAgreeNo", bo.getEnterpriseAgreementNo());
            } else {
                agreementIdSet.add(bo.getAgreementId());
                agreementIdMap.put("agreeName", bo.getAgreementName());
                agreementIdMap.put("enterpriseAgreeNoNormal", bo.getEnterpriseAgreementNoNormal());
            }
            supplierSet.add(bo.getSupplierName());
            totalQuantity = totalQuantity.add(bo.getQuantity());
            totalPrice = totalPrice.add(bo.getSaleUnitPrice());
            totalAmount = totalAmount.add(bo.getAmount());
            totalNoTaxAmt = totalNoTaxAmt.add(bo.getNoTaxAmt());
            totalTaxAmt = totalTaxAmt.add(bo.getTaxAmt());
            BigDecimal noTaxPrice = BigDecimal.ZERO;
            if (bo.getQuantity() != null && bo.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                noTaxPrice = bo.getNoTaxAmt().divide(bo.getQuantity(), 2, 4);
            }
            totalNoTaxPrice = totalNoTaxPrice.add(noTaxPrice);
            bo.setNoTaxPrice(noTaxPrice);
        }
        if (supplierSet.size() != 1) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u8bf7\u52fe\u9009\u540c\u4e00\u4f9b\u5e94\u5546\u7684\u540c\u4e00\u5165\u9a7b\u5408\u540c/\u6846\u67b6\u534f\u8bae\u7684\u5f00\u7968\u901a\u77e5\u5355\uff01");
            return rspBO;
        }
        rspBO.setSupplierName((String)supplierSet.iterator().next());
        String source = list.get(0).getSource();
        if (Source.SPECIAL.getCode().equals(source) && Source.NORMAL_ELC.getCode().equals(source)) {
            if (agreementIdSet.size() != 0 || contractIdSet.size() != 1) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u8bf7\u52fe\u9009\u540c\u4e00\u4f9b\u5e94\u5546\u7684\u540c\u4e00\u5165\u9a7b\u5408\u540c/\u6846\u67b6\u534f\u8bae\u7684\u5f00\u7968\u901a\u77e5\u5355\uff01");
                return rspBO;
            }
            rspBO.setContractId((String)contractMap.get("enterpriseAgreeNo"));
            rspBO.setContractName((String)contractMap.get("contractName"));
        } else {
            if (contractIdSet.size() != 0 || agreementIdSet.size() != 1) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u8bf7\u52fe\u9009\u540c\u4e00\u4f9b\u5e94\u5546\u7684\u540c\u4e00\u5165\u9a7b\u5408\u540c/\u6846\u67b6\u534f\u8bae\u7684\u5f00\u7968\u901a\u77e5\u5355\uff01");
                return rspBO;
            }
            rspBO.setContractId((String)agreementIdMap.get("enterpriseAgreeNoNormal"));
            rspBO.setContractName((String)agreementIdMap.get("agreeName"));
        }
        rspBO.setTotalQuantity(totalQuantity);
        rspBO.setTotalPrice(totalPrice);
        rspBO.setTotalNoTaxPrice(totalNoTaxPrice);
        rspBO.setTotalAmount(totalAmount);
        rspBO.setTotalNoTaxAmt(totalNoTaxAmt);
        rspBO.setTotalTaxAmt(totalTaxAmt);
        rspBO.setExportDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRows(list);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5bfc\u51fa\u5185\u5bb9\u67e5\u8be2\u6210\u529f\uff01");
        logger.debug("\u5bfc\u51fa\u5185\u5bb9\u67e5\u8be2\u8fd4\u56de\u53c2\u6570-->" + JSON.toJSONString((Object)rspBO));
        return rspBO;
    }
}

