/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiExportOutStockModekService;
import com.tydic.pfscext.api.busi.bo.ExportEntryInfoBO;
import com.tydic.pfscext.api.busi.bo.ExportOutStockReqBO;
import com.tydic.pfscext.api.busi.bo.ExportOutStockRspBO;
import com.tydic.pfscext.dao.OutstockInfoMapper;
import com.tydic.pfscext.enums.Source;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiExportOutStockModekService"})
public class BusiExportOutStockModekServiceImpl
implements BusiExportOutStockModekService {
    private static final Logger logger = LoggerFactory.getLogger(BusiExportOutStockModekServiceImpl.class);
    @Resource
    private OutstockInfoMapper outstockInfoMapper;

    @PostMapping(value={"exportOutStockInfo"})
    public ExportOutStockRspBO exportOutStockInfo(@RequestBody ExportOutStockReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u51fa\u5e93\u5355\u5bfc\u51fa\u67e5\u8be2\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOutStockNoList())) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u9009\u62e9\u51fa\u5e93\u5355\u53f7\u5bfc\u51fa\uff01");
        }
        ExportOutStockRspBO rspBO = new ExportOutStockRspBO();
        Page page = new Page(-1, -1);
        List<ExportEntryInfoBO> list = this.outstockInfoMapper.queryOutStockInfoByNo(reqBO.getOutStockNoList(), (Page<Map<String, Object>>)page);
        if (CollectionUtils.isEmpty(list)) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u67e5\u8be2\u65e0\u6570\u636e\uff01");
            return rspBO;
        }
        HashSet<String> purchaseSet = new HashSet<String>();
        HashSet<String> contractSet = new HashSet<String>();
        HashSet<String> agreementNOSet = new HashSet<String>();
        BigDecimal totalQuantity = BigDecimal.ZERO;
        BigDecimal totalPrice = BigDecimal.ZERO;
        BigDecimal totalNoTaxPrice = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalNoTaxAmt = BigDecimal.ZERO;
        BigDecimal totalTaxAmt = BigDecimal.ZERO;
        for (ExportEntryInfoBO bo : list) {
            if (!StringUtils.isEmpty((Object)bo.getPurchaseName())) {
                purchaseSet.add(bo.getPurchaseName());
            }
            if (!StringUtils.isEmpty((Object)bo.getContractName())) {
                contractSet.add(bo.getContractName());
            }
            if (Source.SPECIAL.getCode().equals(bo.getSource()) && Source.NORMAL_ELC.getCode().equals(bo.getSource())) {
                if (!StringUtils.isEmpty((Object)bo.getEnterpriseAgreementNoNormal())) {
                    agreementNOSet.add(bo.getEnterpriseAgreementNoNormal());
                }
            } else if (!StringUtils.isEmpty((Object)bo.getEnterpriseAgreementNo())) {
                agreementNOSet.add(bo.getEnterpriseAgreementNo());
            }
            totalQuantity = totalQuantity.add(bo.getQuantity());
            totalPrice = totalPrice.add(bo.getSaleUnitPrice());
            totalAmount = totalAmount.add(bo.getAmount());
            totalNoTaxAmt = totalNoTaxAmt.add(bo.getNoTaxAmt());
            totalTaxAmt = totalTaxAmt.add(bo.getTaxAmt());
            BigDecimal noTaxPrice = BigDecimal.ZERO;
            if (bo.getQuantity() != null && bo.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                noTaxPrice = bo.getNoTaxAmt().divide(bo.getQuantity(), 2, 4);
            }
            totalNoTaxPrice = totalNoTaxPrice.add(noTaxPrice);
            bo.setNoTaxPrice(noTaxPrice);
        }
        if (!CollectionUtils.isEmpty(purchaseSet)) {
            String purchaseSetArr = ((Object)purchaseSet).toString();
            rspBO.setPurchaseName(purchaseSetArr.substring(1, purchaseSetArr.length() - 1));
        } else {
            rspBO.setPurchaseName("");
        }
        if (!CollectionUtils.isEmpty(contractSet)) {
            String contractSetArr = ((Object)contractSet).toString();
            rspBO.setContractName(contractSetArr.substring(1, contractSetArr.length() - 1));
        } else {
            rspBO.setContractName("");
        }
        if (!CollectionUtils.isEmpty(agreementNOSet)) {
            String agreementNOSetArr = ((Object)agreementNOSet).toString();
            rspBO.setContractId(agreementNOSetArr.substring(1, agreementNOSetArr.length() - 1));
        }
        rspBO.setContractId("");
        rspBO.setTotalQuantity(totalQuantity);
        rspBO.setTotalPrice(totalPrice);
        rspBO.setTotalNoTaxPrice(totalNoTaxPrice);
        rspBO.setTotalAmount(totalAmount);
        rspBO.setTotalNoTaxAmt(totalNoTaxAmt);
        rspBO.setTotalTaxAmt(totalTaxAmt);
        rspBO.setExportDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRows(list);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5bfc\u51fa\u5185\u5bb9\u67e5\u8be2\u6210\u529f\uff01");
        logger.debug("\u5bfc\u51fa\u5185\u5bb9\u67e5\u8be2\u8fd4\u56de\u53c2\u6570-->" + JSON.toJSONString((Object)rspBO));
        return rspBO;
    }
}

