/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.jd.open.api.sdk.internal.JSON.JSON;
import com.tydic.order.pec.ability.pay.UocPebUpdateBillStatusAbilityService;
import com.tydic.order.pec.bo.pay.UocPebUpdateBillStatusReqBO;
import com.tydic.pfscext.api.busi.bo.BusiInvoiceVerifyReqBO;
import com.tydic.pfscext.api.busi.bo.PayPurchaseOrderInfoDetailBO;
import com.tydic.pfscext.api.notify.SendInvoiceReceiptService;
import com.tydic.pfscext.api.notify.bo.FscRemindReqBO;
import com.tydic.pfscext.base.PfscExtReqBaseBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayInvoiceDetailMapper;
import com.tydic.pfscext.dao.PayInvoiceInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.PayInvoiceInfo;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.dao.vo.Statis;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.CreateEntryInfoService;
import com.tydic.pfscext.service.atom.PayableService;
import com.tydic.pfscext.service.busi.BusiInvoiceAutoSignService;
import com.tydic.pfscext.service.busi.bo.BusiInvoiceAutoSignReqBO;
import com.tydic.pfscext.service.busi.bo.BusiInvoiceAutoSignRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;

@Service
public class BusiInvoiceAutoSignServiceImpl
implements BusiInvoiceAutoSignService {
    private static final Logger log = LoggerFactory.getLogger(BusiInvoiceAutoSignServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private PayInvoiceDetailMapper payInvoiceDetailMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private SendInvoiceReceiptService sendInvoiceReceiptService;
    @Autowired
    private PayableService payableService;
    @Autowired
    private CreateEntryInfoService createEntryInfoService;
    @Autowired
    private UocPebUpdateBillStatusAbilityService uocPebUpdateBillStatusAbilityService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    private Long SUPPLIER_ID = 100055L;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;

    @Override
    public BusiInvoiceAutoSignRspBO dealNotifitionSign(final BusiInvoiceAutoSignReqBO reqBO) {
        BusiInvoiceAutoSignRspBO rspBO = new BusiInvoiceAutoSignRspBO();
        try {
            List<PayableDetailPO> payLs;
            BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(reqBO.getNotificationNo());
            if (billNotificationInfo == null) {
                rspBO.setRespCode("18001");
                rspBO.setRespDesc("\u901a\u77e5\u5355[" + reqBO.getNotificationNo() + "]\u4e0d\u5b58\u5728");
                return rspBO;
            }
            List<PayInvoiceInfo> invoices = this.payInvoiceInfoMapper.selectByNotifyNo(reqBO.getNotificationNo());
            if (invoices.size() == 0) {
                this.billNotificationInfoMapper.updateSignFailCount(reqBO.getNotificationNo());
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u672a\u627e\u5230\u901a\u77e5\u5355" + reqBO.getNotificationNo() + "\u5bf9\u5e94\u7684\u53d1\u7968");
                return rspBO;
            }
            Statis ordStatis = this.payItemInfoMapper.orderStatis(reqBO.getNotificationNo());
            log.debug("\u53d1\u7968\u81ea\u52a8\u7b7e\u6536,\u8ba2\u5355\u5546\u54c1\u7edf\u8ba1=" + ordStatis);
            Statis ivStatis = this.payInvoiceDetailMapper.invoiceStatis(reqBO.getNotificationNo());
            log.debug("\u53d1\u7968\u81ea\u52a8\u7b7e\u6536,\u53d1\u7968\u660e\u7ec6\u7edf\u8ba1=" + ivStatis);
            BigDecimal amtDif = billNotificationInfo.getAmt().subtract(ivStatis.getTotAmt());
            if (amtDif.compareTo(BigDecimal.ZERO) != 0) {
                this.billNotificationInfoMapper.updateSignFailCount(reqBO.getNotificationNo());
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u901a\u77e5\u5355\u603b\u91d1\u989d\u4e0e\u53d1\u7968\u7684\u603b\u91d1\u989d\u4e0d\u4e00\u81f4,\u76f8\u5dee " + amtDif + ",\u4e0d\u53ef\u4ee5\u7b7e\u6536");
                return rspBO;
            }
            if (ivStatis.getTotTaxAmt().add(ivStatis.getTotUntaxAmt()).compareTo(ivStatis.getTotAmt()) != 0) {
                this.billNotificationInfoMapper.updateSignFailCount(reqBO.getNotificationNo());
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u53d1\u7968\u7684\u4e0d\u542b\u7a0e\u91d1\u989d+\u7a0e\u989d\u603b\u548c\u4e0d\u7b49\u4e8e\u53d1\u7968\u91d1\u989d,\u4e0d\u53ef\u4ee5\u7b7e\u6536");
                return rspBO;
            }
            BigDecimal taxamtDif = ordStatis.getTotTaxAmt().subtract(ivStatis.getTotTaxAmt());
            BigDecimal untaxDif = ordStatis.getTotUntaxAmt().subtract(ivStatis.getTotUntaxAmt());
            if (taxamtDif.abs().compareTo(new BigDecimal("0.02")) > 0 || untaxDif.abs().compareTo(new BigDecimal("0.02")) > 0) {
                this.billNotificationInfoMapper.updateSignFailCount(reqBO.getNotificationNo());
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u53d1\u7968\u7684\u542b\u7a0e\u91d1\u989d\u6216\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0e\u901a\u77e5\u5355\u5bf9\u5e94\u91d1\u989d\u8d85\u8fc70.02\u5143,\u4e0d\u53ef\u4ee5\u7b7e\u6536");
                return rspBO;
            }
            if (!this.SUPPLIER_ID.equals(billNotificationInfo.getSupplierNo())) {
                PayInvoiceInfo invoice = invoices.get(0);
                if (!billNotificationInfo.getInvoceName().equals(invoice.getName())) {
                    this.billNotificationInfoMapper.updateSignFailCount(reqBO.getNotificationNo());
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u53d1\u7968\u62ac\u5934\u4e0d\u4e00\u81f4,\u4e0d\u53ef\u4ee5\u7b7e\u6536");
                    return rspBO;
                }
                if (!billNotificationInfo.getTaxNo().equals(invoice.getTaxNo())) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u4e00\u81f4,\u4e0d\u53ef\u4ee5\u7b7e\u6536");
                    return rspBO;
                }
                if (InvoiceType.SPECIAL.getCode().equals(billNotificationInfo.getInvoceType())) {
                    if (!billNotificationInfo.getBankAccNo().equals(invoice.getBankAcNo())) {
                        this.billNotificationInfoMapper.updateSignFailCount(reqBO.getNotificationNo());
                        rspBO.setRespCode("8888");
                        rspBO.setRespDesc("\u94f6\u884c\u8d26\u6237\u4e0d\u4e00\u81f4,\u4e0d\u53ef\u4ee5\u7b7e\u6536");
                        return rspBO;
                    }
                    if (!billNotificationInfo.getBankName().equals(invoice.getBankName())) {
                        this.billNotificationInfoMapper.updateSignFailCount(reqBO.getNotificationNo());
                        rspBO.setRespCode("8888");
                        rspBO.setRespDesc("\u5f00\u6237\u884c\u4e0d\u4e00\u81f4,\u4e0d\u53ef\u4ee5\u7b7e\u6536");
                        return rspBO;
                    }
                }
            }
            this.updateOrderStatus(reqBO.getNotificationNo());
            this.updatePayItemStatus(reqBO.getNotificationNo());
            log.debug("\u81ea\u52a8\u7b7e\u6536\u51c6\u5907\u4ea7\u751f\u5e94\u4ed8\u6b3e\u5355,\u901a\u77e5\u5355\u53f7=" + reqBO.getNotificationNo());
            String busiModel = "1";
            List<PayPurchaseOrderInfoDetailBO> payPurchaseOrderInfoDetailBOs = this.payPurchaseOrderInfoMapper.getListByNo(reqBO.getNotificationNo());
            if (payPurchaseOrderInfoDetailBOs != null && payPurchaseOrderInfoDetailBOs.size() > 0) {
                busiModel = payPurchaseOrderInfoDetailBOs.get(0).getBusiModel();
            }
            BigDecimal writeOffAmt = BigDecimal.ZERO;
            if ("1".equals(busiModel) && "03".equals(payPurchaseOrderInfoDetailBOs.get(0).getPayType()) || "0".equals(busiModel)) {
                Long companyId = billNotificationInfo.getOperNo();
                payLs = this.payableService.createPayableBill(reqBO.getNotificationNo(), companyId, "1", busiModel);
                if (payLs.size() > 0) {
                    writeOffAmt = payLs.get(0).getNeedAgainstAmt();
                }
            }
            if ("0".equals(busiModel)) {
                log.debug("\u51c6\u5907\u4ea7\u751f\u5165\u5e93\u5355\u53f7,\u901a\u77e5\u5355\u53f7=" + reqBO.getNotificationNo());
                BusiInvoiceVerifyReqBO busiInvoiceVerifyReqBO = new BusiInvoiceVerifyReqBO();
                busiInvoiceVerifyReqBO.setUserId(Long.valueOf(99999L));
                payLs = this.createEntryInfoService.createEntryInfo((PfscExtReqBaseBO)busiInvoiceVerifyReqBO, reqBO.getNotificationNo(), 2, writeOffAmt);
            }
            log.debug("\u51c6\u5907\u66f4\u65b0\u5f00\u7968\u901a\u77e5\u5355\u7684\u72b6\u6001\u4e3a\u5df2\u6536\u7968(03),\u901a\u77e5\u5355\u53f7=" + reqBO.getNotificationNo());
            BillNotificationInfo forUpdate = new BillNotificationInfo();
            forUpdate.setNotificationNo(reqBO.getNotificationNo());
            forUpdate.setInvoiceStatus(NotificationInvoiceStatus.RECEIVED.getCode());
            forUpdate.setVerifyPersonId(99999L);
            forUpdate.setVerifyPersonName("\u540e\u53f0\u81ea\u52a8\u7b7e\u6536");
            forUpdate.setSignDate(new Date());
            this.billNotificationInfoMapper.updateByPrimaryKeySelective(forUpdate);
            log.debug("\u51c6\u5907\u66f4\u65b0\u53d1\u7968\u7684\u72b6\u6001\u4e3a\u5df2\u6838\u5bf9(03),\u901a\u77e5\u5355\u53f7=" + reqBO.getNotificationNo());
            PayInvoiceInfo updInvoice = new PayInvoiceInfo();
            updInvoice.setNotificationNo(reqBO.getNotificationNo());
            updInvoice.setInvoiceStatus("03");
            this.payInvoiceInfoMapper.updateInvoiceStatus(updInvoice);
            List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(reqBO.getNotificationNo());
            ArrayList<Long> orderIds = new ArrayList<Long>();
            for (PayPurchaseOrderInfo orderInfo : payPurchaseOrderInfos) {
                orderIds.add(orderInfo.getOrderId());
            }
            UocPebUpdateBillStatusReqBO ubsreqBO = new UocPebUpdateBillStatusReqBO();
            ubsreqBO.setOrderIds(orderIds);
            ubsreqBO.setBillState(Integer.valueOf(OrderStatus.RECEIVE_BILL.getCode()));
            this.uocPebUpdateBillStatusAbilityService.updateBillStatus(ubsreqBO);
            new Thread(){

                @Override
                public void run() {
                    FscRemindReqBO fscRemindReqBO = new FscRemindReqBO();
                    fscRemindReqBO.setNotificationNo(reqBO.getNotificationNo());
                    log.debug("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3,\u53d1\u7968\u7b7e\u6536\u6210\u529f\u901a\u77e5\u670d\u52a1\u5165\u53c2: " + JSON.toString((Object)fscRemindReqBO));
                    BusiInvoiceAutoSignServiceImpl.this.sendInvoiceReceiptService.send(fscRemindReqBO);
                }
            }.start();
        }
        catch (Exception e) {
            this.updateFailCountOfException(reqBO.getNotificationNo(), "1");
            throw new PfscExtBusinessException("8888", "\u901a\u77e5\u5355" + reqBO.getNotificationNo() + "\u81ea\u52a8\u7b7e\u6536\u5f02\u5e38");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u901a\u77e5\u5355" + reqBO.getNotificationNo() + "\u81ea\u52a8\u7b7e\u6536\u6267\u884c\u6210\u529f");
        return rspBO;
    }

    @Override
    public BusiInvoiceAutoSignRspBO dealApplySign(BusiInvoiceAutoSignReqBO reqBO) {
        BusiInvoiceAutoSignRspBO rspBO = new BusiInvoiceAutoSignRspBO();
        try {
            BigDecimal amtDif;
            BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(reqBO.getApplyNo());
            if (billApplyInfo == null) {
                rspBO.setRespCode("18001");
                rspBO.setRespDesc("\u7533\u8bf7\u5355[" + reqBO.getApplyNo() + "]\u4e0d\u5b58\u5728");
                return rspBO;
            }
            List<SaleInvoiceInfo> invoices = this.saleInvoiceInfoMapper.selectByApplyNoOrderBy(reqBO.getApplyNo());
            if (CollectionUtils.isEmpty(invoices)) {
                this.billApplyInfoMapper.updateSignFailCount(reqBO.getApplyNo());
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u672a\u627e\u5230\u7533\u8bf7\u5355" + reqBO.getApplyNo() + "\u5bf9\u5e94\u7684\u53d1\u7968");
                return rspBO;
            }
            String invoiceName = invoices.get(0).getName();
            String invoiceTaxCode = invoices.get(0).getTaxNo();
            String invoiceBankName = invoices.get(0).getBankName();
            String invoiceBankAcNo = invoices.get(0).getBankAcNo();
            BigDecimal invoiceAmount = BigDecimal.ZERO;
            BigDecimal invoiceUntaxAmt = BigDecimal.ZERO;
            BigDecimal invoiceTaxAmt = BigDecimal.ZERO;
            for (SaleInvoiceInfo invoice : invoices) {
                if (invoice.getAmt() != null) {
                    invoiceAmount = invoiceAmount.add(invoice.getAmt());
                }
                if (invoice.getUntaxAmt() != null) {
                    invoiceUntaxAmt = invoiceUntaxAmt.add(invoice.getUntaxAmt());
                }
                if (invoice.getTaxAmt() == null) continue;
                invoiceTaxAmt = invoiceTaxAmt.add(invoice.getTaxAmt());
            }
            Statis ordStatis = this.saleItemInfoMapper.orderStatis(reqBO.getApplyNo());
            String billName = billApplyInfo.getInvoceName();
            String billTaxCode = billApplyInfo.getTaxNo();
            String billBankName = billApplyInfo.getBankName();
            String billBankAcNo = billApplyInfo.getBankAcctNo();
            BigDecimal billAmount = ordStatis.getTotAmt();
            BigDecimal billUntaxAmt = ordStatis.getTotUntaxAmt();
            BigDecimal billTaxAmt = ordStatis.getTotTaxAmt();
            if (!invoiceName.equals(billName)) {
                this.billApplyInfoMapper.updateSignFailCount(reqBO.getApplyNo());
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u53d1\u7968\u62ac\u5934\u4e0d\u4e00\u81f4,\u4e0d\u53ef\u4ee5\u7b7e\u6536");
                return rspBO;
            }
            if (!invoiceTaxCode.equals(billTaxCode)) {
                this.billApplyInfoMapper.updateSignFailCount(reqBO.getApplyNo());
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u4e00\u81f4,\u4e0d\u53ef\u4ee5\u7b7e\u6536");
                return rspBO;
            }
            if (InvoiceType.SPECIAL.getCode().equals(billApplyInfo.getInvoiceType())) {
                if (!invoiceBankName.equals(billBankName)) {
                    this.billApplyInfoMapper.updateSignFailCount(reqBO.getApplyNo());
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5f00\u6237\u884c\u4e0d\u4e00\u81f4,\u4e0d\u53ef\u4ee5\u7b7e\u6536");
                    return rspBO;
                }
                if (!invoiceBankAcNo.equals(billBankAcNo)) {
                    this.billApplyInfoMapper.updateSignFailCount(reqBO.getApplyNo());
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u94f6\u884c\u8d26\u6237\u4e0d\u4e00\u81f4,\u4e0d\u53ef\u4ee5\u7b7e\u6536");
                    return rspBO;
                }
            }
            if ((amtDif = billAmount.subtract(invoiceAmount)).compareTo(BigDecimal.ZERO) != 0) {
                this.billApplyInfoMapper.updateSignFailCount(reqBO.getApplyNo());
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u7533\u8bf7\u5355\u603b\u91d1\u989d\u4e0e\u53d1\u7968\u7684\u603b\u91d1\u989d\u4e0d\u4e00\u81f4,\u76f8\u5dee " + amtDif + ",\u4e0d\u53ef\u4ee5\u7b7e\u6536");
                return rspBO;
            }
            if (invoiceTaxAmt.add(invoiceUntaxAmt).compareTo(invoiceAmount) != 0) {
                this.billApplyInfoMapper.updateSignFailCount(reqBO.getApplyNo());
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u53d1\u7968\u7684\u4e0d\u542b\u7a0e\u91d1\u989d+\u7a0e\u989d\u603b\u548c\u4e0d\u7b49\u4e8e\u53d1\u7968\u91d1\u989d,\u4e0d\u53ef\u4ee5\u7b7e\u6536");
                return rspBO;
            }
            BigDecimal taxamtDif = billTaxAmt.subtract(invoiceTaxAmt);
            BigDecimal untaxDif = billUntaxAmt.subtract(invoiceUntaxAmt);
            if (taxamtDif.abs().compareTo(new BigDecimal("0.02")) > 0 || untaxDif.abs().compareTo(new BigDecimal("0.02")) > 0) {
                this.billApplyInfoMapper.updateSignFailCount(reqBO.getApplyNo());
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u53d1\u7968\u7684\u542b\u7a0e\u91d1\u989d\u6216\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0e\u901a\u77e5\u5355\u5bf9\u5e94\u91d1\u989d\u8d85\u8fc70.02\u5143,\u4e0d\u53ef\u4ee5\u7b7e\u6536");
                return rspBO;
            }
            this.updateSaleOrderStatus(reqBO.getApplyNo());
            this.updateUocBillStatus(reqBO.getApplyNo(), OrderStatus.RECEIVE_BILL);
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setApplyNo(reqBO.getApplyNo());
            List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getList(saleOrderInfoVO);
            if (saleOrderInfos != null && saleOrderInfos.get(0) != null && saleOrderInfos.get(0).getOrderCategory() != null && "1".equals(saleOrderInfos.get(0).getOrderCategory())) {
                log.debug("\u51c6\u5907\u4ea7\u751f\u5e94\u4ed8\u6b3e\u5355\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + reqBO.getApplyNo());
                String companyName = billApplyInfo.getPurchaseName();
                String busiModel = saleOrderInfos.get(0).getBusiModel();
                List<PayableDetailPO> list = this.payableService.createApplyPayableBill(reqBO.getApplyNo(), billApplyInfo.getPurchaseNo(), companyName, busiModel, null);
            }
            log.debug("\u51c6\u5907\u66f4\u65b0\u5f00\u7968\u7533\u8bf7\u5355\u7684\u72b6\u6001\u4e3a\u5df2\u6536\u7968(03),\u901a\u77e5\u5355\u53f7=" + reqBO.getApplyNo());
            BillApplyInfo forUpdate = new BillApplyInfo();
            forUpdate.setApplyNo(reqBO.getApplyNo());
            forUpdate.setBillStatus(BillStatus.SIGNED_IN.getCode());
            forUpdate.setSignDate(new Date());
            forUpdate.setVerifyPersonId(99999L);
            forUpdate.setVerifyPersonName("\u540e\u53f0\u81ea\u52a8\u7b7e\u6536");
            this.billApplyInfoMapper.updateByPrimaryKeySelective(forUpdate);
        }
        catch (Exception e) {
            this.updateFailCountOfException(reqBO.getApplyNo(), "2");
            throw new PfscExtBusinessException("8888", "\u7533\u8bf7\u5355" + reqBO.getApplyNo() + "\u81ea\u52a8\u7b7e\u6536\u5f02\u5e38");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u7533\u8bf7\u5355" + reqBO.getApplyNo() + "\u81ea\u52a8\u7b7e\u6536\u6267\u884c\u6210\u529f");
        return rspBO;
    }

    private void updateOrderStatus(String notificationNO) {
        PayPurchaseOrderInfo payOrderUpd = new PayPurchaseOrderInfo();
        payOrderUpd.setNotificationNo(notificationNO);
        payOrderUpd.setOrderStatus(OrderStatus.RECEIVE_BILL.getCode());
        int cnt = this.payPurchaseOrderInfoMapper.updateStatus(payOrderUpd);
        log.debug("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u6536\u7968(03),\u5f00\u7968\u901a\u77e5\u5355\u53f7=" + notificationNO + ",\u6570\u91cf=" + cnt);
    }

    private void updatePayItemStatus(String notificationNo) {
        PayItemInfo payItemInfo = new PayItemInfo();
        payItemInfo.setNotificationNo(notificationNo);
        payItemInfo.setItemStatus(OrderStatus.RECEIVE_BILL.getCode());
        this.payItemInfoMapper.updateByPrimaryKeySelective(payItemInfo);
    }

    public void updateUocBillStatus(String applyNo, OrderStatus orderStatus) {
        List<SaleOrderInfo> orderInfos = this.saleOrderInfoMapper.getModelByApplyNo(applyNo);
        if (!CollectionUtils.isEmpty(orderInfos)) {
            ArrayList<Long> orderIds = new ArrayList<Long>();
            for (SaleOrderInfo orderInfo : orderInfos) {
                orderIds.add(orderInfo.getOrderId());
            }
            UocPebUpdateBillStatusReqBO updateBillStatusReqBO = new UocPebUpdateBillStatusReqBO();
            updateBillStatusReqBO.setOrderIds(orderIds);
            updateBillStatusReqBO.setBillState(Integer.valueOf(orderStatus.getCode()));
            this.uocPebUpdateBillStatusAbilityService.updateBillStatus(updateBillStatusReqBO);
        }
    }

    private void updateSaleOrderStatus(String applyNo) {
        SaleOrderInfo payOrderUpd = new SaleOrderInfo();
        payOrderUpd.setApplyNo(applyNo);
        payOrderUpd.setOrderStatus(OrderStatus.RECEIVE_BILL.getCode());
        int cnt = this.saleOrderInfoMapper.updateByApplyNo(payOrderUpd);
    }

    private void updateFailCountOfException(String applyNo, String type) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            if ("1".equals(type)) {
                this.billNotificationInfoMapper.updateSignFailCount(applyNo);
            } else {
                this.billApplyInfoMapper.updateSignFailCount(applyNo);
            }
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }
}

