/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiQryNotifyOrderInfoListService;
import com.tydic.pfscext.api.busi.bo.BusiQryNotifyOrderInfoListReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQryNotifyOrderInfoListRspBO;
import com.tydic.pfscext.api.busi.bo.NotifyOrderInfoBO;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiQryNotifyOrderInfoListService"})
public class BusiQryNotifyOrderInfoListServiceImpl
implements BusiQryNotifyOrderInfoListService {
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private EnumsService enumsService;

    @PostMapping(value={"queryNotifyOrderList"})
    public BusiQryNotifyOrderInfoListRspBO queryNotifyOrderList(@RequestBody BusiQryNotifyOrderInfoListReqBO reqBO) {
        BusiQryNotifyOrderInfoListRspBO rspBO = new BusiQryNotifyOrderInfoListRspBO();
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u4e0a\u6e38\u5f00\u7968\u4fe1\u606f\u67e5\u8be2\u670d\u52a1\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getApplyNo())) {
            throw new PfscExtBusinessException("0001", "\u4e0a\u6e38\u5f00\u7968\u4fe1\u606f\u67e5\u8be2\u670d\u52a1\u5165\u53c2\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Page page = new Page(reqBO.getPageNo() < 1 ? 1 : reqBO.getPageNo(), reqBO.getPageSize() < 1 ? 10 : reqBO.getPageSize());
        List<NotifyOrderInfoBO> notifyOrderInfoBOS = this.saleOrderInfoMapper.getNotifyOrderListByApplyNo(reqBO.getApplyNo(), (Page<Map<String, Object>>)page);
        if (!CollectionUtils.isEmpty(notifyOrderInfoBOS)) {
            for (NotifyOrderInfoBO notifyOrderInfoBO : notifyOrderInfoBOS) {
                if (StringUtils.isEmpty((CharSequence)notifyOrderInfoBO.getNotificationNo())) continue;
                NotificationInvoiceStatus notifInvoiceEnum = NotificationInvoiceStatus.getInstance(notifyOrderInfoBO.getNotificationStatus());
                notifyOrderInfoBO.setNotificationStatusStr(this.enumsService.getDescr(notifInvoiceEnum));
            }
        }
        rspBO.setRows(notifyOrderInfoBOS);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

