/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.contract.api.order.service.QryContractOrderInfoService;
import com.tydic.order.pec.ability.other.UocQueryEntAgreementCodeByOrderIdListAbilityService;
import com.tydic.order.pec.bo.other.EntAgreementCodeBO;
import com.tydic.order.pec.bo.other.QueryEntAgreementCodeByOrderIdListReqBO;
import com.tydic.order.pec.bo.other.QueryEntAgreementCodeByOrderIdListRspBO;
import com.tydic.pfscext.api.busi.BusiQryOutstockDetailListByOutstockNoService;
import com.tydic.pfscext.api.busi.bo.BusiQryOutstockDetailListByOutstockNoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQryOutstockDetailListByOutstockNoRspBO;
import com.tydic.pfscext.api.busi.vo.QryOutstockDetailByNoVO;
import com.tydic.pfscext.dao.OutstockDetailMapper;
import com.tydic.pfscext.dao.OutstockInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.OutstockDetail;
import com.tydic.pfscext.dao.po.OutstockInfo;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.umc.ability.bo.UmcQryOrgNameBySupplierIdOrOrgIdServiceReqBO;
import com.tydic.umc.ability.bo.UmcQryOrgNameBySupplierIdOrOrgIdServiceRspBO;
import com.tydic.umc.ability.org.UmcQryOrgNameBySupplierIdOrOrgIdAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiQryOutstockDetailListByOutstockNoService"})
public class BusiQryOutstockDetailListByOutstockNoServiceImpl
implements BusiQryOutstockDetailListByOutstockNoService {
    private static final Logger log = LoggerFactory.getLogger(BusiQryOutstockDetailListByOutstockNoServiceImpl.class);
    @Autowired
    private OutstockDetailMapper outstockDetailMapper;
    @Autowired
    private OutstockInfoMapper outstockInfoMapper;
    @Autowired
    private QryContractOrderInfoService qryContractOrderInfoService;
    @Autowired
    private UmcQryOrgNameBySupplierIdOrOrgIdAbilityService umcQryOrgNameService;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private UocQueryEntAgreementCodeByOrderIdListAbilityService uocQueryEntAgreementCodeService;

    @PostMapping(value={"qryOutstockDetailListByOutstockNo"})
    public BusiQryOutstockDetailListByOutstockNoRspBO qryOutstockDetailListByOutstockNo(@RequestBody BusiQryOutstockDetailListByOutstockNoReqBO reqBO) {
        if (reqBO.getOutstockNo() == null) {
            throw new PfscExtBusinessException("\u5931\u8d25", "\u51fa\u5e93\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BusiQryOutstockDetailListByOutstockNoRspBO rspBO = new BusiQryOutstockDetailListByOutstockNoRspBO();
        OutstockInfo outstockInfo = this.outstockInfoMapper.selectByPrimaryKey(reqBO.getOutstockNo());
        if (outstockInfo != null) {
            BeanUtils.copyProperties((Object)outstockInfo, (Object)rspBO);
            UmcQryOrgNameBySupplierIdOrOrgIdServiceReqBO orgIdServiceReqBO = new UmcQryOrgNameBySupplierIdOrOrgIdServiceReqBO();
            orgIdServiceReqBO.setId(outstockInfo.getPurchaseNo());
            UmcQryOrgNameBySupplierIdOrOrgIdServiceRspBO orOrgIdServiceRspBO = this.umcQryOrgNameService.qryOrgNameBySupplierIdOrOrgId(orgIdServiceReqBO);
            if (orOrgIdServiceRspBO != null) {
                rspBO.setPurchaseName(orOrgIdServiceRspBO.getName());
            }
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        OutstockDetail outstockDetail = new OutstockDetail();
        outstockDetail.setOutstockNo(reqBO.getOutstockNo());
        List<OutstockDetail> outstockDetails = null;
        List<Object> rtList = new ArrayList();
        try {
            outstockDetails = this.outstockDetailMapper.getListPage(outstockDetail, (Page<Map<String, Object>>)page, "t.outstock_date");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PfscExtBusinessException("\u5931\u8d25", e.getMessage());
        }
        List<PayItemInfo> listByOutStockNo = this.payItemInfoMapper.getListByOutStockNo(reqBO.getOutstockNo());
        Map<Object, Object> map = new HashMap();
        BigDecimal totalPurchaseAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(listByOutStockNo)) {
            map = listByOutStockNo.stream().collect(Collectors.toMap(PayItemInfo::getItemNo, PayItemInfo::getAmount, (key1, key2) -> key2));
            for (PayItemInfo payItemInfo : listByOutStockNo) {
                totalPurchaseAmount = totalPurchaseAmount.add(payItemInfo.getAmount());
            }
            rspBO.setTotalPurchaseAmount(totalPurchaseAmount);
        } else {
            log.error("\u672a\u67e5\u5230\u76f8\u5173\u660e\u7ec6\u8fdb\u4ef7");
        }
        HashMap itemNoAndAmountMap = map;
        if (!CollectionUtils.isEmpty(outstockDetails)) {
            rtList = outstockDetails.stream().map(detail -> {
                QryOutstockDetailByNoVO stockDetailListBO = new QryOutstockDetailByNoVO();
                BeanUtils.copyProperties((Object)detail, (Object)stockDetailListBO);
                stockDetailListBO.setPurchaseAmount((BigDecimal)itemNoAndAmountMap.get(detail.getItemNo()));
                return stockDetailListBO;
            }).collect(Collectors.toList());
        }
        List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getModelByApplyNo(outstockInfo.getApplyNo());
        ArrayList orderIds = new ArrayList();
        saleOrderInfos.stream().forEach(saleOrderInfo -> orderIds.add(saleOrderInfo.getOrderId()));
        QueryEntAgreementCodeByOrderIdListReqBO entAgreementCodeReqBO = new QueryEntAgreementCodeByOrderIdListReqBO();
        entAgreementCodeReqBO.setOrderIdList(orderIds);
        log.info("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u4f01\u4e1a\u534f\u8bae\u7f16\u7801\u5165\u53c2" + JSON.toJSONString((Object)entAgreementCodeReqBO));
        QueryEntAgreementCodeByOrderIdListRspBO queryEntAgreementCodeByOrderIdListRspBO = this.uocQueryEntAgreementCodeService.QueryEntAgreementCodeByOrderIdList(entAgreementCodeReqBO);
        log.info("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u4f01\u4e1a\u534f\u8bae\u7f16\u7801\u51fa\u53c2" + JSON.toJSONString((Object)queryEntAgreementCodeByOrderIdListRspBO));
        StringBuffer entAgreementCodeStr = new StringBuffer();
        if (queryEntAgreementCodeByOrderIdListRspBO != null) {
            List entAgreementCodeBOS = queryEntAgreementCodeByOrderIdListRspBO.getEntAgreementCodeBOS();
            HashSet<String> hashSet = new HashSet<String>();
            if (!CollectionUtils.isEmpty((Collection)entAgreementCodeBOS)) {
                for (EntAgreementCodeBO entAgreementCodeBO : entAgreementCodeBOS) {
                    hashSet.add(entAgreementCodeBO.getEntAgreementCode());
                }
                List codeList = hashSet.stream().collect(Collectors.toList());
                entAgreementCodeStr.append((String)codeList.get(0));
                codeList.remove(0);
                for (String code : codeList) {
                    entAgreementCodeStr.append("," + code);
                }
            }
        }
        rspBO.setEntAgreementCode(entAgreementCodeStr.toString());
        rspBO.setRows(rtList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

