/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.BusiQueryOutstockTotalDetailService;
import com.tydic.pfscext.api.busi.bo.BusiQueryOutstockTotalDetailReqBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryOutstockTotalDetailRspBO;
import com.tydic.pfscext.api.busi.bo.BusiQueryOutstockTotalDetailShowRspBO;
import com.tydic.pfscext.api.busi.bo.SaleOrderDetailInfoRspBO;
import com.tydic.pfscext.dao.OutstockDetailMapper;
import com.tydic.pfscext.dao.OutstockInfoMapper;
import com.tydic.pfscext.dao.OutstockTotalMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.StocksDetailMapper;
import com.tydic.pfscext.dao.po.OutstockDetail;
import com.tydic.pfscext.dao.po.OutstockInfo;
import com.tydic.pfscext.dao.po.OutstockTotal;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.po.StocksDetail;
import com.tydic.pfscext.dao.vo.QueryOutstockInfoVO;
import com.tydic.pfscext.dao.vo.SaleOrderInfoVO;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.atom.UserInfoService;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiQueryOutstockTotalDetailService"})
public class BusiQueryOutstockTotalDetailServiceImpl
implements BusiQueryOutstockTotalDetailService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryOutstockTotalDetailServiceImpl.class);
    private final OutstockTotalMapper outstockTotalMapper;
    private final OutstockInfoMapper outstockInfoMapper;
    private final OrganizationInfoService organizationInfoService;
    private final UserInfoService userInfoService;
    private final OutstockDetailMapper outstockDetailMapper;
    private final StocksDetailMapper stocksDetailMapper;
    private final SaleOrderInfoMapper saleOrderInfoMapper;
    private final EnumsService enumsService;

    public BusiQueryOutstockTotalDetailServiceImpl(OutstockTotalMapper outstockTotalMapper, OutstockInfoMapper outstockInfoMapper, OrganizationInfoService organizationInfoService, UserInfoService userInfoService, OutstockDetailMapper outstockDetailMapper, StocksDetailMapper stocksDetailMapper, SaleOrderInfoMapper saleOrderInfoMapper, EnumsService enumsService) {
        this.outstockTotalMapper = outstockTotalMapper;
        this.outstockInfoMapper = outstockInfoMapper;
        this.organizationInfoService = organizationInfoService;
        this.userInfoService = userInfoService;
        this.outstockDetailMapper = outstockDetailMapper;
        this.stocksDetailMapper = stocksDetailMapper;
        this.saleOrderInfoMapper = saleOrderInfoMapper;
        this.enumsService = enumsService;
    }

    @PostMapping(value={"queryListPage"})
    public BusiQueryOutstockTotalDetailRspBO queryListPage(@RequestBody BusiQueryOutstockTotalDetailReqBO reqBO) {
        if (!StringUtils.hasText((String)reqBO.getTotalNo())) {
            throw new PfscExtBusinessException("0001", "\u6c47\u603b\u5355\u53f7[totalNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiQueryOutstockTotalDetailRspBO rspBO = new BusiQueryOutstockTotalDetailRspBO();
        OutstockTotal outstockTotal = this.outstockTotalMapper.selectByPrimaryKey(reqBO.getTotalNo());
        if (outstockTotal == null) {
            logger.info("\u6839\u636e\u6c47\u603b\u5355\u53f7\uff1a" + reqBO.getTotalNo() + "\u67e5\u8be2\u6c47\u603b\u5355\u4fe1\u606f\u4e3a\u7a7a");
            throw new PfscExtBusinessException("18000", "\u6839\u636e\u6c47\u603b\u5355\u53f7\uff1a" + reqBO.getTotalNo() + "\u67e5\u8be2\u6c47\u603b\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        BeanUtils.copyProperties((Object)outstockTotal, (Object)rspBO);
        rspBO.setCompanyName(this.organizationInfoService.queryOrgName(outstockTotal.getOrgId()));
        rspBO.setUserName(this.userInfoService.queryUserNameByUserId(outstockTotal.getUserId()));
        rspBO.setSumAmt(outstockTotal.getUntaxAmt().add(outstockTotal.getTaxAmt()));
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<OutstockInfo> list = this.outstockInfoMapper.selectByConditions(reqBO.getTotalNo(), (Page<Map<String, Object>>)page);
        LinkedList<BusiQueryOutstockTotalDetailShowRspBO> showRspBOList = new LinkedList<BusiQueryOutstockTotalDetailShowRspBO>();
        for (OutstockInfo outstockInfo : list) {
            BigDecimal sum = BigDecimal.ZERO;
            HashSet<Long> seqSet = new HashSet<Long>();
            BusiQueryOutstockTotalDetailShowRspBO showRspBO = new BusiQueryOutstockTotalDetailShowRspBO();
            BeanUtils.copyProperties((Object)outstockInfo, (Object)showRspBO);
            showRspBO.setPurchaseName(this.organizationInfoService.queryOrgName(outstockInfo.getPurchaseNo()));
            List<OutstockDetail> list1 = this.outstockDetailMapper.selectByCondition(outstockInfo.getOutstockNo());
            for (OutstockDetail outstockDetail : list1) {
                StocksDetail stocksDetail = this.stocksDetailMapper.selectByConditions(outstockDetail.getInspectionId(), outstockDetail.getPurchaseItemNo());
                if (stocksDetail == null || stocksDetail.getUntaxAmt() == null || seqSet.contains(stocksDetail.getSeq())) continue;
                sum = sum.add(stocksDetail.getUntaxAmt());
                seqSet.add(stocksDetail.getSeq());
            }
            LinkedList<SaleOrderDetailInfoRspBO> saleOrderDetailList = new LinkedList<SaleOrderDetailInfoRspBO>();
            if (!"0".equals(this.enumsService.queryShowOrderCodeSwitch()) || !OrderSource.ELECTRIC_MARKET.getCode().equals(outstockInfo.getSource())) {
                QueryOutstockInfoVO outstockVO = new QueryOutstockInfoVO();
                outstockVO.setOutstockNo(outstockInfo.getOutstockNo());
                List<Long> inspectionIds = this.outstockInfoMapper.selectInspectionIdsByCondition(outstockVO);
                if (!CollectionUtils.isEmpty(inspectionIds)) {
                    SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
                    saleOrderInfoVO.setInspectionIdList(inspectionIds);
                    List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getList(saleOrderInfoVO);
                    for (SaleOrderInfo orderInfo : saleOrderInfoList) {
                        SaleOrderDetailInfoRspBO detailRspBO = new SaleOrderDetailInfoRspBO();
                        detailRspBO.setInspectionId(orderInfo.getInspectionId());
                        detailRspBO.setSaleOrderCode(orderInfo.getSaleOrderCode());
                        detailRspBO.setSaleOrderName(orderInfo.getSaleOrderName());
                        saleOrderDetailList.add(detailRspBO);
                    }
                }
            }
            showRspBO.setSaleOrderDetailList(saleOrderDetailList);
            showRspBO.setAmt(sum);
            showRspBOList.add(showRspBO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6c47\u603b\u5355\u8be6\u60c5\u6210\u529f");
        rspBO.setRows(showRspBOList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

