/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.pfscext.api.busi.BusiSaleInvoiceInfoService;
import com.tydic.pfscext.api.busi.bo.BusiSaleInvoiceInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiSaleInvoiceInfoRspBO;
import com.tydic.pfscext.api.busi.vo.SaleItemInfoExportVO;
import com.tydic.pfscext.api.deal.bo.SaleInvoiceInfoExportBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceDetailMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.SaleInvoiceDetail;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.InvoiceMethod;
import com.tydic.pfscext.enums.PushStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiSaleInvoiceInfoService"})
public class BusiSaleInvoiceInfoServiceImpl
implements BusiSaleInvoiceInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiSaleInvoiceInfoServiceImpl.class);
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    SaleItemInfoMapper saleItemInfoMapper;

    @Transactional
    @PostMapping(value={"dealManualInvoice"})
    public BusiSaleInvoiceInfoRspBO dealManualInvoice(@RequestBody BusiSaleInvoiceInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u624b\u52a8\u5f00\u7968\u5165\u53c2\uff1a" + reqBO.toString());
        }
        BusiSaleInvoiceInfoRspBO rspBO = new BusiSaleInvoiceInfoRspBO();
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(reqBO.getApplyNo());
        String billStatus = billApplyInfo.getBillStatus();
        if (null != billStatus && BillStatus.SIGNED_IN.getCode().equals(billStatus)) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u7684\u53d1\u7968\u5df2\u6536\u7968,\u4e0d\u5141\u8bb8\u518d\u5904\u7406");
            return rspBO;
        }
        String pushStatus = billApplyInfo.getPushStatus();
        if (BillStatus.NO_APPLY.getCode().equals(billStatus)) {
            if (!PushStatus.NOT_PUSH.getCode().equals(pushStatus) && !PushStatus.PUSH_FAIL.getCode().equals(pushStatus)) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u7684\u63a8\u9001\u72b6\u6001\u4e3a" + PushStatus.getInstance(pushStatus).getCodeDescr() + ",\u4e0d\u5141\u8bb8\u5904\u7406");
                return rspBO;
            }
        } else if (BillStatus.SEND_BILL.getCode().equals(billStatus)) {
            if (pushStatus != null) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u7684\u63a8\u9001\u72b6\u6001\u4e3aNULL,\u4e0d\u5141\u8bb8\u5904\u7406");
                return rspBO;
            }
        } else {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u72b6\u6001\u4e0d\u5141\u8bb8\u624b\u52a8\u5f00\u7968\uff0cBillStatus\uff1a" + billStatus);
            return rspBO;
        }
        List saleInvoiceList = reqBO.getSaleInvoiceList();
        logger.debug("---\u5bfc\u5165\u53d1\u7968\u6570\u636e,\u9700\u5bfc\u5165\u7684\u53d1\u7968\u6570\u91cf:" + saleInvoiceList.size());
        for (SaleInvoiceInfoExportBO exportBO : saleInvoiceList) {
            SaleInvoiceInfo selectByPrimaryKey = this.saleInvoiceInfoMapper.selectByPrimaryKey(exportBO.getInvoiceNo());
            if (null == selectByPrimaryKey || exportBO.getApplyNo() == selectByPrimaryKey.getApplyNo()) continue;
            rspBO.setRespDesc("\u53d1\u7968\u53f7:" + selectByPrimaryKey.getInvoiceNo() + ",\u53d1\u7968\u4ee3\u7801:" + selectByPrimaryKey.getInvoiceCode() + ",\u5f00\u7968\u65e5\u671f:" + DateUtils.dateToStr((Date)selectByPrimaryKey.getInvoiceDate()) + " \u7684\u53d1\u7968\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff0c\u8be5\u53d1\u7968\u7533\u8bf7\u5355\u53f7:" + selectByPrimaryKey.getApplyNo());
            rspBO.setRespCode("18000");
            return rspBO;
        }
        List<SaleItemInfoExportVO> itemInfoList = this.saleItemInfoMapper.getSaleItemInfoByApplyNo(reqBO.getApplyNo());
        if (saleInvoiceList.size() != itemInfoList.size()) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u4e0a\u4f20\u7684\u5f00\u7968\u660e\u7ec6\u4e0e\u4e0b\u8f7d\u7684\u6a21\u677f\u4e0d\u5bf9\u7b49\uff01");
            return rspBO;
        }
        HashMap<String, SaleInvoiceInfo> saleInvoiceInfoMap = new HashMap<String, SaleInvoiceInfo>();
        HashSet<SaleInvoiceDetail> saleInvoiceDetailSet = new HashSet<SaleInvoiceDetail>();
        for (Object exportBO : saleInvoiceList) {
            logger.debug("\u5f00\u7968\u660e\u7ec6ApplyNo:" + exportBO.getApplyNo() + " InvoiceNo:" + exportBO.getInvoiceNo() + " InvoiceCode:" + exportBO.getInvoiceCode());
            if (saleInvoiceInfoMap.containsKey(exportBO.getInvoiceNo())) {
                SaleInvoiceInfo tempSaleInfo = (SaleInvoiceInfo)saleInvoiceInfoMap.get(exportBO.getInvoiceNo());
                tempSaleInfo.setAmt(tempSaleInfo.getAmt().add(exportBO.getAmount()));
                tempSaleInfo.setUntaxAmt(tempSaleInfo.getUntaxAmt().add(exportBO.getUnTaxAmt()));
                tempSaleInfo.setTaxAmt(tempSaleInfo.getTaxAmt().add(exportBO.getTaxAmt()));
                saleInvoiceInfoMap.put(tempSaleInfo.getInvoiceNo(), tempSaleInfo);
            } else {
                SaleInvoiceInfo saleInvoiceInfo = new SaleInvoiceInfo();
                BeanUtils.copyProperties((Object)exportBO, (Object)saleInvoiceInfo);
                if (null != billApplyInfo.getInvoiceType()) {
                    saleInvoiceInfo.setInvoiceType(Integer.valueOf(billApplyInfo.getInvoiceType()));
                }
                saleInvoiceInfo.setAddress(reqBO.getAddr());
                saleInvoiceInfo.setBankName(reqBO.getBankName());
                saleInvoiceInfo.setBankAcNo(reqBO.getBankAcctNo());
                saleInvoiceInfo.setPhone(reqBO.getPhone());
                saleInvoiceInfo.setTaxNo(reqBO.getTaxNo());
                saleInvoiceInfo.setName(reqBO.getName());
                saleInvoiceInfo.setElectronicInvoiceUrl(reqBO.getElectronicInvoiceUrl());
                saleInvoiceInfo.setElectronicInvoiceName(reqBO.getElectronicInvoiceName());
                saleInvoiceInfo.setAmt(exportBO.getAmount());
                saleInvoiceInfo.setUntaxAmt(exportBO.getUnTaxAmt());
                saleInvoiceInfo.setTaxAmt(exportBO.getTaxAmt());
                saleInvoiceInfo.setInvoiceStatus("1");
                saleInvoiceInfoMap.put(saleInvoiceInfo.getInvoiceNo(), saleInvoiceInfo);
            }
            SaleInvoiceDetail detail = null;
            Boolean isMatch = false;
            for (SaleItemInfoExportVO vo : itemInfoList) {
                if (!exportBO.getApplyNo().equals(vo.getApplyNo()) || !(vo.getItemNo() + "-" + vo.getSeq()).equals(exportBO.getIdentify())) continue;
                isMatch = true;
                if (!exportBO.getPurchaseOrderId().equals(String.valueOf(vo.getPurchaseOrderId()))) {
                    rspBO.setRespCode("18000");
                    rspBO.setRespDesc("\u4e0a\u4f20\u7684\u5f00\u7968\u660e\u7ec6\u4e2d\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7\u88ab\u4fee\u6539\uff01");
                    return rspBO;
                }
                if (!vo.getSkuName().equals(exportBO.getSkuName())) {
                    rspBO.setRespCode("18000");
                    rspBO.setRespDesc("\u4e0a\u4f20\u7684\u5f00\u7968\u660e\u7ec6\u4e2d\u7269\u8d44\u540d\u79f0\u88ab\u4fee\u6539\uff01");
                    return rspBO;
                }
                if (!exportBO.getSkuId().equals(String.valueOf(vo.getSkuId()))) {
                    rspBO.setRespCode("18000");
                    rspBO.setRespDesc("\u4e0a\u4f20\u7684\u5f00\u7968\u660e\u7ec6\u4e2d\u5546\u54c1\u7f16\u7801\u88ab\u4fee\u6539\uff01");
                    return rspBO;
                }
                detail = new SaleInvoiceDetail();
                BeanUtils.copyProperties((Object)exportBO, (Object)detail);
                detail.setInvoiceNo(exportBO.getInvoiceNo());
                detail.setTaxAmt(exportBO.getTaxAmt());
                detail.setUntaxAmt(exportBO.getUnTaxAmt());
                detail.setAmount(exportBO.getAmount());
                detail.setTaxRate(exportBO.getTaxRate());
                detail.setTaxClassCode(exportBO.getTaxCatCode());
                detail.setItemName(exportBO.getSkuName());
                detail.setInspectionId(vo.getInspectionId());
                detail.setItemNo(vo.getItemNo());
                detail.setSaleUnitPrice(vo.getSaleUnitPrice());
                detail.setQuantity(vo.getQuantity());
                detail.setUnitName(vo.getUnitName());
                detail.setOrderId(vo.getOrderId());
                break;
            }
            if (!isMatch.booleanValue()) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u4e0a\u4f20\u7684\u5f00\u7968\u660e\u7ec6\u5546\u54c1\u884c\u53f7-\u5546\u54c1ID" + exportBO.getIdentify() + "\u88ab\u4fee\u6539\uff01");
                return rspBO;
            }
            if (detail == null) continue;
            saleInvoiceDetailSet.add(detail);
        }
        List<SaleInvoiceInfo> listByApplyNo = this.saleInvoiceInfoMapper.selectByApplyNo(reqBO.getApplyNo());
        if (!CollectionUtils.isEmpty(listByApplyNo)) {
            logger.debug("\u539f\u53d1\u7968\u4fe1\u606f\uff1a" + listByApplyNo.toString());
            for (SaleInvoiceInfo oldInvoice : listByApplyNo) {
                ArrayList<String> invoices = new ArrayList<String>();
                invoices.add(oldInvoice.getInvoiceNo());
                this.saleInvoiceDetailMapper.deleteByInvoiceNos(invoices);
                this.saleInvoiceInfoMapper.deleteByPrimaryKey(oldInvoice.getInvoiceNo());
            }
        }
        this.saleInvoiceInfoMapper.batchInsertSaleInvoiceInfo(saleInvoiceInfoMap.values().stream().collect(Collectors.toList()));
        this.saleInvoiceDetailMapper.batchInsertSaleInvoiceDetail(saleInvoiceDetailSet);
        HashMap<String, Object> updateParam = new HashMap<String, Object>();
        updateParam.put("billStatus", BillStatus.SEND_BILL.getCode());
        updateParam.put("applyNo", reqBO.getApplyNo());
        updateParam.put("invoiceMethod", InvoiceMethod.MANUAL.getCode());
        updateParam.put("pushStatus", null);
        updateParam.put("invoiceImportUrl", reqBO.getInvoiceXlsUrl());
        updateParam.put("invoiceImportName", reqBO.getInvoiceXlsName());
        updateParam.put("receiveDate", new Date());
        this.billApplyInfoMapper.updateBillApplyStatusByApplyNo(updateParam);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u624b\u52a8\u5f00\u7968\u5165\u5e93\u6210\u529f\uff01");
        return rspBO;
    }
}

