/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.FscBillCheckQryByDayBusiService;
import com.tydic.pfscext.api.busi.bo.FscBillCheckQryByDayBO;
import com.tydic.pfscext.api.busi.bo.FscBillCheckQryByDayBusiReqBO;
import com.tydic.pfscext.api.busi.bo.FscBillCheckQryByDayBusiRspBO;
import com.tydic.pfscext.dao.BillCheckResultMapper;
import com.tydic.pfscext.dao.po.BillCheckResultPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.FscBillCheckQryByDayBusiService"})
public class FscBillCheckQryByDayBusiServiceImpl
implements FscBillCheckQryByDayBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillCheckQryByDayBusiServiceImpl.class);
    @Autowired
    private BillCheckResultMapper billCheckResultMapper;

    @PostMapping(value={"qryCheckResult"})
    public FscBillCheckQryByDayBusiRspBO qryCheckResult(@RequestBody FscBillCheckQryByDayBusiReqBO reqBO) {
        FscBillCheckQryByDayBusiRspBO rspBO = new FscBillCheckQryByDayBusiRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        BillCheckResultPO billCheckResultPO = new BillCheckResultPO();
        billCheckResultPO.setBegDate(reqBO.getBegDate());
        billCheckResultPO.setEndDate(reqBO.getEndDate());
        String orderBy = " bill_date desc";
        List<BillCheckResultPO> billCheckResultPOS = this.billCheckResultMapper.getListPage(billCheckResultPO, (Page<Map<String, Object>>)page, orderBy);
        if (billCheckResultPOS == null || CollectionUtils.isEmpty(billCheckResultPOS)) {
            return rspBO;
        }
        ArrayList<FscBillCheckQryByDayBO> billCheckQryByDayBOS = new ArrayList<FscBillCheckQryByDayBO>();
        for (BillCheckResultPO po : billCheckResultPOS) {
            FscBillCheckQryByDayBO bo = new FscBillCheckQryByDayBO();
            BeanUtils.copyProperties((Object)po, (Object)bo);
            String billDate = String.valueOf(po.getBillDate());
            bo.setBillDate(billDate.substring(0, 4) + "-" + billDate.substring(4, 6) + "-" + billDate.substring(6, 8));
            if (po.getFscCenterPayCount() != null) {
                bo.setFscCenterPayCount(Integer.valueOf(po.getFscCenterPayCount().intValue()));
            }
            if (po.getPayCenterPayCount() != null) {
                bo.setPayCenterPayCount(Integer.valueOf(po.getPayCenterPayCount().intValue()));
            }
            if ("0".equals(po.getPayCountResult())) {
                bo.setPayCountResultStr("\u4e00\u81f4");
            } else if ("1".equals(po.getPayCountResult())) {
                bo.setPayCountResultStr("\u4e0d\u4e00\u81f4");
            }
            if ("0".equals(po.getPayFeeResult())) {
                bo.setPayFeeResultStr("\u4e00\u81f4");
            } else if ("1".equals(po.getPayFeeResult())) {
                bo.setPayFeeResultStr("\u4e0d\u4e00\u81f4");
            }
            billCheckQryByDayBOS.add(bo);
        }
        rspBO.setRows(billCheckQryByDayBOS);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

