/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.FscOrderPayStatusUpdateService;
import com.tydic.pfscext.api.busi.bo.FscOrderPayStatusUpdateReqBO;
import com.tydic.pfscext.api.busi.bo.FscOrderPayStatusUpdateRspBO;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.enums.SaleOrderPayStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.FscOrderPayStatusUpdateService"})
public class FscOrderPayStatusUpdateServiceImpl
implements FscOrderPayStatusUpdateService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderPayStatusUpdateServiceImpl.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;

    @PostMapping(value={"updateOrderPayStatus"})
    public FscOrderPayStatusUpdateRspBO updateOrderPayStatus(@RequestBody FscOrderPayStatusUpdateReqBO reqBO) {
        FscOrderPayStatusUpdateRspBO rspBO = new FscOrderPayStatusUpdateRspBO();
        ArrayList<Long> orderIds = new ArrayList<Long>();
        if (null == reqBO.getOrderId()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2orderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        orderIds.add(reqBO.getOrderId());
        if (null != reqBO.getParentOrderId()) {
            orderIds.add(reqBO.getParentOrderId());
        }
        SaleItemInfo saleItemInfo = new SaleItemInfo();
        saleItemInfo.setOrderId(reqBO.getOrderId());
        saleItemInfo = this.saleItemInfoMapper.selectOrderItemAmtSum(saleItemInfo);
        if (null == saleItemInfo || null == saleItemInfo.getAmtSum()) {
            return rspBO;
        }
        PayableDetailPO payableDetailPO = new PayableDetailPO();
        payableDetailPO.setOrderIdList(orderIds);
        payableDetailPO = this.payableDetailMapper.selectSumPaidAmt(payableDetailPO);
        if (null == payableDetailPO || null == payableDetailPO.getPaidAmtSum() || payableDetailPO.getPaidAmtSum().compareTo(BigDecimal.ZERO) == 0) {
            return rspBO;
        }
        SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
        saleOrderInfo.setOrderId(reqBO.getOrderId());
        if (payableDetailPO.getPaidAmtSum().compareTo(BigDecimal.ZERO) > 0 && payableDetailPO.getPaidAmtSum().compareTo(saleItemInfo.getAmtSum()) < 0) {
            saleOrderInfo.setPayStatus(SaleOrderPayStatus.PAYING.getCode());
        }
        if (payableDetailPO.getPaidAmtSum().compareTo(BigDecimal.ZERO) > 0 && payableDetailPO.getPaidAmtSum().compareTo(saleItemInfo.getAmtSum()) >= 0) {
            saleOrderInfo.setPayStatus(SaleOrderPayStatus.SUCCESS.getCode());
        }
        log.info("\u8ba2\u5355\u72b6\u6001\u4e3a\uff1a" + saleOrderInfo.getPayStatus());
        if (!StringUtils.isBlank((CharSequence)saleOrderInfo.getPayStatus())) {
            this.saleOrderInfoMapper.updateOrderPayStatus(saleOrderInfo);
        }
        return rspBO;
    }
}

