/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.payment.pay.ability.PayProOrderAbilityService;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceReqBo;
import com.tydic.payment.pay.ability.bo.PayProOrderAbilityServiceRspBo;
import com.tydic.pfscext.api.busi.FscPayableOrderOperService;
import com.tydic.pfscext.api.busi.bo.FscPayableOrderBusiRspParamBO;
import com.tydic.pfscext.api.busi.bo.FscPayableOrderOperReqBO;
import com.tydic.pfscext.api.busi.bo.FscPayableOrderOperRspBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.OrgMerchantConfigMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.PaymentLogMapper;
import com.tydic.pfscext.dao.bo.CheckPayableBO;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.OrgMerchantConfigPO;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.PaymentLog;
import com.tydic.pfscext.dao.vo.ApplyDetailVO;
import com.tydic.pfscext.enums.ApplyPayStatus;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.FlowFlag;
import com.tydic.pfscext.enums.PayFlowPayType;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.BillSNService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.busi.impl.FscRefundOrderOperServiceImpl;
import com.tydic.umcext.ability.bank.UmcPublicBankInfoAbilityService;
import com.tydic.umcext.ability.bank.bo.UmcPublicBankInfoQueryDetailAbilityReqBO;
import com.tydic.umcext.ability.bank.bo.UmcPublicBankInfoQueryDetailAbilityRspBO;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoDetailAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityRspBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.FscPayableOrderOperService"})
public class FscPayableOrderOperServiceImpl
implements FscPayableOrderOperService {
    private static final Logger log = LoggerFactory.getLogger(FscPayableOrderOperServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(FscPayableOrderOperServiceImpl.class);
    private static final String SUBMIT = "SUBMIT";
    private static final String CANCEL = "CANCEL";
    private static final Integer INVOIC_PAYABLE_TYPE = 1;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private OrgMerchantConfigMapper orgMerchantConfigMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private PayProOrderAbilityService payProOrderAbilityService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private FscRefundOrderOperServiceImpl fscRefundOrderOperService;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${PAY_RESULT_CALL_BACK:http://}")
    private String PAY_RESULT_CALL_BACK;
    @Value(value="${PAY_RESULT_CALL_BACK_CQT:http://}")
    private String PAY_RESULT_CALL_BACK_CQT;
    private static final Integer TRADE_MODEL = 0;
    private static final Integer MATCH_UP_MODEL = 1;
    private static final String PAYABLE_STATUS_SUCCESS = "03";
    private static final String SUCCESS = "02";
    private static final String PAYING = "01";
    private static final Integer PAY_TYPE_CYCLE = 5;
    private static final String RETRY = "03";
    @Value(value="${professOfflineUrl:http://}")
    private String professOfflineUrl;
    @Autowired
    private UmcQrySupplierInfoDetailAbilityService umcQrySupplierInfoDetailAbilityService;
    @Autowired
    private UmcPublicBankInfoAbilityService umcPublicBankInfoBusiService;

    @PostMapping(value={"dealPayable"})
    public FscPayableOrderOperRspBO dealPayable(@RequestBody FscPayableOrderOperReqBO reqBO) {
        int i;
        FscPayableOrderOperRspBO rspBO = new FscPayableOrderOperRspBO();
        this.initParam(reqBO);
        if (SUBMIT.equals(reqBO.getOperType())) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("FscPayableOrderOperServiceImpl-");
            buffer.append(reqBO.getPayableNos().toString());
            rspBO = this.cacheCheck(buffer, rspBO);
            if ("03".equals(rspBO.getDealResult())) {
                LOGGER.info("\u8fd4\u56de\u4e86");
                return rspBO;
            }
            try {
                OrgMerchantConfigPO orgMerchantConfigPO;
                Long payno = this.billSNService.getSn(BillType.PAY_APPLICATION);
                StringBuffer payOrderNo = new StringBuffer();
                payOrderNo.append("PAYMENT-").append(payno);
                List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.getListByIds(reqBO.getPayableNos());
                CheckPayableBO checkPayableBO = this.checkPayable(payableDetailPOS, reqBO, payno);
                Long receiptOrgId = payableDetailPOS.get(0).getSupplierId();
                Integer busiCode = payableDetailPOS.get(0).getBusiModel();
                if (TRADE_MODEL.equals(busiCode)) {
                    receiptOrgId = payableDetailPOS.get(0).getOperatorId();
                }
                if (null == (orgMerchantConfigPO = this.orgMerchantConfigMapper.selectByOrgId(receiptOrgId))) {
                    throw new PfscExtBusinessException("18000", "\u5546\u6237\u4fe1\u606f\u914d\u7f6e\u67e5\u8be2\u4e3a\u7a7a");
                }
                if (TRADE_MODEL.equals(payableDetailPOS.get(0).getBusiModel()) && payableDetailPOS.get(0).getPaymentType().equals(PAYING)) {
                    orgMerchantConfigPO.setMerchantId(orgMerchantConfigPO.getIntermendiateId());
                }
                if (checkPayableBO.isResendFlag()) {
                    StringBuffer payNo = new StringBuffer();
                    payNo.append("PAYMENT-").append(checkPayableBO.getApplyNo());
                    LOGGER.info("\u8ba2\u5355\u4ed8\u6b3e\u91cd\u53d1" + payNo);
                    ApplyPayInfoPO modelBy = this.applyPayInfoMapper.getModelById(checkPayableBO.getApplyNo());
                    this.createPayOrder(modelBy.getPayAmt(), reqBO, payNo.toString(), orgMerchantConfigPO, rspBO, busiCode, payableDetailPOS.get(0));
                    rspBO.setDealResult(PAYING);
                    this.cacheClient.delete(buffer.toString());
                    return rspBO;
                }
                BigDecimal payAmtSum = checkPayableBO.getPayAmtSum();
                if (payAmtSum.compareTo(new BigDecimal(0)) > 0) {
                    this.writeApplyPayInfo(payableDetailPOS.get(0), checkPayableBO.getAmtSum(), reqBO, payno);
                    this.createPayOrder(payAmtSum, reqBO, payOrderNo.toString(), orgMerchantConfigPO, rspBO, busiCode, payableDetailPOS.get(0));
                    rspBO.setDealResult(PAYING);
                } else {
                    this.writeApplyPayInfoDeduction(payableDetailPOS.get(0), checkPayableBO.getAmtSum(), reqBO, payno);
                }
                for (PayableDetailPO payableDetailPO : payableDetailPOS) {
                    if (payAmtSum.compareTo(new BigDecimal(0)) > 0) {
                        this.writeApplyDetail(payableDetailPO, reqBO, payno);
                        continue;
                    }
                    this.writeApplyDetailDeduction(payableDetailPO, reqBO, payno);
                }
                if (StringUtils.isBlank((CharSequence)rspBO.getDealResult())) {
                    rspBO.setDealResult(SUCCESS);
                }
            }
            catch (Exception e) {
                this.cacheClient.delete(buffer.toString());
                throw new PfscExtBusinessException("18000", e.getMessage());
            }
            this.cacheClient.delete(buffer.toString());
        }
        if (CANCEL.equals(reqBO.getOperType()) && (i = this.payableDetailMapper.updateByNOs(reqBO.getPayableNos(), PayableStatus.TERMINATION.getCode())) != reqBO.getPayableNos().size()) {
            throw new PfscExtBusinessException("18000", "\u7ec8\u6b62\u5e94\u4ed8\u5355\u72b6\u6001\u5931\u8d25");
        }
        return rspBO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FscPayableOrderOperRspBO cacheCheck(StringBuffer buffer, FscPayableOrderOperRspBO rspBO) {
        FscPayableOrderOperServiceImpl fscPayableOrderOperServiceImpl = this;
        synchronized (fscPayableOrderOperServiceImpl) {
            if (null != this.cacheClient.get(buffer.toString())) {
                LOGGER.info(buffer.toString() + this.cacheClient.get(buffer.toString()));
                rspBO.setDealResult("03");
                rspBO.setRespDesc("\u672c\u6b21\u4ed8\u6b3e\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u5c1d\u8bd5");
                return rspBO;
            }
            this.cacheClient.set(buffer.toString(), (Object)1);
            return rspBO;
        }
    }

    private void writeApplyPayInfoDeduction(PayableDetailPO payableDetailPO, BigDecimal amtSum, FscPayableOrderOperReqBO reqBO, Long payno) {
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        applyPayInfoPO.setPayAmt(amtSum);
        applyPayInfoPO.setPayno(payno.toString());
        applyPayInfoPO.setSource(payableDetailPO.getSource());
        applyPayInfoPO.setApplyDate(new Date());
        applyPayInfoPO.setOperatorId(payableDetailPO.getOperatorId());
        applyPayInfoPO.setOperatorName(reqBO.getOperatorName());
        applyPayInfoPO.setPayStatus(ApplyPayStatus.PAY_CONFIRMED.getCode());
        applyPayInfoPO.setSupplierId(payableDetailPO.getSupplierId());
        applyPayInfoPO.setCompanyId(reqBO.getCompanyId());
        applyPayInfoPO.setCompanyName(reqBO.getCompanyName());
        if (applyPayInfoPO.getSupplierName() == null && applyPayInfoPO.getSupplierId() != null) {
            applyPayInfoPO.setSupplierName(this.organizationInfoService.querySupplierName(applyPayInfoPO.getSupplierId()));
        }
        this.applyPayInfoMapper.insert(applyPayInfoPO);
    }

    private void writeApplyDetailDeduction(PayableDetailPO payableDetailPO, FscPayableOrderOperReqBO reqBO, Long payno) {
        ApplyDetail applyDetail = new ApplyDetail();
        applyDetail.setApplyNo(payno.toString());
        applyDetail.setPayableNo(payableDetailPO.getPayableNo());
        applyDetail.setOperatorId(reqBO.getOperatorId());
        applyDetail.setSource(payableDetailPO.getSource());
        applyDetail.setSupplierId(payableDetailPO.getSupplierId());
        applyDetail.setStatus(ApplyPayStatus.PAY_CONFIRMED.getCode());
        applyDetail.setAmt(payableDetailPO.getPayableAmt());
        applyDetail.setCompanyId(payableDetailPO.getOperatorId());
        this.applyDetailMapper.insert(applyDetail);
        payableDetailPO.setPaidAmt(payableDetailPO.getPayableAmt());
        payableDetailPO.setPayableStatus(PayableStatus.SUCCESS.getCode());
        this.payableDetailMapper.updateById(payableDetailPO);
    }

    private String checkApplyNo(FscPayableOrderOperReqBO reqBO) {
        String ApplyNos = null;
        ApplyDetailVO applyDetailVO = new ApplyDetailVO();
        for (String payableNo : reqBO.getPayableNos()) {
            applyDetailVO.setPayableNo(payableNo);
            List<ApplyDetail> applyDetails = this.applyDetailMapper.selectListByPayableNo(payableNo);
            if (CollectionUtils.isEmpty(applyDetails)) {
                List<ApplyDetail> applyDetailsList = this.applyDetailMapper.selectListByPayableNoAndStatus(payableNo);
                if (!CollectionUtils.isEmpty(applyDetailsList)) {
                    throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u786e\u8ba4\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
                }
                throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5355\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
            if (null == ApplyNos) {
                ApplyNos = applyDetails.get(0).getApplyNo();
                continue;
            }
            if (applyDetails.get(0).getApplyNo().equals(ApplyNos)) continue;
            throw new PfscExtBusinessException("18000", "\u6240\u9009\u5e94\u4ed8\u5355\u4e0d\u5c5e\u4e8e\u540c\u4e00\u4ed8\u6b3e\u5355");
        }
        return ApplyNos;
    }

    private void initParam(FscPayableOrderOperReqBO reqBO) {
        if (null == reqBO) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getPayableNos())) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5e94\u4ed8\u5355\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOperType())) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u64cd\u4f5c\u4e3a\u7a7a");
        }
        if (SUBMIT.equals(reqBO.getOperType())) {
            if (null == reqBO.getOperatorId()) {
                throw new PfscExtBusinessException("18000", "\u5165\u53c2\u64cd\u4f5c\u4ebaID\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getOperatorName())) {
                throw new PfscExtBusinessException("18000", "\u5165\u53c2\u64cd\u4f5c\u4eba\u540d\u79f0\u4e3a\u7a7a");
            }
            if (null == reqBO.getCompanyId()) {
                throw new PfscExtBusinessException("18000", "\u5165\u53c2\u516c\u53f8ID\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getCompanyName())) {
                throw new PfscExtBusinessException("18000", "\u5165\u53c2\u516c\u53f8\u540d\u79f0\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getFlowType())) {
                throw new PfscExtBusinessException("18000", "\u5165\u53c2\u6d41\u6c34\u7c7b\u578b\u4e3a\u7a7a");
            }
            try {
                Integer.parseInt(reqBO.getFlowType());
            }
            catch (NumberFormatException e) {
                throw new PfscExtBusinessException("18000", "\u5165\u53c2\u6d41\u6c34\u7c7b\u578b\u4e0d\u5339\u914d");
            }
        } else if (!CANCEL.equals(reqBO.getOperType())) {
            throw new PfscExtBusinessException("18000", "\u975e\u6cd5\u64cd\u4f5c\u7c7b\u578b");
        }
    }

    private void writeApplyDetail(PayableDetailPO payableDetailPO, FscPayableOrderOperReqBO reqBO, Long payno) {
        ApplyDetail applyDetail = new ApplyDetail();
        applyDetail.setApplyNo(payno.toString());
        applyDetail.setPayableNo(payableDetailPO.getPayableNo());
        applyDetail.setOperatorId(reqBO.getOperatorId());
        applyDetail.setSource(payableDetailPO.getSource());
        applyDetail.setSupplierId(payableDetailPO.getSupplierId());
        applyDetail.setStatus(ApplyPayStatus.APPLYING.getCode());
        applyDetail.setAmt(payableDetailPO.getPayableAmt());
        applyDetail.setCompanyId(payableDetailPO.getOperatorId());
        this.applyDetailMapper.insert(applyDetail);
        PayableDetailPO forUpdate = new PayableDetailPO();
        forUpdate.setPayableStatus(PayableStatus.PENDING.getCode());
        forUpdate.setPendingAmt(payableDetailPO.getPayableAmt());
        forUpdate.setPayableNo(payableDetailPO.getPayableNo());
        this.payableDetailMapper.updatePayAmount(forUpdate);
    }

    private void writeApplyPayInfo(PayableDetailPO payableDetailPO, BigDecimal payAmtSum, FscPayableOrderOperReqBO reqBO, Long payno) {
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        UmcQrySupplierInfoDetailAbilityReqBO umcQrySupplierInfoDetailAbilityReqBO = new UmcQrySupplierInfoDetailAbilityReqBO();
        umcQrySupplierInfoDetailAbilityReqBO.setSupplierId(payableDetailPO.getSupplierId());
        UmcPublicBankInfoQueryDetailAbilityReqBO umcPublicBankInfoQueryDetailBusiReqBO = new UmcPublicBankInfoQueryDetailAbilityReqBO();
        umcPublicBankInfoQueryDetailBusiReqBO.setContactId(payableDetailPO.getOperatorId());
        LOGGER.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5165\u53c2\uff1a" + JSON.toJSONString((Object)umcQrySupplierInfoDetailAbilityReqBO));
        UmcQrySupplierInfoDetailAbilityRspBO umcQrySupplierInfoDetailAbilityRspBO = this.umcQrySupplierInfoDetailAbilityService.qrySupplierInfoDetail(umcQrySupplierInfoDetailAbilityReqBO);
        if (!INVOIC_PAYABLE_TYPE.equals(payableDetailPO.getPayableType()) && TRADE_MODEL.equals(payableDetailPO.getBusiModel())) {
            UmcPublicBankInfoQueryDetailAbilityRspBO mcPublicBankInfoQueryDetailBusiRspBO = this.umcPublicBankInfoBusiService.queryBankInfoDetail(umcPublicBankInfoQueryDetailBusiReqBO);
            LOGGER.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u51fa\u53c2\uff1a\u94f6\u884c\u8d26\u6237:" + mcPublicBankInfoQueryDetailBusiRspBO.getBankAccount());
            applyPayInfoPO.setReceiptAcctNo(mcPublicBankInfoQueryDetailBusiRspBO.getBankAccount());
            applyPayInfoPO.setRecAcctName(mcPublicBankInfoQueryDetailBusiRspBO.getBankAccountName());
            applyPayInfoPO.setOpenBankName(mcPublicBankInfoQueryDetailBusiRspBO.getBankName());
            applyPayInfoPO.setReceiptCompany(payableDetailPO.getOperatorId());
        } else {
            LOGGER.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u51fa\u53c2\uff1a\u94f6\u884c\u8d26\u6237:" + umcQrySupplierInfoDetailAbilityRspBO.getBankAccount());
            applyPayInfoPO.setReceiptCompany(payableDetailPO.getSupplierId());
            if (!StringUtils.isBlank((CharSequence)umcQrySupplierInfoDetailAbilityRspBO.getBankAccount())) {
                applyPayInfoPO.setReceiptAcctNo(umcQrySupplierInfoDetailAbilityRspBO.getBankAccount());
                applyPayInfoPO.setRecAcctName(umcQrySupplierInfoDetailAbilityRspBO.getBankAccountName());
                applyPayInfoPO.setOpenBankName(umcQrySupplierInfoDetailAbilityRspBO.getBankName());
            } else {
                UmcPublicBankInfoQueryDetailAbilityReqBO umcPublicBankInfoQueryDetailBusiReqBO1 = new UmcPublicBankInfoQueryDetailAbilityReqBO();
                umcPublicBankInfoQueryDetailBusiReqBO1.setContactId(payableDetailPO.getSupplierId());
                UmcPublicBankInfoQueryDetailAbilityRspBO mcPublicBankInfoQueryDetailBusiRspBO = this.umcPublicBankInfoBusiService.queryBankInfoDetail(umcPublicBankInfoQueryDetailBusiReqBO1);
                applyPayInfoPO.setReceiptAcctNo(mcPublicBankInfoQueryDetailBusiRspBO.getBankAccount());
                applyPayInfoPO.setRecAcctName(mcPublicBankInfoQueryDetailBusiRspBO.getBankAccountName());
                applyPayInfoPO.setOpenBankName(mcPublicBankInfoQueryDetailBusiRspBO.getBankName());
            }
        }
        applyPayInfoPO.setPayAmt(payAmtSum);
        applyPayInfoPO.setPayno(payno.toString());
        applyPayInfoPO.setSource(payableDetailPO.getSource());
        applyPayInfoPO.setApplyDate(new Date());
        applyPayInfoPO.setOperatorId(reqBO.getOperatorId());
        applyPayInfoPO.setOperatorName(reqBO.getOperatorName());
        applyPayInfoPO.setPayStatus(ApplyPayStatus.APPLYING.getCode());
        applyPayInfoPO.setSupplierId(payableDetailPO.getSupplierId());
        applyPayInfoPO.setCompanyId(reqBO.getCompanyId());
        applyPayInfoPO.setCompanyName(reqBO.getCompanyName());
        if (applyPayInfoPO.getSupplierName() == null && applyPayInfoPO.getSupplierId() != null) {
            applyPayInfoPO.setSupplierName(this.organizationInfoService.querySupplierName(applyPayInfoPO.getSupplierId()));
        }
        this.applyPayInfoMapper.insert(applyPayInfoPO);
    }

    private void savelog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }

    private void createPaymentFlow(BigDecimal payAmt, FscPayableOrderOperReqBO reqBO, PayProOrderAbilityServiceRspBo payProOrderAbilityServiceRspBo, OrgMerchantConfigPO orgMerchantConfigPO, String payOrderNo, Integer busiCode, PayableDetailPO payableDetailPO) {
        PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
        paymentFlowInfo.setAsynUrl(this.PAY_RESULT_CALL_BACK);
        paymentFlowInfo.setOutOrderId(payOrderNo);
        paymentFlowInfo.setOrderAmt(payAmt);
        paymentFlowInfo.setOrderDesc(reqBO.getOrderDetail());
        paymentFlowInfo.setCreateUserId(reqBO.getOperatorId());
        paymentFlowInfo.setCreateUserName(reqBO.getOperatorName());
        paymentFlowInfo.setFlowFlag(reqBO.getFlowFlag());
        paymentFlowInfo.setOrderCode(reqBO.getOrderCode());
        if (StringUtils.isBlank((CharSequence)reqBO.getFlowFlag())) {
            paymentFlowInfo.setFlowFlag(FlowFlag.ORDER_PAY.getCode());
        }
        paymentFlowInfo.setCreateTime(new Date());
        paymentFlowInfo.setClientIp(reqBO.getIpAddress());
        paymentFlowInfo.setBusiCode(orgMerchantConfigPO.getBusiCode());
        paymentFlowInfo.setMerchantId(orgMerchantConfigPO.getMerchantId());
        paymentFlowInfo.setWebUrl(reqBO.getWebUrl());
        paymentFlowInfo.setOrgId(reqBO.getCompanyId());
        paymentFlowInfo.setPayOrgNo(reqBO.getCompanyId());
        paymentFlowInfo.setPaymentFlowId(payProOrderAbilityServiceRspBo.getPaymentInsId());
        paymentFlowInfo.setBusiReqData(payProOrderAbilityServiceRspBo.getBusiRspData());
        paymentFlowInfo.setBankUrl(payProOrderAbilityServiceRspBo.getUrl());
        paymentFlowInfo.setRecOrgNo(orgMerchantConfigPO.getOrgId());
        String purcharseOrgName = this.organizationInfoService.queryOrgName(payableDetailPO.getPurchaseNo());
        paymentFlowInfo.setPayName(purcharseOrgName);
        if (TRADE_MODEL.equals(busiCode)) {
            String operUnitName = this.organizationInfoService.queryOrgName(payableDetailPO.getOperatorId());
            paymentFlowInfo.setRecName(operUnitName);
        } else {
            String supplierName = this.organizationInfoService.querySupplierName(payableDetailPO.getSupplierId());
            if (StringUtils.isBlank((CharSequence)supplierName)) {
                supplierName = this.organizationInfoService.queryOrgName(payableDetailPO.getSupplierId());
            }
            paymentFlowInfo.setRecName(supplierName);
        }
        try {
            paymentFlowInfo.setFlowType(Integer.parseInt(reqBO.getFlowType()));
        }
        catch (NumberFormatException e) {
            paymentFlowInfo.setFlowType(0);
            log.error("\u7528\u6237\u7c7b\u578b\u4e0d\u5339\u914d");
        }
        PaymentFlowInfo paymentFlowInfo1 = this.paymentFlowInfoMapper.selectByOutOrderId(paymentFlowInfo.getOutOrderId());
        if (null == paymentFlowInfo1) {
            this.paymentFlowInfoMapper.insert(paymentFlowInfo);
        } else {
            this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo);
        }
    }

    private void createPayOrder(BigDecimal payAmtSum, FscPayableOrderOperReqBO reqBO, String payOrderNo, OrgMerchantConfigPO orgMerchantConfigPO, FscPayableOrderOperRspBO rspBO, Integer busiCode, PayableDetailPO payableDetailPO) {
        PayProOrderAbilityServiceReqBo payProOrderAbilityServiceReqBo = new PayProOrderAbilityServiceReqBo();
        payProOrderAbilityServiceReqBo.setOutOrderId(payOrderNo);
        payProOrderAbilityServiceReqBo.setBusiCode(orgMerchantConfigPO.getBusiCode());
        LOGGER.info("MerchantId:" + orgMerchantConfigPO);
        payProOrderAbilityServiceReqBo.setMerchantId(String.valueOf(orgMerchantConfigPO.getMerchantId()));
        LOGGER.info("MerchantId:" + payProOrderAbilityServiceReqBo.getMerchantId());
        BigDecimal payAmtB = payAmtSum.multiply(new BigDecimal(100));
        payProOrderAbilityServiceReqBo.setTotalFee(payAmtB.setScale(0, 1).toString());
        payProOrderAbilityServiceReqBo.setDetailName(reqBO.getOrderDetail());
        payProOrderAbilityServiceReqBo.setRemark("");
        payProOrderAbilityServiceReqBo.setNotifyUrl(this.PAY_RESULT_CALL_BACK);
        if (StringUtils.isBlank((CharSequence)reqBO.getPayMethod())) {
            payProOrderAbilityServiceReqBo.setReqWay("1");
        }
        payProOrderAbilityServiceReqBo.setCreateIpAddress(reqBO.getIpAddress());
        payProOrderAbilityServiceReqBo.setCreateOperId(String.valueOf(reqBO.getOperatorId()));
        payProOrderAbilityServiceReqBo.setCreateOperIdName(reqBO.getOperatorName());
        payProOrderAbilityServiceReqBo.setRedirectUrl(reqBO.getWebUrl());
        payProOrderAbilityServiceReqBo.setPayMethod(reqBO.getPayMethod());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("notifyAddress", (Object)this.PAY_RESULT_CALL_BACK_CQT);
        jsonObject.put("payMethods", (Object)reqBO.getPayMethods());
        String offlineUlr = "";
        offlineUlr = this.professOfflineUrl + "?applyNo=" + payOrderNo.substring(8) + "&offlineWebUrl=";
        if (!StringUtils.isEmpty((CharSequence)reqBO.getWebUrl())) {
            offlineUlr = offlineUlr + reqBO.getWebUrl().substring(reqBO.getWebUrl().lastIndexOf("/") + 1);
        }
        jsonObject.put("offlinePayUrl", (Object)offlineUlr);
        payProOrderAbilityServiceReqBo.setBusiReqData(jsonObject.toJSONString());
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u652f\u4ed8\u4e2d\u5fc3\u521b\u5efa\u652f\u4ed8\u5355\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)payProOrderAbilityServiceReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        PayProOrderAbilityServiceRspBo payProOrderAbilityServiceRspBo = this.payProOrderAbilityService.dealOrder(payProOrderAbilityServiceReqBo);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u652f\u4ed8\u4e2d\u5fc3\u521b\u5efa\u652f\u4ed8\u5355\u51fa\u53c2:{}", (Object)JSONObject.toJSONString((Object)payProOrderAbilityServiceRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        if (!"0000".equals(payProOrderAbilityServiceRspBo.getRespCode())) {
            log.error("\u521b\u5efa\u8ba2\u5355[" + payOrderNo.toString() + "]\u5931\u8d25,\uff1a" + payProOrderAbilityServiceRspBo.getRespDesc());
            this.savelog("CreatePayOrderService-266", JSONObject.toJSONString((Object)payProOrderAbilityServiceReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)payProOrderAbilityServiceRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            throw new PfscExtBusinessException("18000", payProOrderAbilityServiceRspBo.getRespDesc());
        }
        this.createPaymentFlow(payAmtSum, reqBO, payProOrderAbilityServiceRspBo, orgMerchantConfigPO, payOrderNo, busiCode, payableDetailPO);
        BeanUtils.copyProperties((Object)payProOrderAbilityServiceRspBo, (Object)rspBO);
        FscPayableOrderBusiRspParamBO fscPayableOrderBusiRspParamBO = (FscPayableOrderBusiRspParamBO)JSON.parseObject((String)payProOrderAbilityServiceRspBo.getBusiRspData(), FscPayableOrderBusiRspParamBO.class);
        rspBO.setFscPayableOrderBusiRspParamBO(fscPayableOrderBusiRspParamBO);
        this.savelog("CreatePayOrderService-267", JSONObject.toJSONString((Object)payProOrderAbilityServiceReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)payProOrderAbilityServiceRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
    }

    private CheckPayableBO checkPayable(List<PayableDetailPO> payableDetailPOS, FscPayableOrderOperReqBO reqBO, Long payNo) {
        OrgMerchantConfigPO orgMerchantConfigPO;
        CheckPayableBO checkPayableBO = new CheckPayableBO();
        if (CollectionUtils.isEmpty(payableDetailPOS) || payableDetailPOS.size() != reqBO.getPayableNos().size()) {
            throw new PfscExtBusinessException("18000", "\u5b58\u5728\u65e0\u6548\u5e94\u4ed8\u5355\u53f7");
        }
        Long supplierId = payableDetailPOS.get(0).getSupplierId();
        Long operUnitId = payableDetailPOS.get(0).getOperatorId();
        BigDecimal payAmtSum = new BigDecimal(0);
        for (PayableDetailPO payableDetailPO : payableDetailPOS) {
            String applyNo;
            if (TRADE_MODEL.equals(payableDetailPO.getBusiModel()) && !operUnitId.equals(payableDetailPO.getOperatorId())) {
                throw new PfscExtBusinessException("18000", "\u5408\u5e76\u652f\u4ed8\u5fc5\u987b\u76f8\u540c\u6536\u6b3e\u65b9");
            }
            if (MATCH_UP_MODEL.equals(payableDetailPO.getBusiModel()) && !supplierId.equals(payableDetailPO.getSupplierId())) {
                throw new PfscExtBusinessException("18000", "\u5408\u5e76\u652f\u4ed8\u5fc5\u987b\u76f8\u540c\u6536\u6b3e\u65b9");
            }
            if (!PayableStatus.PENDING.getCode().equals(payableDetailPO.getPayableStatus())) {
                throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u72b6\u6001\u4e0d\u662f\u5f85\u4ed8\u6b3e\uff0c\u4e0d\u80fd\u53d1\u8d77\u4ed8\u6b3e");
            }
            if (null == payableDetailPO.getPayableAmt() || payableDetailPO.getPayableAmt().compareTo(BigDecimal.ZERO) <= 0) {
                throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
            }
            if (null != payableDetailPO.getPendingAmt() && payableDetailPO.getPendingAmt().compareTo(BigDecimal.ZERO) > 0 && null != (applyNo = this.checkApplyNo(reqBO))) {
                checkPayableBO.setResendFlag(true);
                checkPayableBO.setApplyNo(applyNo);
                return checkPayableBO;
            }
            payAmtSum = payAmtSum.add(payableDetailPO.getPayableAmt());
            checkPayableBO.setAmtSum(payAmtSum);
        }
        BigDecimal finallyAmtSum = payAmtSum;
        Long receiptOrgId = payableDetailPOS.get(0).getSupplierId();
        if (BusiModel.TRADE_MODEL.getCode().equals(payableDetailPOS.get(0).getBusiModel().toString())) {
            receiptOrgId = payableDetailPOS.get(0).getOperatorId();
        }
        if (null == (orgMerchantConfigPO = this.orgMerchantConfigMapper.selectByOrgId(receiptOrgId))) {
            throw new PfscExtBusinessException("18000", "\u8bf7\u5148\u914d\u7f6e\u5546\u6237\u4fe1\u606f");
        }
        if (!BusiModel.TRADE_MODEL.getCode().equals(payableDetailPOS.get(0).getBusiModel().toString()) || PAY_TYPE_CYCLE.equals(payableDetailPOS.get(0).getPayableType())) {
            // empty if block
        }
        LOGGER.info("\u62b5\u6263\u540e\u91d1\u989d" + finallyAmtSum);
        checkPayableBO.setPayAmtSum(finallyAmtSum);
        if (payAmtSum.compareTo(finallyAmtSum) > 0) {
            Integer busiCode = payableDetailPOS.get(0).getBusiModel();
            StringBuffer payOrderNo = new StringBuffer();
            payOrderNo.append("DEDUCTION-").append(payNo);
            this.createPaymentFlow(payAmtSum.subtract(finallyAmtSum), reqBO, orgMerchantConfigPO, payOrderNo, busiCode, payableDetailPOS.get(0));
        }
        return checkPayableBO;
    }

    private void createPaymentFlow(BigDecimal subtractAmt, FscPayableOrderOperReqBO reqBO, OrgMerchantConfigPO orgMerchantConfigPO, StringBuffer payOrderNo, Integer busiCode, PayableDetailPO payableDetailPO) {
        PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
        paymentFlowInfo.setOutOrderId(payOrderNo.toString());
        paymentFlowInfo.setOrderAmt(subtractAmt);
        paymentFlowInfo.setOrderDesc(reqBO.getOrderDetail());
        paymentFlowInfo.setCreateUserId(reqBO.getOperatorId());
        paymentFlowInfo.setCreateUserName(reqBO.getOperatorName());
        paymentFlowInfo.setOrderCode(reqBO.getOrderCode());
        paymentFlowInfo.setFlowFlag(FlowFlag.ORDER_PAY.getCode());
        paymentFlowInfo.setPayType(PayFlowPayType.PAY_TYPE_200.getCode());
        paymentFlowInfo.setPayTime(new Date());
        paymentFlowInfo.setCreateTime(new Date());
        paymentFlowInfo.setClientIp(reqBO.getIpAddress());
        paymentFlowInfo.setBusiCode(orgMerchantConfigPO.getBusiCode());
        paymentFlowInfo.setMerchantId(orgMerchantConfigPO.getMerchantId());
        paymentFlowInfo.setOrgId(reqBO.getCompanyId());
        paymentFlowInfo.setPayOrgNo(reqBO.getCompanyId());
        String purcharseOrgName = this.organizationInfoService.queryOrgName(payableDetailPO.getPurchaseNo());
        paymentFlowInfo.setPayName(purcharseOrgName);
        if (TRADE_MODEL.equals(busiCode)) {
            String operUnitName = this.organizationInfoService.queryOrgName(payableDetailPO.getOperatorId());
            paymentFlowInfo.setRecName(operUnitName);
        } else {
            String supplierName = this.organizationInfoService.querySupplierName(payableDetailPO.getSupplierId());
            if (StringUtils.isBlank((CharSequence)supplierName)) {
                supplierName = this.organizationInfoService.queryOrgName(payableDetailPO.getSupplierId());
            }
            paymentFlowInfo.setRecName(supplierName);
        }
        try {
            paymentFlowInfo.setFlowType(Integer.parseInt(reqBO.getFlowType()));
        }
        catch (NumberFormatException e) {
            paymentFlowInfo.setFlowType(0);
            log.error("\u7528\u6237\u7c7b\u578b\u4e0d\u5339\u914d");
        }
        PaymentFlowInfo paymentFlowInfo1 = this.paymentFlowInfoMapper.selectByOutOrderId(paymentFlowInfo.getOutOrderId());
        if (null == paymentFlowInfo1) {
            this.paymentFlowInfoMapper.insert(paymentFlowInfo);
        } else {
            this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo);
        }
    }
}

