/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.payment.pay.ability.PayProRefundAbilityService;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityRspBo;
import com.tydic.pfscext.api.busi.BusiAddPayAbleService;
import com.tydic.pfscext.api.busi.FscRefundOrderOperService;
import com.tydic.pfscext.api.busi.bo.FscRefundOrderOperReqBO;
import com.tydic.pfscext.api.busi.bo.FscRefundOrderOperRspBO;
import com.tydic.pfscext.api.busi.bo.PaymentFlowInfoExtJsonBO;
import com.tydic.pfscext.api.notify.SendRefundResultService;
import com.tydic.pfscext.api.notify.bo.SendRefundResultReq;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.OrgMerchantConfigMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.PaymentLogMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.OrgMerchantConfigPO;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.PaymentLog;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.FlowFlag;
import com.tydic.pfscext.enums.PayFlowPayType;
import com.tydic.pfscext.enums.PayMethod;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.enums.PayableType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.BillSNService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.FscRefundOrderOperService"})
public class FscRefundOrderOperServiceImpl
implements FscRefundOrderOperService {
    private static final Logger log = LoggerFactory.getLogger(FscRefundOrderOperServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(FscRefundOrderOperServiceImpl.class);
    private static final String SUBMIT = "SUBMIT";
    private static final String CANCEL = "CANCEL";
    private static final Integer CONFIRM_STATUS = 1;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private OrgMerchantConfigMapper orgMerchantConfigMapper;
    @Autowired
    private PayProRefundAbilityService payProRefundAbilityService;
    @Autowired
    private BusiAddPayAbleService busiAddPayAbleService;
    @Value(value="${REFUND_RESULT_CALL_BACK:http://}")
    private String REFUND_RESULT_CALL_BACK;
    private static final String PART_REFUND = "06";
    private static final String REFUNDING = "01";
    private static final String REFUNDED = "02";
    private static final String PENDING = "01";
    private static final Integer AFTER_SALE = 8;
    private static final Integer PAY_TYPE_CYCLE = 5;
    private static final String PAY_SUBMITTED = "SUBMITTED";
    private static final String PAY_SUCCESS = "SUCCESS";
    @Autowired
    private SendRefundResultService sendRefundResultService;

    @PostMapping(value={"makeRefund"})
    public FscRefundOrderOperRspBO makeRefund(@RequestBody FscRefundOrderOperReqBO reqBO) {
        LOGGER.info("\u8c03\u7528\u9000\u6b3e\u670d\u52a1\uff1a" + reqBO);
        FscRefundOrderOperRspBO rspBO = new FscRefundOrderOperRspBO();
        this.savelog("CreateRefundOrderService-1", JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)rspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        this.initParam(reqBO);
        PaymentFlowInfo alreadyPayment = this.paymentFlowInfoMapper.selectRefundAmtBySn(reqBO.getOutRefundOrderSn());
        if (null != alreadyPayment && null != alreadyPayment.getOrderAmt()) {
            rspBO.setDealResult(REFUNDED);
            rspBO.setCanRefundAmt(alreadyPayment.getOrderAmt());
            return rspBO;
        }
        if (SUBMIT.equals(reqBO.getOperType())) {
            OrgMerchantConfigPO orgMerchantConfigPO;
            List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.getListByAllOrderId(reqBO.getOrderId(), reqBO.getParentOrderId());
            if (CollectionUtils.isEmpty(payableDetailPOS)) {
                rspBO.setDealResult(REFUNDED);
                rspBO.setCanRefundAmt(BigDecimal.ZERO);
                return rspBO;
            }
            List<PayableDetailPO> needRefundPayableDetailPOS = this.getRefundPayableDetailPOS(reqBO.getRefundAmtSum(), payableDetailPOS, reqBO.getSendGoodsNo());
            if (CollectionUtils.isEmpty(needRefundPayableDetailPOS)) {
                throw new PfscExtBusinessException("18000", "\u65e0\u53ef\u9000\u6b3e\u4fe1\u606f");
            }
            Long receiptOrgId = payableDetailPOS.get(0).getSupplierId();
            if (BusiModel.TRADE_MODEL.getCode().equals(payableDetailPOS.get(0).getBusiModel().toString())) {
                receiptOrgId = payableDetailPOS.get(0).getOperatorId();
            }
            if (null == (orgMerchantConfigPO = this.orgMerchantConfigMapper.selectByOrgId(receiptOrgId))) {
                throw new PfscExtBusinessException("18000", "\u8bf7\u5148\u914d\u7f6e\u5546\u6237\u4fe1\u606f");
            }
            BigDecimal canRefundAmt = BigDecimal.ZERO;
            for (PayableDetailPO needPayableDetailPO : needRefundPayableDetailPOS) {
                if (!PayableStatus.PAYING.getCode().equals(needPayableDetailPO.getPayableStatus()) && !PayableStatus.SUCCESS.getCode().equals(needPayableDetailPO.getPayableStatus())) continue;
                canRefundAmt = canRefundAmt.add(needPayableDetailPO.getRefundAmt());
            }
            LOGGER.info("\u672c\u6b21\u8ba2\u5355\u9700\u53d1\u8d77\u9000\u6b3e\uff1a" + canRefundAmt);
            for (PayableDetailPO needPayableDetailPO : needRefundPayableDetailPOS) {
                String refundNo = this.billSNService.getSn(BillType.REFUND_APPLICATION).toString();
                String refundOrderNo = "REFUND-" + refundNo;
                if (PayableStatus.PAYING.getCode().equals(needPayableDetailPO.getPayableStatus()) || PayableStatus.SUCCESS.getCode().equals(needPayableDetailPO.getPayableStatus())) {
                    PaymentFlowInfo paymentFlowInfoOri;
                    if (PAY_TYPE_CYCLE.equals(payableDetailPOS.get(0).getPayableType())) {
                        // empty if block
                    }
                    LOGGER.info("\u751f\u6210\u6d41\u6c34\u7684\u5916\u90e8\u8ba2\u5355\u53f7\uff1a" + reqBO.getOutRefundOrderSn());
                    ApplyPayInfoPO applyInfo = this.applyPayInfoMapper.getModelById(needPayableDetailPO.getApplyNo());
                    boolean falgOne = (!BusiModel.TRADE_MODEL.getCode().equals(needPayableDetailPO.getBusiModel().toString()) || !needPayableDetailPO.getPaymentType().equals("01")) && PayMethod.ZHCQT.getCode().equals(applyInfo.getPayMathod());
                    boolean falgTwo = PayMethod.ZH_BF.getCode().equals(applyInfo.getPayMathod()) || PayMethod.ZHCQT_SF.getCode().equals(applyInfo.getPayMathod()) || PayMethod.ZH_SF.getCode().equals(applyInfo.getPayMathod());
                    boolean falgThree = PayMethod.XXZF.getCode().equals(applyInfo.getPayMathod());
                    if (falgOne || falgTwo || falgThree) {
                        LOGGER.info("\u7ebf\u4e0b\u9000\u6b3e\u8bb0\u5f55\uff1a" + reqBO.getOutRefundOrderSn());
                        this.createPaymentFlowZH(needPayableDetailPO, reqBO, refundOrderNo, orgMerchantConfigPO.getBusiCode(), reqBO.getOutRefundOrderSn(), canRefundAmt);
                        continue;
                    }
                    PayProRefundAbilityRspBo refundRsp = this.createRefundOrder(needPayableDetailPO, reqBO, refundOrderNo, orgMerchantConfigPO.getBusiCode());
                    if (null != refundRsp && PAY_SUBMITTED.equals(refundRsp.getResultCode())) {
                        rspBO.setDealResult("01");
                        continue;
                    }
                    if (!PAY_SUCCESS.equals(refundRsp.getResultCode())) continue;
                    String payChannel = "";
                    if (!StringUtils.isEmpty((CharSequence)refundRsp.getOriOutOrderId()) && (paymentFlowInfoOri = this.paymentFlowInfoMapper.selectByOutOrderId(refundRsp.getOriOutOrderId())) != null) {
                        payChannel = paymentFlowInfoOri.getPayChannel();
                    }
                    this.createPaymentFlow(needPayableDetailPO, reqBO, refundOrderNo, orgMerchantConfigPO.getBusiCode(), reqBO.getOutRefundOrderSn(), canRefundAmt, null, payChannel, refundRsp.getRefundTransId());
                    PaymentFlowInfo paymentFlowInfo1 = this.paymentFlowInfoMapper.selectByOutOrderId(refundOrderNo);
                    SendRefundResultReq sendRefundResultReq = new SendRefundResultReq();
                    sendRefundResultReq.setUserId(paymentFlowInfo1.getCreateUserId());
                    sendRefundResultReq.setOrderCode(payableDetailPOS.get(0).getPurchaseOrderCode());
                    sendRefundResultReq.setType(Integer.valueOf(1));
                    log.info("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u53d1\u9001\u4fe1\u606f" + sendRefundResultReq);
                    this.sendRefundResultService.send(sendRefundResultReq);
                    continue;
                }
                LOGGER.info("\u62b5\u6263\u4e86\u5e94\u4ed8\u5355\uff1a" + needPayableDetailPO);
                this.updateRefundPayable(needPayableDetailPO);
                this.createPaymentFlow(needPayableDetailPO, reqBO, refundOrderNo, orgMerchantConfigPO.getBusiCode(), reqBO.getOutRefundOrderSn(), canRefundAmt, new Date(), null, null);
            }
            if (StringUtils.isBlank((CharSequence)rspBO.getDealResult())) {
                rspBO.setDealResult(REFUNDED);
            }
            rspBO.setCanRefundAmt(canRefundAmt);
        }
        this.savelog("CreateRefundOrderService-1", JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)rspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return rspBO;
    }

    private void createPaymentFlowZH(PayableDetailPO payableDetailPO, FscRefundOrderOperReqBO reqBO, String refundOrderNo, String busiCode, String outRefundOrderSn, BigDecimal canRefundAmt) {
        PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
        StringBuffer payOrderNo = new StringBuffer();
        payOrderNo.append("PAYMENT-").append(null != payableDetailPO.getApplyNo() ? payableDetailPO.getApplyNo() : "");
        PaymentFlowInfo paymentPO = this.paymentFlowInfoMapper.selectByOutOrderId(payOrderNo.toString());
        if (null != paymentPO) {
            paymentFlowInfo.setPayType(paymentPO.getPayType());
            paymentFlowInfo.setPayName(paymentPO.getRecName());
            paymentFlowInfo.setRecName(paymentPO.getPayName());
            paymentFlowInfo.setOrderCode(paymentPO.getOrderCode());
            paymentFlowInfo.setRecOrgNo(paymentPO.getPayOrgNo());
            paymentFlowInfo.setPayOrgNo(paymentPO.getRecOrgNo());
            paymentFlowInfo.setPayChannel(paymentPO.getPayChannel());
        }
        paymentFlowInfo.setOutOrderId(refundOrderNo);
        paymentFlowInfo.setReturnOutOrderId(payOrderNo.toString());
        paymentFlowInfo.setOrderAmt(payableDetailPO.getRefundAmt());
        paymentFlowInfo.setOrderDesc("\u8ba2\u5355\u9000\u6b3e");
        paymentFlowInfo.setCreateUserId(reqBO.getOperatorId());
        paymentFlowInfo.setCreateUserName(reqBO.getOperatorName());
        paymentFlowInfo.setFlowFlag(FlowFlag.RETURN_GOODS_REFUND.getCode());
        if (outRefundOrderSn.contains("ORD")) {
            paymentFlowInfo.setFlowFlag(FlowFlag.ORDER_REIMBURSE.getCode());
        }
        paymentFlowInfo.setPayType(PayFlowPayType.PAY_TYPE_7.getCode());
        paymentFlowInfo.setCreateTime(new Date());
        paymentFlowInfo.setClientIp(reqBO.getIpAddress());
        paymentFlowInfo.setBusiCode(busiCode);
        PaymentFlowInfoExtJsonBO paymentFlowInfoExtJsonBO = new PaymentFlowInfoExtJsonBO();
        paymentFlowInfoExtJsonBO.setOutRefundOrderSn(outRefundOrderSn);
        paymentFlowInfoExtJsonBO.setRefundAmt(canRefundAmt);
        paymentFlowInfo.setExtJson(JSON.toJSONString((Object)paymentFlowInfoExtJsonBO));
        try {
            paymentFlowInfo.setFlowType(Integer.parseInt(reqBO.getFlowType()));
        }
        catch (NumberFormatException e) {
            paymentFlowInfo.setFlowType(0);
            log.error("\u7528\u6237\u7c7b\u578b\u4e0d\u5339\u914d");
        }
        this.paymentFlowInfoMapper.insert(paymentFlowInfo);
    }

    private void initParam(FscRefundOrderOperReqBO reqBO) {
        if (null == reqBO) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getRefundAmtSum()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4ed8\u6b3e\u91d1\u989d\u4e3a\u7a7a");
        }
        if (CANCEL.equals(reqBO.getOperType()) && StringUtils.isBlank((CharSequence)reqBO.getPayableNo())) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5e94\u4ed8\u5355\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOperType())) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u64cd\u4f5c\u4e3a\u7a7a");
        }
        if (SUBMIT.equals(reqBO.getOperType())) {
            if (null == reqBO.getOperatorId()) {
                throw new PfscExtBusinessException("18000", "\u5165\u53c2\u64cd\u4f5c\u4ebaID\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getOutRefundOrderSn())) {
                throw new PfscExtBusinessException("18000", "\u9000\u6b3e\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getOperatorName())) {
                throw new PfscExtBusinessException("18000", "\u5165\u53c2\u64cd\u4f5c\u4eba\u540d\u79f0\u4e3a\u7a7a");
            }
            if (null == reqBO.getCompanyId()) {
                throw new PfscExtBusinessException("18000", "\u5165\u53c2\u516c\u53f8ID\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getCompanyName())) {
                throw new PfscExtBusinessException("18000", "\u5165\u53c2\u516c\u53f8\u540d\u79f0\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getFlowType())) {
                throw new PfscExtBusinessException("18000", "\u5165\u53c2\u6d41\u6c34\u7c7b\u578b\u4e3a\u7a7a");
            }
            try {
                Integer.parseInt(reqBO.getFlowType());
            }
            catch (NumberFormatException e) {
                throw new PfscExtBusinessException("18000", "\u5165\u53c2\u6d41\u6c34\u7c7b\u578b\u4e0d\u5339\u914d");
            }
        } else if (!CANCEL.equals(reqBO.getOperType())) {
            throw new PfscExtBusinessException("18000", "\u975e\u6cd5\u64cd\u4f5c\u7c7b\u578b");
        }
    }

    private void updateRefundPayable(PayableDetailPO needRefundPayableDetailPO) {
        PayableDetailPO refundUpdate = new PayableDetailPO();
        if (needRefundPayableDetailPO.getRefundAmt().subtract(needRefundPayableDetailPO.getPayableAmt()).compareTo(new BigDecimal(0)) == 0 && PayableType.AOG.getCode().equals(needRefundPayableDetailPO.getPayableType().toString())) {
            refundUpdate.setPayableStatus(PayableStatus.TERMINATION.getCode());
        }
        refundUpdate.setRefundAmt(needRefundPayableDetailPO.getRefundAmt());
        refundUpdate.setPayableNo(needRefundPayableDetailPO.getPayableNo());
        int result = this.payableDetailMapper.updateRefundAmt(refundUpdate);
        if (result < 1) {
            throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5355\u3010" + needRefundPayableDetailPO.getPayableNo() + "\u3011\u62b5\u6263\u5931\u8d25");
        }
    }

    private void savelog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }

    public void createPaymentFlow(PayableDetailPO payableDetailPO, FscRefundOrderOperReqBO reqBO, String refundOrderNo, String busiCode, String outRefundOrderSn, BigDecimal canRefundAmt, Date date, String payChannel, String refundTransId) {
        PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
        paymentFlowInfo.setAsynUrl(this.REFUND_RESULT_CALL_BACK);
        StringBuffer payOrderNo = new StringBuffer();
        payOrderNo.append("PAYMENT-").append(null != payableDetailPO.getApplyNo() ? payableDetailPO.getApplyNo() : payableDetailPO.getPayableNo());
        PaymentFlowInfo paymentPO = this.paymentFlowInfoMapper.selectByOutOrderId(payOrderNo.toString());
        if (null != paymentPO) {
            paymentFlowInfo.setPayType(paymentPO.getPayType());
            paymentFlowInfo.setPayName(paymentPO.getRecName());
            paymentFlowInfo.setRecName(paymentPO.getPayName());
            paymentFlowInfo.setOrderCode(paymentPO.getOrderCode());
            paymentFlowInfo.setPayOrgNo(paymentPO.getRecOrgNo());
            paymentFlowInfo.setRecOrgNo(paymentPO.getPayOrgNo());
        }
        paymentFlowInfo.setOutOrderId(refundOrderNo);
        paymentFlowInfo.setReturnOutOrderId(payOrderNo.toString());
        paymentFlowInfo.setOrderAmt(payableDetailPO.getRefundAmt());
        paymentFlowInfo.setOrderDesc("\u8ba2\u5355\u9000\u6b3e");
        paymentFlowInfo.setCreateUserId(reqBO.getOperatorId());
        paymentFlowInfo.setCreateUserName(reqBO.getOperatorName());
        paymentFlowInfo.setFlowFlag(FlowFlag.RETURN_GOODS_REFUND.getCode());
        if (outRefundOrderSn.contains("ORD")) {
            paymentFlowInfo.setFlowFlag(FlowFlag.ORDER_REIMBURSE.getCode());
        }
        paymentFlowInfo.setCreateTime(new Date());
        paymentFlowInfo.setClientIp(reqBO.getIpAddress());
        paymentFlowInfo.setBusiCode(busiCode);
        PaymentFlowInfoExtJsonBO paymentFlowInfoExtJsonBO = new PaymentFlowInfoExtJsonBO();
        paymentFlowInfoExtJsonBO.setOutRefundOrderSn(outRefundOrderSn);
        paymentFlowInfoExtJsonBO.setRefundAmt(canRefundAmt);
        paymentFlowInfo.setExtJson(JSON.toJSONString((Object)paymentFlowInfoExtJsonBO));
        if (null != date) {
            paymentFlowInfo.setPayTime(date);
            paymentFlowInfo.setPaymentStatus(PAY_SUCCESS);
            paymentFlowInfo.setPayType(PayFlowPayType.PAY_TYPE_201.getCode());
        } else {
            paymentFlowInfo.setPayTime(new Date());
            paymentFlowInfo.setPaymentStatus(PAY_SUCCESS);
            paymentFlowInfo.setPayChannel(payChannel);
            paymentFlowInfo.setPaymentFlowId(refundTransId);
        }
        try {
            paymentFlowInfo.setFlowType(Integer.parseInt(reqBO.getFlowType()));
        }
        catch (NumberFormatException e) {
            paymentFlowInfo.setFlowType(0);
            log.error("\u7528\u6237\u7c7b\u578b\u4e0d\u5339\u914d");
        }
        this.paymentFlowInfoMapper.insert(paymentFlowInfo);
    }

    private PayProRefundAbilityRspBo createRefundOrder(PayableDetailPO payableDetailPO, FscRefundOrderOperReqBO reqBO, String refundOrderNo, String busiCode) {
        PayProRefundAbilityReqBo payProRefundAbilityReqBo = new PayProRefundAbilityReqBo();
        StringBuffer payOrderNo = new StringBuffer();
        payOrderNo.append("PAYMENT-").append(payableDetailPO.getApplyNo());
        payProRefundAbilityReqBo.setRefundOutOrderId(refundOrderNo);
        payProRefundAbilityReqBo.setOriOutOrderId(payOrderNo.toString());
        payProRefundAbilityReqBo.setBusiCode(busiCode);
        BigDecimal refundAmtB = payableDetailPO.getRefundAmt().multiply(new BigDecimal(100));
        payProRefundAbilityReqBo.setRefundFee(refundAmtB.setScale(0, 1).toString());
        payProRefundAbilityReqBo.setRefundReason(reqBO.getRefundReason());
        payProRefundAbilityReqBo.setNotifyUrl(this.REFUND_RESULT_CALL_BACK);
        payProRefundAbilityReqBo.setCreateOperId(String.valueOf(reqBO.getOperatorId()));
        payProRefundAbilityReqBo.setCreateOperIdName(reqBO.getOperatorName());
        payProRefundAbilityReqBo.setAppletAppId(reqBO.getAppletAppId());
        List<ApplyDetail> applyDetails = this.applyDetailMapper.selectPayableList(payableDetailPO.getApplyNo());
        BigDecimal paymentAmt = BigDecimal.ZERO;
        for (ApplyDetail applyDetail : applyDetails) {
            paymentAmt = paymentAmt.add(applyDetail.getAmt());
        }
        if (payableDetailPO.getRefundAmt().compareTo(paymentAmt) < 0) {
            payProRefundAbilityReqBo.setOrderType(PART_REFUND);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u652f\u4ed8\u4e2d\u5fc3\u521b\u5efa\u9000\u6b3e\u5355\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)payProRefundAbilityReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        PayProRefundAbilityRspBo payProRefundAbilityRspBo = this.payProRefundAbilityService.dealRefund(payProRefundAbilityReqBo);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u652f\u4ed8\u4e2d\u5fc3\u521b\u5efa\u9000\u6b3e\u5355\u51fa\u53c2:{}", (Object)JSONObject.toJSONString((Object)payProRefundAbilityRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        if (!"0000".equals(payProRefundAbilityRspBo.getRespCode())) {
            log.error("\u521b\u5efa\u9000\u6b3e\u8ba2\u5355[" + payOrderNo.toString() + "]\u5931\u8d25,\uff1a" + payProRefundAbilityRspBo.getRespDesc());
            this.savelog("CreateRefundOrderService-1", JSONObject.toJSONString((Object)payProRefundAbilityReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)payProRefundAbilityRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            throw new PfscExtBusinessException("18000", payProRefundAbilityRspBo.getRespDesc());
        }
        this.savelog("CreateRefundOrderService-2", JSONObject.toJSONString((Object)payProRefundAbilityReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)payProRefundAbilityRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return payProRefundAbilityRspBo;
    }

    private List<PayableDetailPO> getRefundPayableDetailPOS(BigDecimal refundAmtSum, List<PayableDetailPO> payableDetailPOS, String refundSendGoodsNo) {
        ArrayList<PayableDetailPO> refundPayableDetailPOS = new ArrayList<PayableDetailPO>();
        HashMap<String, BigDecimal> refundInfo = new HashMap<String, BigDecimal>(payableDetailPOS.size());
        for (PayableDetailPO payableDetailPO : payableDetailPOS) {
            if (!StringUtils.isBlank((CharSequence)payableDetailPO.getSendGoodsNo()) && !payableDetailPO.getSendGoodsNo().equals(refundSendGoodsNo)) continue;
            if (payableDetailPO.getPendingAmt().compareTo(BigDecimal.ZERO) > 0) {
                throw new PfscExtBusinessException("18000", "\u5b58\u5728\u5e94\u4ed8\u5355\u3010" + payableDetailPO.getPayableNo() + "\u3011\u5904\u4e8e\u4ed8\u6b3e\u4e2d\u72b6\u6001\uff0c\u8bf7\u5f85\u5e94\u4ed8\u5355\u4ed8\u6b3e\u5b8c\u6210\uff0c\u518d\u8fdb\u884c\u9000\u6b3e");
            }
            if (!StringUtils.isBlank((CharSequence)payableDetailPO.getApplyNo())) {
                PaymentFlowInfo flowInfo;
                StringBuffer payOrderNo = new StringBuffer();
                payOrderNo.append("PAYMENT-").append(payableDetailPO.getApplyNo());
                if (refundInfo.get(payOrderNo.toString()) == null && (flowInfo = this.paymentFlowInfoMapper.selectRefundAmt(payOrderNo.toString())) != null && flowInfo.getOrderAmt() != null) {
                    refundInfo.put(payOrderNo.toString(), flowInfo.getOrderAmt());
                }
                if (null != refundInfo.get(payOrderNo.toString()) && ((BigDecimal)refundInfo.get(payOrderNo.toString())).compareTo(BigDecimal.ZERO) > 0) {
                    if (payableDetailPO.getPayableAmt().subtract((BigDecimal)refundInfo.get(payOrderNo.toString())).compareTo(BigDecimal.ZERO) > 0) {
                        payableDetailPO.setPayableAmt(payableDetailPO.getPayableAmt().subtract((BigDecimal)refundInfo.get(payOrderNo.toString())));
                        refundInfo.put(payOrderNo.toString(), BigDecimal.ZERO);
                    } else {
                        refundInfo.put(payOrderNo.toString(), payableDetailPO.getPayableAmt().subtract((BigDecimal)refundInfo.get(payOrderNo.toString())).abs());
                        continue;
                    }
                }
            }
            if ((refundAmtSum = refundAmtSum.subtract(payableDetailPO.getPayableAmt())).compareTo(BigDecimal.ZERO) < 0) {
                payableDetailPO.setRefundAmt(payableDetailPO.getPayableAmt().subtract(refundAmtSum.abs()));
                refundPayableDetailPOS.add(payableDetailPO);
                break;
            }
            payableDetailPO.setRefundAmt(payableDetailPO.getPayableAmt());
            refundPayableDetailPOS.add(payableDetailPO);
            if (refundAmtSum.compareTo(BigDecimal.ZERO) != 0) continue;
            break;
        }
        return refundPayableDetailPOS;
    }
}

