/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.QueryPayableDetailService;
import com.tydic.pfscext.api.busi.bo.PayableDetailBO;
import com.tydic.pfscext.api.busi.bo.QueryPayableDetailReqBO;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.PayablePayType;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrderService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.utils.AntiSqlInjectionManage;
import com.tydic.pfscext.utils.BusinessUtils;
import com.tydic.pfscext.utils.FscStringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.QueryPayableDetailService"})
public class QueryPayableDetailServiceImpl
implements QueryPayableDetailService {
    private static final Logger logger = LoggerFactory.getLogger(QueryPayableDetailServiceImpl.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;

    @PostMapping(value={"queryListPage"})
    public PfscExtRspPageBaseBO<PayableDetailBO> queryListPage(@RequestBody QueryPayableDetailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u9884\u4ed8\u5e94\u4ed8\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getSource()) || reqBO.getSource() == null) {
            throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5217\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1-\u6765\u6e90[source]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null != reqBO.getIsShop() && 0 == reqBO.getIsShop()) {
            reqBO.setSource(OrderSource.PRICE_FRAME.getCode());
        }
        if (reqBO.getIsProfessionalOrgExt().equals("0")) {
            ArrayList<Integer> payableTypes = new ArrayList<Integer>();
            payableTypes.add(1);
            payableTypes.add(8);
            reqBO.setPayableTypes(payableTypes);
        }
        Long operUnitNo = BusinessUtils.judgeOperUnitNo(reqBO.getOperUnitNo(), reqBO.getCompanyId(), false);
        reqBO.setCompanyId(operUnitNo);
        PfscExtRspPageBaseBO rspPageBO = new PfscExtRspPageBaseBO();
        String orderBy = null;
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new PfscExtBusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        } else {
            orderBy = " PAYABLE_NO desc";
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<PayableDetailPO> payableDetailPOs = this.payableDetailMapper.getListPageByTerms(reqBO, (Page<Map<String, Object>>)page, orderBy);
        LinkedList<PayableDetailBO> payableDetailBOs = new LinkedList<PayableDetailBO>();
        HashSet<Long> purchaseOrderIdsSet = null;
        if (!CollectionUtils.isEmpty(payableDetailPOs)) {
            purchaseOrderIdsSet = new HashSet<Long>();
            for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                PayableDetailBO singleDetail = new PayableDetailBO();
                BeanUtils.copyProperties((Object)payableDetailPO, (Object)singleDetail);
                singleDetail.setOrderId(FscStringUtils.valueOf(payableDetailPO.getOrderId()));
                if (payableDetailPO.getOrderId() != null) {
                    purchaseOrderIdsSet.add(payableDetailPO.getOrderId());
                }
                PayableStatus payableEnum = PayableStatus.getInstance(singleDetail.getPayableStatus());
                singleDetail.setPayableStatusStr(this.enumsService.getDescr(payableEnum));
                OrderSource orderSourceEnum = OrderSource.getInstance((String)singleDetail.getSource());
                singleDetail.setSourceStr(this.enumsService.getDescr((BaseEnums)orderSourceEnum));
                String supplierStr = this.organizationInfoService.querySupplierName(singleDetail.getSupplierId());
                singleDetail.setSupplierStr(supplierStr);
                String orgNameStr = this.organizationInfoService.queryOrgName(singleDetail.getOperatorId());
                singleDetail.setOperatorStr(orgNameStr);
                PayablePayType payTypeEnum = PayablePayType.getInstance(singleDetail.getPayType());
                singleDetail.setPayTypeStr(this.enumsService.getDescr(payTypeEnum));
                singleDetail.setPayTypeName(this.enumsService.getDescr(payTypeEnum));
                singleDetail.setProfessionalDepartDescr(this.organizationInfoService.queryOrgName(singleDetail.getProfessionalDepartId()));
                singleDetail.setServiceDepartDescr(this.organizationInfoService.queryServiceDepartName(singleDetail.getServiceDepartId()));
                singleDetail.setBranchCompanyName(this.organizationInfoService.queryOrgName(payableDetailPO.getBranchCompany()));
                singleDetail.setAllInPaying("N");
                if (PayableStatus.SUCCESS.getCode().equals(singleDetail.getPayableStatus()) || PayableStatus.TERMINATION.getCode().equals(singleDetail.getPayableStatus()) || singleDetail.getPayableAmt().compareTo(BigDecimal.ZERO) <= 0) {
                    singleDetail.setAllInPaying("Y");
                } else {
                    ApplyDetail applyDetail = this.applyDetailMapper.selectAmtByPayableNo(singleDetail.getPayableNo());
                    if (singleDetail.getPayableAmt().subtract(applyDetail != null ? applyDetail.getAmt() : BigDecimal.ZERO).subtract(singleDetail.getPaidAmt()).compareTo(BigDecimal.ZERO) == 0) {
                        singleDetail.setAllInPaying("Y");
                    }
                }
                payableDetailBOs.add(singleDetail);
            }
        }
        rspPageBO.setRows(payableDetailBOs);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBO;
    }
}

