/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.QueryhandmadeCollectionByIdService;
import com.tydic.pfscext.api.busi.bo.BusiQueryDetailListRecAmtConfirmRspBO;
import com.tydic.pfscext.api.busi.bo.QueryhandmadeCollectionByIdReqBO;
import com.tydic.pfscext.api.busi.bo.QueryhandmadeCollectionByIdRspBO;
import com.tydic.pfscext.dao.AdvanceReceiveMapper;
import com.tydic.pfscext.dao.po.AdvanceReceive;
import com.tydic.pfscext.dao.vo.AdvanceReceiveVO;
import com.tydic.pfscext.enums.AdvanceReceiveStatus;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.ReceiveType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.utils.FileUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.QueryhandmadeCollectionByIdService"})
public class QueryhandmadeCollectionByIdServiceImpl
implements QueryhandmadeCollectionByIdService {
    private static final Logger logger = LoggerFactory.getLogger(QueryhandmadeCollectionByIdServiceImpl.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;

    @PostMapping(value={"select"})
    public QueryhandmadeCollectionByIdRspBO select(@RequestBody QueryhandmadeCollectionByIdReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u624b\u5de5\u6536\u6b3e\u5355\u8be6\u60c5\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSeq() == null) {
            throw new PfscExtBusinessException("18000", "\u5355\u636e\u7f16\u53f7[seq]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryhandmadeCollectionByIdRspBO rspBO = new QueryhandmadeCollectionByIdRspBO();
        ArrayList<BusiQueryDetailListRecAmtConfirmRspBO> rspBOList = new ArrayList<BusiQueryDetailListRecAmtConfirmRspBO>();
        AdvanceReceiveVO advanceReceiveVO = new AdvanceReceiveVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)advanceReceiveVO);
        List<AdvanceReceive> selectByCondition = this.advanceReceiveMapper.selectByCondition(advanceReceiveVO);
        if (selectByCondition == null || selectByCondition.size() == 0) {
            rspBO.setRows(rspBOList);
            return rspBO;
        }
        for (AdvanceReceive advanceReceive : selectByCondition) {
            BusiQueryDetailListRecAmtConfirmRspBO detail = new BusiQueryDetailListRecAmtConfirmRspBO();
            BeanUtils.copyProperties((Object)advanceReceive, (Object)detail);
            detail.setPayOrgName(this.organizationInfoService.obtainOrgNameByAdvanceReceive(advanceReceive));
            detail.setRecOrgName(this.organizationInfoService.queryOrgName(advanceReceive.getRecOrgId()));
            detail.setRecTypeDescr(this.enumsService.getDescr(ReceiveType.getInstance(advanceReceive.getRecType())));
            detail.setStatusDescr(this.enumsService.getDescr(AdvanceReceiveStatus.getInstance(advanceReceive.getStatus())));
            detail.setSourceName(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)advanceReceive.getSource())));
            detail.setReceiptUrl(FileUtils.obtainOSSUrl(detail.getReceipt()));
            rspBOList.add(detail);
        }
        rspBO.setRows(rspBOList);
        return rspBO;
    }
}

