/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.VerifyPurchaseOrderInfoService;
import com.tydic.pfscext.api.busi.bo.PurchaseOrderVerifyReqBO;
import com.tydic.pfscext.api.busi.bo.QueryPayPurchaseOrderInfoAwaitReqBO;
import com.tydic.pfscext.api.busi.bo.VerifyPurchaseOrderRspBO;
import com.tydic.pfscext.dao.ConfTabStateMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.ConfTabStatePO;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.VerifyPurchaseOrderInfoService"})
public class VerifyPurchaseOrderInfoServiceImpl
implements VerifyPurchaseOrderInfoService {
    private static final Logger logger = LoggerFactory.getLogger(VerifyPurchaseOrderInfoServiceImpl.class);
    @Autowired
    private ConfTabStateMapper confTabStateMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;

    @PostMapping(value={"purchaseOrderVerify"})
    public VerifyPurchaseOrderRspBO purchaseOrderVerify(@RequestBody PurchaseOrderVerifyReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5206\u7b7e\u7ed3\u7b97\u5f00\u7968\u901a\u77e5\u6821\u9a8c\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null == reqBO.getCompanyId()) {
            throw new PfscExtBusinessException("0001", "\u5206\u7b7e\u7ed3\u7b97\u5f00\u7968\u901a\u77e5\u6821\u9a8c-\u8fd0\u8425\u5546\u7f16\u53f7[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        VerifyPurchaseOrderRspBO rspBO = new VerifyPurchaseOrderRspBO();
        if (StringUtils.isEmpty((CharSequence)reqBO.getVerifyFrom())) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u6821\u9a8c\u6765\u6e90\u3010verifyFrom\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        logger.debug("\u6821\u9a8cverifyFrom\u5165\u53c2\uff1a" + reqBO.getVerifyFrom());
        List<Object> payPurchaseOrderInfoList = new ArrayList();
        if ("0".equals(reqBO.getIsSelectOrder())) {
            QueryPayPurchaseOrderInfoAwaitReqBO pageReqBO = reqBO.getQueryPayPurchaseOrderInfoAwaitReqBO();
            if (null == pageReqBO) {
                throw new PfscExtBusinessException("0001", "\u7ed3\u7b97\u5f00\u7968\u901a\u77e5\u6821\u9a8c-\u9875\u9762\u53c2\u6570\u5bf9\u8c61[queryPayPurchaseOrderInfoAwaitReqBO]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String isProfessionalOrgExt = reqBO.getIsProfessionalOrgExt();
            PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
            Object excludeOrg = null;
            if ("0".equals(isProfessionalOrgExt)) {
                if (StringUtils.isEmpty((CharSequence)pageReqBO.getBusiModel())) {
                    vo.setBusiModel(BusiModel.TRADE_MODEL.getCode());
                } else {
                    vo.setBusiModel(pageReqBO.getBusiModel());
                }
                vo.setOperUnitNo(reqBO.getCompanyId());
                if (StringUtils.isNotEmpty((CharSequence)pageReqBO.getPurchaseNo())) {
                    vo.setPurchaseNo(Long.valueOf(pageReqBO.getPurchaseNo()));
                } else {
                    excludeOrg = reqBO.getCompanyId();
                }
                vo.setExcludeOrg((Long)excludeOrg);
            } else if ("1".equals(isProfessionalOrgExt)) {
                vo.setPurchaseNo(reqBO.getCompanyId());
                vo.setBusiModel(BusiModel.MATCH_UP_MODEL.getCode());
                if (StringUtils.isNotEmpty((CharSequence)pageReqBO.getPurchaserId())) {
                    vo.setPurchaserId(Long.valueOf(pageReqBO.getPurchaserId()));
                }
            } else if ("2".equals(isProfessionalOrgExt)) {
                vo.setSupplierNo(reqBO.getSupId());
                vo.setPurchaserId(null);
            }
            if (StringUtils.isNotEmpty((CharSequence)pageReqBO.getPurchaseNo())) {
                vo.setPurchaseNo(Long.valueOf(pageReqBO.getPurchaseNo()));
            }
            if (StringUtils.isNotEmpty((CharSequence)pageReqBO.getPurchaseProjectId())) {
                vo.setPurchaseProjectId(Long.valueOf(pageReqBO.getPurchaseProjectId()));
            }
            if (StringUtils.isNotEmpty((CharSequence)pageReqBO.getSupplierNo())) {
                vo.setSupplierNo(Long.valueOf(pageReqBO.getSupplierNo()));
            }
            if (StringUtils.isNotEmpty((CharSequence)pageReqBO.getActivityId())) {
                vo.setActivityId(Long.parseLong(pageReqBO.getActivityId()));
            }
            ArrayList arrayList = Lists.newArrayList();
            if (!StringUtils.isEmpty((CharSequence)pageReqBO.getHandUpStatus())) {
                arrayList.add(pageReqBO.getHandUpStatus());
            } else if (!StringUtils.isEmpty((CharSequence)pageReqBO.getTabId())) {
                ConfTabStatePO confTabStatePO = this.confTabStateMapper.selectByTabId(Integer.valueOf(pageReqBO.getTabId()));
                Collections.addAll(arrayList, confTabStatePO.getStatusCode().split(","));
            } else {
                arrayList.add(OrderStatus.NO_APPLY.getCode());
                arrayList.add(OrderStatus.HANGING.getCode());
                arrayList.add(OrderStatus.AUTO_HANG_UP.getCode());
                arrayList.add(OrderStatus.SENDING.getCode());
            }
            vo.setOrderStatusCodes(arrayList);
            vo.setPurchaseOrderCode(pageReqBO.getPurchaseOrderCode());
            vo.setExtOrderId(pageReqBO.getExtOrderId());
            vo.setOrderDateStart(pageReqBO.getOrderDateStart());
            vo.setOrderDateEnd(pageReqBO.getOrderDateEnd());
            vo.setPayType(pageReqBO.getPayType());
            if (StringUtils.isNotEmpty((CharSequence)pageReqBO.getInspectionId())) {
                vo.setInspectionId(Long.valueOf(pageReqBO.getInspectionId()));
            }
            vo.setPurchaserName(pageReqBO.getPurchaserName());
            vo.setSource(pageReqBO.getSource());
            vo.setReconciliationStatus(pageReqBO.getReconciliationStatus());
            if ("1".equals(reqBO.getVerifyFrom())) {
                vo.setNoRedundancy("1");
            } else if ("2".equals(reqBO.getVerifyFrom())) {
                vo.setOnlyRedundancy("1");
            }
            payPurchaseOrderInfoList = this.payPurchaseOrderInfoMapper.getPurchaseOrderListPage(vo, (Page<Map<String, Object>>)new Page(-1, -1));
        } else if ("1".equals(reqBO.getIsSelectOrder())) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getInspectionIdList())) {
                throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u6821\u9a8c-\u52fe\u9009\u8ba2\u5355\u5217\u8868[inspectionIdList]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ArrayList inspectionIds = Lists.newArrayList();
            reqBO.getInspectionIdList().stream().forEach(inspectionIdStr -> inspectionIds.add(Long.valueOf(inspectionIdStr)));
            payPurchaseOrderInfoList = this.payPurchaseOrderInfoMapper.getListPurchaseOrderInfo(inspectionIds);
        } else {
            throw new PfscExtBusinessException("0001", "\u5206\u7b7e\u7ed3\u7b97\u5f00\u7968\u901a\u77e5\u6821\u9a8c-\u662f\u5426\u52fe\u9009\u8ba2\u5355[isSelectOrder]\u4e0d\u6b63\u786e");
        }
        if (CollectionUtils.isEmpty(payPurchaseOrderInfoList)) {
            throw new PfscExtBusinessException("0001", "\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        HashSet<Long> purchaseNoSet = new HashSet<Long>();
        HashSet<Long> purchaseProjectIdSet = new HashSet<Long>();
        HashSet<String> supplierNameSet = new HashSet<String>();
        for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfoList) {
            if (StringUtils.isNotEmpty((CharSequence)payPurchaseOrderInfo.getSupplierName())) {
                supplierNameSet.add(payPurchaseOrderInfo.getSupplierName());
            }
            purchaseNoSet.add(payPurchaseOrderInfo.getPurchaseNo());
            purchaseProjectIdSet.add(payPurchaseOrderInfo.getPurchaseProjectId());
            if (OrderStatus.NO_APPLY.getCode().equals(payPurchaseOrderInfo.getOrderStatus())) continue;
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("1001");
            return rspBO;
        }
        if ("1".equals(reqBO.getVerifyFrom()) || "2".equals(reqBO.getVerifyFrom())) {
            if (purchaseNoSet.size() != 1) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("1002");
                return rspBO;
            }
            if (purchaseProjectIdSet.size() != 1) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("1003");
                return rspBO;
            }
        }
        if (!CollectionUtils.isEmpty(supplierNameSet)) {
            String supplierNameArr = ((Object)supplierNameSet).toString();
            rspBO.setSupplierNameArr(supplierNameArr.substring(1, supplierNameArr.length() - 1));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("1000");
        return rspBO;
    }
}

