/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.api.busi.VerifyPushTaxParamAtomService;
import com.tydic.pfscext.api.busi.bo.SaleItemInfoRspBO;
import com.tydic.pfscext.api.busi.bo.VerifyPushTaxParamAtomReqBO;
import com.tydic.pfscext.api.busi.bo.VerifyPushTaxParamAtomRspBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.VerifyPushTaxParamAtomService"})
public class VerifyPushTaxParamAtomServiceImpl
implements VerifyPushTaxParamAtomService {
    private static final Logger log = LoggerFactory.getLogger(VerifyPushTaxParamAtomServiceImpl.class);
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    private static final Integer UPSTREAM_STATUS_YES = 1;
    private static final Integer UPSTREAM_STATUS_NO = 0;

    @PostMapping(value={"verifyParam"})
    public VerifyPushTaxParamAtomRspBO verifyParam(@RequestBody VerifyPushTaxParamAtomReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getApplyNoList())) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.info("\u5f00\u7968\u7533\u8bf7\u5355\u63a8\u9001\u7a0e\u63a7\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        VerifyPushTaxParamAtomRspBO rspBO = new VerifyPushTaxParamAtomRspBO();
        rspBO.setUpstreamStatus(UPSTREAM_STATUS_YES);
        rspBO.setZeroTaxConfirm("1");
        List<String> orderCodeList = this.saleOrderInfoMapper.checkOrderStatus(reqBO.getApplyNoList());
        if (!CollectionUtils.isEmpty(orderCodeList)) {
            rspBO.setRespCode("0000");
            rspBO.setOrderCodeList(orderCodeList);
            rspBO.setUpstreamStatus(UPSTREAM_STATUS_NO);
            rspBO.setRespDesc("\u4e0a\u6e38\u5b58\u5728\u672a\u83b7\u53d6\u53d1\u7968\u7684\u8ba2\u5355");
            return rspBO;
        }
        List<String> applyNoList = this.billApplyInfoMapper.getListByApplyNoList(reqBO.getApplyNoList());
        if (!CollectionUtils.isEmpty(applyNoList)) {
            log.error(reqBO.getApplyNoList().toString() + "\u5b58\u5728\u5f00\u7968\u7533\u8bf7\u5df2\u7ecf");
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u9009\u4e2d\u7684\u5f00\u7968\u7533\u8bf7\u5355\u5df2\u7ecf\u63a8\u9001\u5b8c\u6210\u6216\u8005\u6b63\u5728\u63a8\u9001\u4e2d\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u63a8\u9001!");
            rspBO.setPushingTaxApplyNos(applyNoList);
            return rspBO;
        }
        List<SaleItemInfo> nullTaxCodeList = this.saleItemInfoMapper.getNullTaxCodeList(reqBO.getApplyNoList());
        if (!CollectionUtils.isEmpty(nullTaxCodeList)) {
            ArrayList itemInfoList = new ArrayList();
            nullTaxCodeList.stream().forEach(saleItemInfo -> {
                SaleItemInfoRspBO itemInfoRspBO = new SaleItemInfoRspBO();
                BeanUtils.copyProperties((Object)saleItemInfo, (Object)itemInfoRspBO);
                itemInfoList.add(itemInfoRspBO);
            });
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5931\u8d25");
            rspBO.setNullTaxCodeFlag("1");
            rspBO.setNullTaxCodeList(itemInfoList);
        }
        if (!"1".equals(reqBO.getZeroTaxConfirm())) {
            ArrayList<String> zeroTaxApplyNos = new ArrayList<String>();
            for (String applyNo : reqBO.getApplyNoList()) {
                int zeroTaxItemCount = this.saleItemInfoMapper.getZeroTaxItemByApply(applyNo);
                if (zeroTaxItemCount <= 0) continue;
                zeroTaxApplyNos.add(applyNo);
            }
            if (!CollectionUtils.isEmpty(zeroTaxApplyNos)) {
                log.error(reqBO.getApplyNoList().toString() + "\u5b58\u57280\u7a05\u7387\u5546\u54c1\uff0c\u8fd4\u56de\u524d\u7aef\u5f85\u7528\u6237\u786e\u8ba4");
                rspBO.setZeroTaxConfirm("0");
                rspBO.setRespCode("0000");
                rspBO.setZeroTaxApplyNos(zeroTaxApplyNos);
                return rspBO;
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

