/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.pfscext.api.busi.VerifyPushTaxParamExportService;
import com.tydic.pfscext.api.busi.bo.VerifyPushTaxParamExportApplyNoBO;
import com.tydic.pfscext.api.busi.bo.VerifyPushTaxParamExportApplyNoRspBO;
import com.tydic.pfscext.api.busi.bo.VerifyPushTaxParamExportOrderBO;
import com.tydic.pfscext.api.busi.bo.VerifyPushTaxParamExportOrderRspBO;
import com.tydic.pfscext.api.busi.bo.VerifyPushTaxParamExportReqBO;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.ExcelUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.VerifyPushTaxParamExportService"})
public class VerifyPushTaxParamExportServiceImpl
implements VerifyPushTaxParamExportService {
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers}")
    private String fastdfsTrackerServers;
    @Value(value="${export.file.public.url}")
    private String exportFilePublicUrl;

    @PostMapping(value={"exportOrderList"})
    public VerifyPushTaxParamExportOrderRspBO exportOrderList(@RequestBody VerifyPushTaxParamExportReqBO reqBO) {
        VerifyPushTaxParamExportOrderRspBO rspBO = new VerifyPushTaxParamExportOrderRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getApplyNoList())) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<VerifyPushTaxParamExportOrderBO> orderCodeList = this.saleOrderInfoMapper.getOrderListCheckOrderStatus(reqBO.getApplyNoList());
        int index = 0;
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>();
        for (VerifyPushTaxParamExportOrderBO verifyPushTaxParamExportOrderBO : orderCodeList) {
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
            item.put("\u5e8f\u53f7", ++index);
            item.put("\u9a8c\u6536\u5355\u53f7", verifyPushTaxParamExportOrderBO.getInspectionId() == null ? "" : verifyPushTaxParamExportOrderBO.getInspectionId());
            item.put("\u7533\u8bf7\u5355\u53f7", verifyPushTaxParamExportOrderBO.getApplyNo() == null ? "" : verifyPushTaxParamExportOrderBO.getApplyNo());
            item.put("\u8ba2\u5355\u53f7", verifyPushTaxParamExportOrderBO.getPurchaseOrderCode() == null ? "" : verifyPushTaxParamExportOrderBO.getPurchaseOrderCode());
            exportData.add(item);
        }
        this.uploadFile(exportData, rspBO);
        String fullFilePath = "";
        if ("OSS".equals(this.fileType)) {
            fullFilePath = rspBO.getFilePath();
        } else if ("FASTDFS".equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)rspBO.getFilePath());
            fullFilePath = this.exportFilePublicUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        }
        rspBO.setFullFilePath(fullFilePath);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"exportApplyNoList"})
    public VerifyPushTaxParamExportApplyNoRspBO exportApplyNoList(@RequestBody VerifyPushTaxParamExportReqBO reqBO) {
        VerifyPushTaxParamExportApplyNoRspBO rspBO = new VerifyPushTaxParamExportApplyNoRspBO();
        ArrayList<VerifyPushTaxParamExportApplyNoBO> verifyPushTaxParamExportApplyNoBOS = new ArrayList<VerifyPushTaxParamExportApplyNoBO>();
        for (String applyNo : reqBO.getApplyNoList()) {
            int zeroTaxItemCount = this.saleItemInfoMapper.getZeroTaxItemByApply(applyNo);
            if (zeroTaxItemCount <= 0) continue;
            VerifyPushTaxParamExportApplyNoBO applyNoBO = new VerifyPushTaxParamExportApplyNoBO();
            applyNoBO.setApplyNo(applyNo);
            verifyPushTaxParamExportApplyNoBOS.add(applyNoBO);
        }
        int index = 0;
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>();
        for (VerifyPushTaxParamExportApplyNoBO verifyPushTaxParamExportApplyNoBO : verifyPushTaxParamExportApplyNoBOS) {
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
            item.put("\u5e8f\u53f7", ++index);
            item.put("\u7533\u8bf7\u5355\u53f7", verifyPushTaxParamExportApplyNoBO.getApplyNo() == null ? "" : verifyPushTaxParamExportApplyNoBO.getApplyNo());
            exportData.add(item);
        }
        this.uploadFile2(exportData, rspBO);
        String fullFilePath = "";
        if ("OSS".equals(this.fileType)) {
            fullFilePath = rspBO.getFilePath();
        } else if ("FASTDFS".equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)rspBO.getFilePath());
            fullFilePath = this.exportFilePublicUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        }
        rspBO.setFullFilePath(fullFilePath);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void uploadFile(List<Map<String, Object>> data, VerifyPushTaxParamExportOrderRspBO rspBO) {
        SXSSFWorkbook workbook = ExcelUtils.createWorkbook(data, "\u4e0a\u6e38\u672a\u6536\u7968\u8ba2\u5355");
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        String uploadPath = "fsc";
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
        String date = df.format(new Date());
        String name = "0\u7a0e\u7387\u5546\u54c1\u6240\u5728\u5f00\u7968\u7533\u8bf7\u5355\u53f7" + date;
        String fileName = name + ".xlsx";
        try {
            out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            byte[] buff = out.toByteArray();
            in = new ByteArrayInputStream(buff);
            String result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)in);
            rspBO.setFilePath(result);
            rspBO.setFileClientType(this.fileType);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new BusinessException("0001", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((Closeable)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        IOUtils.closeQuietly((Closeable)out);
    }

    private void uploadFile2(List<Map<String, Object>> data, VerifyPushTaxParamExportApplyNoRspBO rspBO) {
        SXSSFWorkbook workbook = ExcelUtils.createWorkbook(data, "0\u7a0e\u7387\u5546\u54c1\u6240\u5728\u5f00\u7968\u7533\u8bf7\u5355\u53f7");
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        String uploadPath = "fsc";
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
        String date = df.format(new Date());
        String name = "0\u7a0e\u7387\u5546\u54c1\u6240\u5728\u5f00\u7968\u7533\u8bf7\u5355\u53f7" + date;
        String fileName = name + ".xlsx";
        try {
            out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            byte[] buff = out.toByteArray();
            in = new ByteArrayInputStream(buff);
            String result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)in);
            rspBO.setFilePath(result);
            rspBO.setFileClientType(this.fileType);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new BusinessException("0001", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((Closeable)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        IOUtils.closeQuietly((Closeable)out);
    }
}

